/*
  a FFT filter with real/imagery part (can calculate inverse fft!)
  Copyright (C) 1998  Martin Vogt;Philip VanBaren, 2 September 1993

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __FFTFILTER_H
#define __FFTFILTER_H



#include <filter/filter.h>
#include <util/fft.h>



  

class FFTFilter : public Filter {

  FFT* fft;
  int fftPoints;
  float* data;  // size of 2*fftPoints because complex
  float* window;
  
 public:
  FFTFilter(int fftPoints);
  ~FFTFilter();
  int fft16(DeviceConfig* input);
  void inverseFFT16(float* data);
  int getPoints();
  float* getPointPtr();

 private:
   int min(int x1,int x2);

};


#endif
