/*
  changes the volume in the stream.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __VOLUMEDEVICE_H
#define __VOLUMEDEVICE_H

#include <devices/outputDevice.h>

#include <filter/volumeFilter.h>


class VolumeDevice : public OutputDevice {

  DeviceConfigArray* configArray;
  VolumeFilter* volumeFilter;
  float volume;
  int balance;
  float leftFutureVolume;
  float rightFutureVolume;

  float leftCurrentVolume;
  float rightCurrentVolume;
  

 public:

  VolumeDevice();
  ~VolumeDevice();
  char* getNodeName();
  

  // Note: in a Streambuffer we have the Sender/Source of this buffer piece
  void writeIn(NodeDevice* source,DeviceConfig* buf);

  void setVolume(int percent);
  int getVolume();

  void setBalance(int range);
  int getBalance();

 private:
   void calculateVolume();

};



#endif
