/*
  produces data and sends them through the device graph
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/streamProducer.h>
#include "../../../../config.h"


static int producerCounter=0;



StreamProducer::StreamProducer():OutputDevice("StreamProducer")  {
  cThreadPos="Constructor";
  DaisyChain* daisyChain=(DaisyChain*)getDaisyChain();
  nBlockCounter=0;
  mode=_STREAMPRODUCER_DELIVERS_CONTINOUS;
  runCredit=0;
  instanz=producerCounter;
  producerCounter++;

  daisyChain->addElement(this);
}



StreamProducer::~StreamProducer() {
  lockDeviceTree();
  DaisyChain* daisyChain=(DaisyChain*)NodeDevice::getDaisyChain();
  daisyChain->removeAllLocks(this);
  daisyChain->removeElement(this);
  unlockDeviceTree();
}


int StreamProducer::getInstanzCounter() {
  return instanz;
}



int StreamProducer::waitForUnblock() {
  DaisyChain* daisyChain=(DaisyChain*)getDaisyChain();
  return daisyChain->hasLock(this);
}
  
 
void StreamProducer::setDeliverMode(int mode) {
  writeInLock();
  this->mode=mode;
  writeInUnlock();
}

  
void StreamProducer::wakeup() {
  writeInLock();
  runCredit=1;
  writeInUnlock();
}


int StreamProducer::getDeliverMode() {
  return mode;
}
  
 

int StreamProducer::getRunCredit() {
  return runCredit;
}
  

void StreamProducer::setRunCredit(int value) {
  runCredit=value;
}



void StreamProducer::dumpThread() {
  debugOutput( cout << "dumpThread:streamProducer"<<endl );
  debugOutput( cout << cThreadPos<<" BlockCounter:" <<nBlockCounter<<" pid:" <<pid <<"instanz:"<<instanz<<endl );
}








