/*
  mixes a DeviceConfigArray and delivers the result to the listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/mixerDevice.h>



MixerDevice::MixerDevice() {
  AudioBuffer* audioBuffer;

  pcmChunk=new MemChunk(_MAX_PCM_BUFFER);
  config=new DeviceConfig();
  
  AudioStream* audioStream=config->getAudioStream();
  audioBuffer=audioStream->getAudioBuffer();
  audioBuffer->setMemChunk(pcmChunk);
  mixerFilter=new MixerFilter();
  volumeFilter=new VolumeFilter();
}


MixerDevice::~MixerDevice() {
  delete pcmChunk;
  delete mixerFilter;
  delete volumeFilter;
}


void MixerDevice::writeOut(DeviceConfigArray* buf) {
  NodeDevice* nodeDevice;
  Edges* edges=getListeners();
  Edges* sources=getSources();
  int n=edges->getElements();
  int i;
  int elements=buf->getEntries();

  StatusInfo* statusInfo=config->getStatusInfo();

  if (elements == 0) {
    return;
  }

  // If we only have on element in the array there is
  // nothing to mix
  if (sources->getElements() == 1) {
    DeviceConfig* deviceConfig=buf->getDeviceConfigAt(0);
    statusInfo=deviceConfig->getStatusInfo();

    for(i=0;i<n;i++) {
      nodeDevice=edges->getNodeDevice(i);
      nodeDevice->writeInLock();
      nodeDevice->writeIn(this,deviceConfig);
      nodeDevice->writeInUnlock();
    }
    return;
  }


  // First we mix the volume for all inputs:
  for(i=0;i<elements;i++) {
    volumeFilter->transform(buf->getDeviceConfigAt(i));
  }
  mixerFilter->transform(buf,config);
  

  for(i=0;i<n;i++) {
    nodeDevice=edges->getNodeDevice(i);
    nodeDevice->writeInLock();
    nodeDevice->writeIn(this,config);
    nodeDevice->writeInUnlock();
  }

}


  
