/*
  this class stores important data about audio streams
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __AUDIOSTREAM_H
#define __AUDIOSTREAM_H

#include <deviceConfig/info/audioBuffer.h>
#include <deviceConfig/info/audioInfo.h>
#include <deviceConfig/info/musicInfo.h>
#include <deviceConfig/info/timeInfo.h>
#include <deviceConfig/info/statusInfo.h>
#include <deviceConfig/info/volumeInfo.h>
#include <deviceConfig/stream/stream.h>


class AudioStream : public Stream {

  AudioBuffer* audioBuffer;
  AudioInfo* audioInfo;
  MusicInfo* musicInfo;
  TimeInfo* timeInfo;
  StatusInfo* statusInfo;
  VolumeInfo* volumeInfo;


 public:
  AudioStream();
  ~AudioStream();

  void setAudioInfo(AudioInfo* audioInfo); 
  AudioInfo* getAudioInfo(); 

  void setVolumeInfo(VolumeInfo* volumeInfo); 
  VolumeInfo* getVolumeInfo(); 
  
  void setMusicInfo(MusicInfo* musicInfo);
  MusicInfo* getMusicInfo();
  
  void setAudioBuffer(AudioBuffer* audioBuffer); 
  AudioBuffer* getAudioBuffer(); 
 
  void setTimeInfo(TimeInfo* timeInfo);
  TimeInfo* getTimeInfo();

  void forward();
  void print();
  void copyTo(AudioStream* dest);
  int isValid();
  void addLock();
  void removeLock();

};
#endif
