/*
  stores the time of the current stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/info/timeInfo.h>


TimeInfo::TimeInfo() {
  secs=0;
  offset=0;
}


TimeInfo::~TimeInfo() {
}


void TimeInfo::setSec(int secs) {
  this->secs=secs;
  setChange(true);
}


int TimeInfo::getSec() {
  return secs;
}



void TimeInfo::copyTo(TimeInfo* dest) {
  dest->setSec(getSec());
  dest->setTimeOffset(getTimeOffset());
  dest->setChange(getChange());
  
}


void TimeInfo::print() {
  cout << "TimeInfo - print [START]"<<endl;
  cout << "TimeInfo :"<<secs<<endl;
  cout << "TimeOffset:"<<offset<<endl;
  cout << "TimeInfo - print [END]"<<endl;
}



int TimeInfo::getTotalSec() {
  return offset+secs;
}


void TimeInfo::setTimeOffset(int sec) {
  offset=sec;
  setChange(true);
}


int TimeInfo::getTimeOffset() {
  return offset;
}

