/*
  functions for an interface between a yafDecoder and the GNOME-emusic Interf.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <yafxplayer/yaf2Emusic.h>
#include "../../../../../config.h"


static InputInterface* input;
static int fd[2];
static player_plugin* plugin;


void setPlugin(player_plugin* aPlugIn) {
  plugin=aPlugIn;
}

                                         
int setup_audio(int frequency, int stereo, int sign, int big, int sixteen) {
  StreamWriter_sendStreamInfo(stereo+1,16,frequency);
  return 1;
}



void set_bitrate(int bit) {
  debugOutput( cout << "set_bitrate called !" <<endl );
  return;
}


void close_audio(void) {
}


void flush_audio(void) {
  if (plugin->getStreamState() == _STREAM_STATE_EOF) {
    enterMessage("off\n");
  }
}


 
int parsebool(char *data) {
  debugOutput( cout << "parsebool called!"<<endl );
  return 1;
}


int audio_play(char *buffer, int size) {
  StreamWriter_writeStream(buffer,size);
  return 1;
}


int enterMessage(char* msg) {
  input->write(fd[1],msg);
  return 0;
}


void setInputInterface(InputInterface* in) {
  input=in;
  ::pipe(fd);
  if (errno < 0) {
    perror("setInputInterface pipe");
    exit(0);
  }
  input->addFileDescriptor(fd[0]);
}


  
                                                

