/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <kapp.h>
#include <kurl.h>
#include <qstring.h>
#include <stdio.h>
#include "song.h"
#include <iostream.h>
#include "kjukebox.h"
#include "mp3tag.h"

Song::Song(){
  filename = "";
  title = "";
  artist = "";
  album = "";
  comment = "";
  genre = "";
  stereomode = "";
  layer = "";

  played = false;
  lastplayed = 0;
  size=0;
  bitrate = 0;
  samplerate=0;
  year=0;
  seconds=0;
  firstSeconds=0;
  lastSeconds=0;
  genreNumber = 80;
  nullFlag = true;
}

bool Song::isNull(){  return nullFlag; }

QString Song::asQString(unsigned int value){
  char tmp[1000];
  sprintf(tmp,"%d",value);
  return ((QString)tmp);
}

QString Song::asString(){
  return asString(SAVELOADFORMAT,SAVELOADTRENNZEICHEN);
}



QString Song::asString(QString format, QString trennzeichen){
  int startFormat;
  QString tmp;
  QString output = "";
  bool first = true;

  startFormat = -1;
  
  while(1){  
    if(!first) {
      output += trennzeichen;
      startFormat = format.find(trennzeichen,startFormat);
      if(startFormat == -1) break;
    }
    startFormat++;
    tmp = format.mid(startFormat,2);
    //    cout << "SF:" << startFormat << " tmp:" << tmp << endl;
    
    if     (strncmp(tmp,"FN",2)==0) output += filename;
    else if(strncmp(tmp,"TI",2)==0) output += title;
    else if(strncmp(tmp,"AR",2)==0) output += artist;
    else if(strncmp(tmp,"AL",2)==0) output += album;
    else if(strncmp(tmp,"CO",2)==0) output += comment;
    else if(strncmp(tmp,"GE",2)==0) output += genre;
    else if(strncmp(tmp,"LA",2)==0) output += layer;
    else if(strncmp(tmp,"ST",2)==0) output += stereomode;
    else if(strncmp(tmp,"BI",2)==0) output += asQString(bitrate);
    else if(strncmp(tmp,"SA",2)==0) output += asQString(samplerate);
    else if(strncmp(tmp,"SE",2)==0) output += asQString(seconds);
    else if(strncmp(tmp,"SI",2)==0) output += asQString(size);
    else if(strncmp(tmp,"YE",2)==0) output += asQString(year);
    else if(strncmp(tmp,"FS",2)==0) output += asQString(firstSeconds);
    else if(strncmp(tmp,"LS",2)==0) output += asQString(lastSeconds);

    first = false;
  }
  //  cout << output << endl;
  return output;
}


void Song::initFromString(QString text){
  initFromString(text, SAVELOADFORMAT, SAVELOADTRENNZEICHEN);
}



void Song::initFromString(QString text, QString format, QString trennzeichen){
  int startText, endText;
  int startFormat;
  QString tmp, value;
  bool first = true;

  startText = endText = -1;
  startFormat = -1;

  while(1){  
    if(!first) {
      startFormat = format.find(trennzeichen,startFormat);
      startText   = text.find(trennzeichen,startText);
      if((startFormat == -1)||(startText == -1)) break;
    }
    startFormat++;
    tmp = format.mid(startFormat,2);

    startText++;
    endText = text.find(trennzeichen,startText);
    if(endText == -1) endText = 10000;
    value = text.mid(startText,endText-startText);

    //    cout << "tag:" << tmp << "  value:" << value << endl;

    if(strncmp(tmp,"FN",2)==0) filename = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"TI",2)==0) title = text.mid(startText, endText-startText);
    else if(strncmp(tmp,"AR",2)==0) artist = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"AL",2)==0) album = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"CO",2)==0) comment = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"GE",2)==0) genre = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"LA",2)==0) layer = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"ST",2)==0) stereomode = text.mid(startText,endText-startText);
    else if(strncmp(tmp,"BI",2)==0) bitrate = value.toUInt();
    else if(strncmp(tmp,"SA",2)==0) samplerate = value.toUInt();
    else if(strncmp(tmp,"SE",2)==0) seconds = value.toUInt();
    else if(strncmp(tmp,"SI",2)==0) size = value.toUInt();
    else if(strncmp(tmp,"YE",2)==0) year = value.toUInt();
    else if(strncmp(tmp,"FS",2)==0) firstSeconds = value.toInt();
    else if(strncmp(tmp,"LS",2)==0) lastSeconds  = value.toInt();
    first = false;
  }
  checkForPlausibility();
  createSortStrings();
}


void Song::checkForPlausibility(){
  QString help;
  static int unknownFileCounter=0;
  help = filename;
  help.simplifyWhiteSpace();
  if(help.isEmpty()) {
    unknownFileCounter++;
    help = i18n("Unknown File");
    help.sprintf(i18n("Unknown File %d"), unknownFileCounter);
  }
  checkForPlausibility(help);
}

void Song::checkForPlausibility(QString helpFilename){
  QString help;
  int fs, ls, tmp;

  help = title;
  help.simplifyWhiteSpace();
  if(help.isEmpty()){
    KURL url(helpFilename);
    title =  url.filename();
  }
  else title = help;
  
  help = artist;
  help.simplifyWhiteSpace();
  if(help.isEmpty()) artist = i18n("Unknown");
  else artist = help;
  
  help = album;
  help.simplifyWhiteSpace();
  if(help.isEmpty()) album = i18n("Unknown");
  else album = help;
  
  help = comment;
  help.simplifyWhiteSpace();
  if(help.isEmpty()) comment = i18n("No Comment");
  else comment = help;
  
  help = genre;
  help.simplifyWhiteSpace();
  if(help.isEmpty()) genre = "Other";
  else genre = help;
  
  tmp = sscanf(comment,MP3_COMMENT_FIELD,&fs,&ls);
  if (tmp == 2){
    firstSeconds = fs;
    lastSeconds = ls;
  }

  KConfig *config = (KApplication::getKApplication())->getConfig();
  config->setGroup(KCONFIG_GENERAL);
  if(config->readBoolEntry(KCONFIG_GENERAL_UPCASE,false)){
    upcaseFirstLetters();
  }
}

void Song::setTitle(QString wert, bool refresh=true){ 
  title = wert;  
  if(refresh) createSortStrings();
}
void Song::setArtist(QString wert, bool refresh=true){ 
  artist = wert;  
  if(refresh) createSortStrings();
}
void Song::setAlbum(QString wert, bool refresh=true){ 
  album = wert;  
  if(refresh) createSortStrings();
}
void Song::setComment(QString wert, bool refresh=true){ 
  comment = wert;  
  if(refresh) createSortStrings();
}
void Song::setGenre(QString wert, bool refresh=true){ 
  genre = wert;  
  genreNumber = Tag::getGenreAsNumber(wert);
  if(refresh) createSortStrings();
}
void Song::setFilename(QString wert, bool refresh=true){ 
  filename = wert;  
  if(refresh) createSortStrings();
}
void Song::setStereomode(QString wert, bool refresh=true){ 
  stereomode = wert;  
  if(refresh) createSortStrings();
}
void Song::setLayer(QString wert, bool refresh=true){ 
  layer = wert;  
  if(refresh) createSortStrings();
}
void Song::setPlayed(bool wert, bool refresh=true){  
  played = wert;  
  if(refresh) createSortStrings();
}
void Song::setGenreNum(int wert, bool refresh=true){ 
  genreNumber = wert;  
  genre = Tag::getGenreAsString(wert);
  if(refresh) createSortStrings();
}
void Song::setLastPlayed(unsigned int  wert, bool refresh=true){  
  played = true; 
  lastplayed = wert; 
  if(refresh) createSortStrings();
}
void Song::setSamplerate(unsigned int wert, bool refresh=true){ 
  samplerate = wert;  
  if(refresh) createSortStrings();
}
void Song::setBitrate(unsigned int wert, bool refresh=true){ 
  bitrate = wert;  
  if(refresh) createSortStrings();
}
void Song::setYear(unsigned int  wert, bool refresh=true){ 
  year = wert;  
  if(refresh) createSortStrings();
}
void Song::setSeconds(unsigned int  wert, bool refresh=true){ 
  seconds = wert;  
  if(refresh) createSortStrings();
}
void Song::setFirstSeconds(unsigned int  wert, bool refresh=true){ 
  firstSeconds = wert;  
  if(refresh) createSortStrings();
}
void Song::setLastSeconds(unsigned int  wert, bool refresh=true){
  lastSeconds = wert;  
  if(refresh) createSortStrings();
}
void Song::setSize(unsigned int  wert, bool refresh=true){ 
  size = wert;  
  if(refresh) createSortStrings();
}
QString Song::getTitle()   const { return  title; }
QString Song::getArtist()  const { return  artist; }
QString Song::getAlbum()   const { return  album; }
QString Song::getComment() const { return  comment; }
QString Song::getGenre()   const { return  genre; }
QString Song::getFilename() const{ return  filename; }
QString Song::getStereomode() const{return stereomode; }
QString Song::getLayer() const{return layer; }
bool    Song::getPlayed()  const { return  played; }
int     Song::getGenreNum() const {return genreNumber; }
unsigned int Song::getLastPlayed() const {return lastplayed; }
unsigned int Song::getSamplerate() const { return  samplerate; }
unsigned int Song::getBitrate() const { return  bitrate; }
unsigned int Song::getYear() const { return  year; }
unsigned int Song::getSeconds() const { return  seconds; }
unsigned int Song::getFirstSeconds() const { return  firstSeconds; }
unsigned int Song::getLastSeconds() const { return  lastSeconds; }
unsigned int Song::getSize() const { return  size; }


void Song::createSortStrings(){
  nullFlag=false;

  artistAlbumTitleSortString.sprintf("%-30s%-30s%-30s",
				     artist.data(),album.data(),title.data());
  titleArtistAlbumSortString.sprintf("%-30s%-30s%-30s",
				     title.data(),artist.data(),album.data());
  //  cout << "ArAlTi:" << artistAlbumTitleSortString << endl;
  //  cout << "TiArAl:" << titleArtistAlbumSortString << endl;
}

QString Song::getArtistAlbumTitle(){ return artistAlbumTitleSortString; }
QString Song::getTitleArtistAlbum(){ return titleArtistAlbumSortString; }

bool Song::operator== (Song song){
  if (strcmp(title,song.getTitle())) return false;
  if (strcmp(artist,song.getArtist())) return false;
  if (strcmp(album,song.getAlbum())) return false;
  if (strcmp(comment,song.getComment())) return false;
  //  if (strcmp(genre,song.getGenre())) return false;
  if (genreNumber != song.getGenreNum()) return false;
  if (strcmp(filename,song.getFilename())) return false;
  if (strcmp(stereomode,song.getStereomode())) return false;
  if (strcmp(layer,song.getLayer())) return false;
  if (samplerate != song.getSamplerate()) return false;
  if (bitrate != song.getBitrate()) return false;
  if (year != song.getYear()) return false;
  if (seconds != song.getSeconds()) return false;
  if (size != song.getSize()) return false;
  return true;
}

bool Song::operator< (Song song){
  if (strcmp(title,song.getTitle()) < 0) return false;
  if (strcmp(artist,song.getArtist()) < 0) return false;
  if (strcmp(album,song.getAlbum()) < 0) return false;
  if (strcmp(comment,song.getComment()) < 0) return false;
  //  if (strcmp(genre,song.getGenre()) < 0) return false; 
  if (genreNumber <= song.getGenreNum()) return false;
  if (strcmp(filename,song.getFilename()) < 0) return false;
  if (strcmp(stereomode,song.getStereomode()) < 0) return false;
  if (strcmp(layer,song.getLayer()) < 0) return false;
  if (samplerate <= song.getSamplerate()) return false;
  if (bitrate <= song.getBitrate()) return false;
  if (year <= song.getYear()) return false;
  if (seconds <= song.getSeconds()) return false;
  if (size <= song.getSize()) return false;
  return true;
}


void Song::upcaseFirstLetters(QString *text){
  int index = 0;

  *text = text->replace(index,1, text->mid(index,1).upper());
  index = text->find(' ',index);
  while(index != -1){
    index++;
    *text = text->replace(index,1, text->mid(index,1).upper());
    index = text->find(' ',index);
  }
}


void Song::upcaseFirstLetters(){
  upcaseFirstLetters(&title);
  upcaseFirstLetters(&album);
  upcaseFirstLetters(&artist);
}




void Song::print(){
  cout << "Filename  :" << filename.data() << endl;
  cout << "Size      :" << size << endl;
  cout << "Title     :" << title.data() << endl;
  cout << "Artist    :" << artist.data() << endl;
  cout << "Album     :" << album.data() << endl;
  cout << "Comment   :" << comment.data() << endl;
  cout << "Genre     :" << genre.data() << endl;
  cout << "Year      :" << year << endl;

  cout << "Stereo    :" << stereomode.data() << endl;
  cout << "Layer     :" << layer.data() << endl;
  cout << "GenNr.    :" << genreNumber << endl;
  cout << "Samplerate:" << samplerate << endl;
  cout << "Bitrate   :" << bitrate << endl;
  cout << "Seconds   :" << seconds << endl;

  cout << "LastPlayed:" << lastplayed << endl;
  cout << "Played    :" << played << endl;
  cout << "FirstSec  :" << firstSeconds << endl;
  cout << "LastSec   :" << lastSeconds << endl;
}
