/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef PRINTER_H
#define PRINTER_H

#include <kapp.h>
#include <kconfig.h>
#include <kstatusbar.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qpainter.h>
#include <qpaintdevice.h>
#include <qwmatrix.h> 
#include <qscrollbar.h> 
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include "lists.h"

class Printer;
class PrinterSettings;
class PrinterPreview;

/*
 *********************************************************************
 **                                                                 **
 **    Printer Settings                                             **
 **                                                                 **
 *********************************************************************
 */
class PrinterSettings : public QDialog{
  Q_OBJECT
 private:
  KConfig *config;
  QFont    font;
  int      tab1;
  int      tab2;
  QGroupBox *fontBox;
  QComboBox *family;
  QLabel    *familyLabel;
  QComboBox *weight;
  QLabel    *weightLabel;
  QLineEdit *size;
  QLabel    *sizeLabel;
  QCheckBox *italic;
  QGroupBox *tabBox;
  QLabel    *tabLabel;
  QLineEdit *tabTwo;
  QLineEdit *tabOne;

  QPushButton *acceptButton;
  QPushButton *applyButton;
  QPushButton *cancelButton;
  
 public:
  PrinterSettings( QWidget *, const char *);
  QFont getFont() const;
  int   getTab1() const;
  int   getTab2() const;

 protected:
  void resizeEvent(QResizeEvent *);

 public slots:
  void refresh();
  void apply();
  void accept();
  void cancel();
  void open();
  void close();

 signals:
  void newParameter(QFont,int , int );  
  void fontChanged();
};


/*
 *********************************************************************
 **                                                                 **
 **    Printer Preview Window                                       **
 **                                                                 **
 *********************************************************************
 */
class PrinterPreviewWindow : public QWidget{
  Q_OBJECT
 private:
  Printer      *printer;
  int currentPage;

 protected:
  void paintEvent(QPaintEvent *);
  void resizeEvent(QResizeEvent *);
  
 public:
  PrinterPreviewWindow( QWidget *, const char *);
  void setPrinter(Printer *);
 
 public slots:
  void setPage(int nr);
};


/*
 *********************************************************************
 **                                                                 **
 **    Printer Preview                                              **
 **                                                                 **
 *********************************************************************
 */
class PrinterPreview : public QDialog{
  Q_OBJECT
 private:
  PrinterPreviewWindow  *painter;
  QPushButton  *closeButton;
  QPushButton  *settingButton;
  QPushButton  *printButton;
  QLabel       *pagesLabel;
  QScrollBar   *scrollBar;
  Printer      *printer;
  int totalPages;
  int currentPage;
  void updatePagesLabel();

 public:
  PrinterPreview( QWidget *, const char *, Printer *);

 protected:
  void resizeEvent(QResizeEvent *);

 private slots:
  void setCurrentPage(int);

 public slots:
  void close();
  void open();
  void refresh();
  void setPages(int);
  

 signals:
  void print();
  void openSettings();
};


/*
 *********************************************************************
 **                                                                 **
 **    Printer                                                      **
 **                                                                 **
 *********************************************************************
 */
class Printer : public QObject{
  Q_OBJECT
 private:
  QWidget         *parent;
  PrinterSettings *settings;
  PrinterPreview  *preview;

  QPrinter   *printer;
  KStatusBar *statusBar;
  int         tab1;
  int         tab2;
  QFont       font;
  QSongList   songs;
  KConfig    *config;

  void restorePrinterSettings();
  void savePrinterSettings();

 public:
  Printer(QWidget *, const char* , KStatusBar *);
  void draw(QPainter *, int ); 
  void print(QSongList );
  void openPreview(QSongList );
  void openSettings(QSongList );
  QPrinter* getPrinter();
  void getPageDimension(int &, int &);
  
 private slots:
  void print();
  void openPreview();
  void openSettings();
  void parameterChanged(QFont , int , int );

 signals:
  void numberOfPages(int);
};

#endif
