/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <stdio.h>
#include <stdlib.h>
#include <qstring.h>
#include <unistd.h>
#include "mp3.h"

const char * const Tag::genres[] = {
        "Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge","Hip-Hop",
        "Jazz","Metal","New Age","Oldies","Other","Pop","R&B","Rap","Reggae","Rock",
        "Techno","Industrial","Alternative","Ska","Death Metal","Pranks","Soundtrack",
        "Euro-Techno","Ambient","Trip-Hop","Vocal","Jazz+Funk","Fusion","Trance",
        "Classical","Instrumental","Acid","House","Game","Sound Clip","Gospel","Noise",
        "Alt","Bass","Soul","Punk","Space","Meditative","Instrumental Pop",
        "Instrumental Rock","Ethnic","Gothic","Darkwave","Techno-Industrial",
        "Electronic","Pop-Folk","Eurodance","Dream","Southern Rock","Comedy","Cult",
        "Gangsta Rap","Top 40","Christian Rap","Pop/Funk","Jungle","Native American",
        "Cabaret","New Wave","Psychedelic","Rave","Showtunes","Trailer","Lo-Fi",
        "Tribal","Acid Punk","Acid Jazz","Polka","Retro","Musical","Rock & Roll",
        "Hard Rock","Folk","Folk/Rock","National Folk","Swing","Fast-Fusion","Bebob",
        "Latin","Revival","Celtic","Bluegrass","Avantgarde","Gothic Rock",
        "Progressive Rock","Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band",
        "Chorus","Easy Listening","Acoustic","Humour","Speech","Chanson","Opera",
        "Chamber Music","Sonata","Symphony","Booty Bass","Primus","Porn Groove",
        "Satire","Slow Jam","Club","Tango","Samba","Folklore","Ballad","Power Ballad",
        "Rhythmic Soul","Freestyle","Duet","Punk Rock","Drum Solo","A Cappella",
        "Euro-House","Dance Hall","Goa","Drum & Bass","Club-House","Hardcore","Terror",
        "Indie","BritPop","Negerpunk","Polsk Punk","Beat","Christian Gangsta Rap",
        "Heavy Metal","Black Metal","Crossover","Contemporary Christian",
        "Christian Rock","Merengue","Salsa","Thrash Metal","Anime","JPop","Synthpop",
	"Unkown" 
};

const char * const Tag::genresSorted[] = {
        "A Cappella","Acid","Acid Jazz","Acid Punk","Acoustic","Alt","Alternative","Ambient",
        "Anime","Avantgarde","Ballad","Bass","Beat","Bebob","Big Band","Black Metal",
        "Bluegrass","Blues","Booty Bass","BritPop","Cabaret","Celtic","Chamber Music",
	"Chanson", "Chorus","Christian Gangsta Rap","Christian Rap","Christian Rock",
	"Classic Rock","Classical","Club","Club-House",
        "Comedy","Contemporary Christian","Country","Crossover","Cult","Dance","Dance Hall",
	"Darkwave", "Death Metal","Disco","Dream","Drum & Bass","Drum Solo","Duet",
	"Easy Listening","Electronic",
        "Ethnic","Euro-House","Euro-Techno","Eurodance","Fast-Fusion","Folk","Folk/Rock",
	"Folklore", "Freestyle","Funk","Fusion","Game","Gangsta Rap","Goa","Gospel","Gothic",
	"Gothic Rock","Grunge","Hard Rock","Hardcore","Heavy Metal","Hip-Hop","House","Humour",
	"Indie","Industrial","Instrumental","Instrumental Pop","Instrumental Rock","JPop",
	"Jazz","Jazz+Funk", "Jungle","Latin","Lo-Fi","Meditative","Merengue","Metal",
	"Musical","National Folk", "Native American","Negerpunk","New Age","New Wave",
	"Noise","Oldies","Opera","Other", "Polka","Polsk Punk","Pop","Pop-Folk","Pop/Funk",
	"Porn Groove","Power Ballad","Pranks", "Primus","Progressive Rock","Psychedelic",
	"Psychedelic Rock","Punk","Punk Rock","R&B","Rap", "Rave","Reggae","Retro",
	"Revival","Rhythmic Soul","Rock","Rock & Roll","Salsa", "Samba","Satire","Showtunes",
	"Ska","Slow Jam","Slow Rock","Sonata","Soul", "Sound Clip","Soundtrack",
	"Southern Rock","Space","Speech","Swing","Symphonic Rock","Symphony",
        "Synthpop","Tango","Techno","Techno-Industrial","Terror","Thrash Metal","Top 40",
	"Trailer", "Trance","Tribal","Trip-Hop","Vocal","Unkown"
};
 

Tag::Tag() {
  title[0] = 0;
  artist[0] = 0;
  album[0] = 0;
  year[0] = 0;
  comment[0] = 0;
  genre[0] = 0;
  gennum = -1;
}

void Tag::clear(){
  *title   = '\0';
  *artist  = '\0';
  *album   = '\0';
  *year    = '\0';
  *comment = '\0';
  *genre   = '\0';
  gennum = -1;
}



void Tag::safecopy(char *to, char *from, int maxlen){
  int where;
  strncpy(to, from, maxlen);
  to[maxlen] = 0;
  for (where = maxlen - 1; ((where >= 0) && (to[where] == ' ')); where--) {
    to[where] = 0;
  }
}

void Tag::spacecopy(char *to, char *from, int maxlen){
    int where;
    strncpy(to, from, maxlen);
    for (where = maxlen - 1; ((where >= 0) && (to[where] == 0)); where--) {
        to[where] = ' ';
    }
}    

bool Tag::scan(FILE * file){
  //  int temp;
  tag song;
  if(fseek(file, -128, SEEK_END) <0 ){
	perror("fseek");
	return false;
  }
  if(fread(&song, 128, 1, file) <0){
    perror("fread");
    return false;
  }

  
  if (!strncmp(song.tag, "TAG", 3)) {
    safecopy(title, song.title, 30);
    safecopy(artist, song.artist, 30);
    safecopy(album, song.album, 30);
    safecopy(year, song.year, 4);
    safecopy(comment, song.comment, 30);
    gennum = song.genre & 0xFF;
    if ((gennum < 0) || (gennum >= _MAX_GENRE)) gennum = _MAX_GENRE;
    strcpy(genre, genres[gennum]);

    return (1);
  }
  else {
    return (0);
  }
}


bool Tag::saveTags(FILE * file){
  size_t temp;
  tag song;
  
  spacecopy(song.title, title, 30);
  spacecopy(song.artist, artist, 30);
  spacecopy(song.album, album, 30);
  spacecopy(song.year, year, 4);
  spacecopy(song.comment, comment, 30);
  
  if (gennum >= _MAX_GENRE) song.genre = 0;
  else {
    temp = gennum;
    song.genre = (unsigned char) temp;
  }

  fseek(file, -128, SEEK_END);
  temp = fread(&song, 3, 1, file);
  if (!strncmp(song.tag, "TAG", 3)) fseek(file, -128, SEEK_END);
  else fseek(file, 0, SEEK_END);
  
  strncpy(song.tag, "TAG", 3);
  temp = fwrite(&song, 128, 1, file);
  if (temp == 1) return (true);
  perror("SAVE");
  return (false);
}
             
void Tag::setGenreNumber(int genreNumber){
  if ((gennum < 0) || (gennum >= _MAX_GENRE)) gennum = _MAX_GENRE;
  strcpy(genre, genres[gennum]);  
}

void Tag::setGenreName(char *genreName){
  strcpy(genre,genres[80]);
  gennum = getGenreAsNumber(genreName);
  strcpy(genre,genres[gennum]);
}

int Tag::getMaxGenres(){
  return _MAX_GENRE;
}

int Tag::getGenreAsNumber(const char* genreName){
  int genreNumber = _MAX_GENRE;
  for(int i=0; i<=_MAX_GENRE; i++){
    if( strcmp(genreName,genres[i])==0){
      genreNumber = i;
      break;
    }
  }
  return genreNumber;
}

int Tag::getSortedGenreAsNumber(const char* genreName){
  int genreNumber = _MAX_GENRE;
  for(int i=0; i<=_MAX_GENRE; i++){
    if( strcmp(genreName,genresSorted[i])==0){
      genreNumber = i;
      break;
    }
  }
  return genreNumber;
}


const char* Tag::getGenreAsString(int genreNumber){
  if ((genreNumber < 0) || (genreNumber >= _MAX_GENRE)) 
    return (const char*)genres[_MAX_GENRE];
  return (const char*) genres[genreNumber];
}

const char* Tag::getSortedGenreAsString(int genreNumber){
  if ((genreNumber < 0) || (genreNumber >= _MAX_GENRE)) 
    return (const char*)genresSorted[_MAX_GENRE];
  return (const char*) genresSorted[genreNumber];
}


