/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <kurl.h>
#include <qdir.h>
#include <kconfig.h>
#include <kapp.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <iostream.h>
#include <qstring.h>
#include <fstream.h>
#include "ioaccess.h"
#include "mp3.h"
#include "kjukebox.h"
#include "../config.h"

IOAccess::IOAccess(){
  progressBar = new KProgress(NULL,"progressbar");
  progressBar -> setOrientation(KProgress::Horizontal);
  progressBar -> setCaption(i18n("Please Wait"));
  progressBar -> setFixedSize(250,20);
}

Song IOAccess::loadMP3File(QString filename){
  Song tmp;
  if(  mp3.open(filename) ) {
    if(mp3.initfile()){
      mp3.close();
      return mp3.getSong();
    }
    return tmp;
  }
  //  cout << "Fehler" << endl;
  return tmp;
}
   

QSongList IOAccess::load(QString filename){
  QSongList songs;
  Song *song;
  QFile file;
  KConfig *config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_FILE);
  char tmp[2000];
  QString input;
  ifstream infile(filename, ios::in);
  if (!infile) return songs;

  KApplication::setOverrideCursor( waitCursor );
  while(infile){
    infile.getline(tmp,2000);
    input = tmp;
    if(!input.isEmpty()){
      song = new Song();
      song->initFromString(input);
      if(config->readBoolEntry(KCONFIG_FILE_CHECKFILES, true)){
	file.setName(song->getFilename());	
	if(file.exists()) songs.append(song);
	else {
	  debugOutput( cout <<"File "<<song->getFilename()<<" not found!!! I Skip it."<<endl );
	  delete(song);
	}
      }
      else 
	songs.append(song);
    }
    *tmp = '\0';
  }
  KApplication::restoreOverrideCursor();
  return songs;
}
  

bool IOAccess::save(QString filename, QSongList songs){
  Song *lauf;
  
  ofstream outfile(filename,ios::out|ios::trunc);
  if (!outfile) { return FALSE;  }

  KApplication::setOverrideCursor( waitCursor );
  for(lauf=songs.first(); lauf!=NULL; lauf=songs.next()){
    outfile << lauf->asString() << endl;
  }
  KApplication::restoreOverrideCursor();

  outfile.close();
  return TRUE;
}

bool IOAccess::exportMP3List(QString filename, QSongList songs){
  Song *lauf;
  KConfig *config;
  QString format, trennzeichen;
  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_FILE);
  format = config->readEntry(KCONFIG_FILE_IMPORTFORMAT,
			     "AP|TI|AR|AL|YE|CO|GE|||||BI|SA|ST|||||SE|RP|SI|FS|LS");
  trennzeichen = config->readEntry( KCONFIG_FILE_IMPORTSEPERATOR, "|");

  ofstream outfile(filename,ios::out|ios::trunc);
  if (!outfile) { return FALSE;  }

  KApplication::setOverrideCursor( waitCursor );
  for(lauf=songs.first(); lauf!=NULL; lauf=songs.next()){
    outfile << lauf->asString(format, trennzeichen) << endl;
  }
  KApplication::restoreOverrideCursor();
  outfile.close();
  return TRUE;
}

bool IOAccess::exportM3uList(QString filename, QSongList songs){
  Song *lauf;
  QFileInfo fileInfo;
  QString path;
  QString filePath;
  QString savePath;

  ofstream outfile(filename,ios::out|ios::trunc);
  if (!outfile) { return FALSE;  }

  fileInfo.setCaching(false);
  fileInfo.setFile(filename.data());  
  savePath = fileInfo.dirPath(true);

  KApplication::setOverrideCursor( waitCursor );
  for(lauf=songs.first(); lauf!=NULL; lauf=songs.next()){
    fileInfo.setFile(lauf->getFilename().data());
    filePath = fileInfo.absFilePath();
    if(filePath.find(savePath.data(),0) < 0){
      path = filePath; //absolut Path
    }
    else { //relativ Path
      path = ".";
      path += filePath.right(filePath.length() - savePath.length());
    }
    outfile << path.data() << endl;
  }
  KApplication::restoreOverrideCursor();

  outfile.close();
  return TRUE;
}


QSongList IOAccess::importMP3FileList(QString filename){
  QSongList songs;
  Song *song;
  char tmp[2000];
  QString input;
  QFile file;

  KConfig *config;
  QString format, trennzeichen;
  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_FILE);
  format = config->readEntry(KCONFIG_FILE_IMPORTFORMAT,
			     "AP|TI|AR|AL|YE|CO|GE|||||BI|SA|ST|||||SE|RP|SI|FS|LS");
  format = format.upper();
  trennzeichen = config->readEntry(KCONFIG_FILE_IMPORTSEPERATOR, "|");

  ifstream infile(filename, ios::in);
  if (!infile){
    return songs;
  }

  KApplication::setOverrideCursor( waitCursor );
  while(infile){
    infile.getline(tmp,2000);
    input = tmp;
    if(!input.isNull()){
      song = new Song();
      song->initFromString(input,format,trennzeichen);
      if(config->readBoolEntry(KCONFIG_FILE_CHECKFILES, true)){
	file.setName(song->getFilename());	
	if(file.exists()) songs.append(song);
	else {
	  debugOutput( cout <<"File "<<song->getFilename()<<" not found!!! I Skip it."<<endl );
	  delete(song);
	}
      }
      else 
	songs.append(song);
    }
  }
  KApplication::restoreOverrideCursor();

  infile.close();
  return songs;
}


QSongList IOAccess::importM3uFileList(QString filename){
  QSongList songs;
  Song *song;

  char tmp[2000];
  QString file;
  QString pfad;
  QString mp3file;
  ifstream infile(filename, ios::in);
  *tmp ='\0';
  
  if (!infile) return songs;

  KURL url(filename);
  pfad = url.directory();
  
  KApplication::setOverrideCursor( waitCursor );
  while(infile){
    infile.getline(tmp,2000);
    file = tmp;
    file = file.stripWhiteSpace();
    if(!file.isEmpty()){
      if (strncmp(file, "/",1)) mp3file = pfad; /* von Malte */
      else mp3file = "";
      // mp3file = strncmp(file, "/", 1) ? pfad : QString("");  /* Orig von Malte */
      mp3file += file;
      KURL::decodeURL(mp3file);
      if(  mp3.open(mp3file) ) {
	debugOutput( cout << "loading" << endl );
	mp3.initfile() ;
	mp3.close();
	song = new Song();
	*song = mp3.getSong();
	songs.append( song );   
      }
      else 
	debugOutput( cout << "File " << mp3file << " not found!!! I Skip it." << endl );
    }  
  }
  KApplication::restoreOverrideCursor();
  infile.close();
  return songs;
}

Song IOAccess::importMP3File(QString filename){
  return loadMP3File(filename);
}

QSongList IOAccess::importDirectory(QString path){
  QSongList       songs;
  QSongList       tmpSongs;
  Song           *tmpIterator;
  QDir            dir;
  
  dir.setPath(path);

  const QFileInfoList * files = dir.entryInfoList();
  if ( files ) {
    QFileInfoListIterator it( *files );
    QFileInfo * f;
    while( (f=it.current()) != 0 ) {
      ++it;
      if ( f->fileName() == "." || f->fileName() == ".." )
	; // nothing
      else if ( f->isDir() ){
	tmpSongs = importDirectory(f->absFilePath());	
	for (tmpIterator=tmpSongs.first(); tmpIterator!=NULL; tmpIterator=tmpSongs.next())
	  songs.append(tmpIterator);
      }
      else 
	if ((f->fileName()).findRev ( ".mp3", -1, false )!= -1){
	  Song *song = new Song();
	  *song = importMP3File( f->absFilePath() );
	  songs.append(song);
	}           
    }
  }  
  return songs;
}

