/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include <kslider.h>
#include <stdlib.h>
#include "configGeneral.h"
#include <sys/resource.h>
#include <kfiledialog.h>

ConfigGeneral::ConfigGeneral( QWidget *parent, const char *name )
  : QWidget( parent, name ){

  QString pp;
  int     defaultPrio;
  bool    setPrio;
  QString artist;
  QString album;
  bool    upcase;
  bool    loadWithoutTag;
  bool    enableLog;
  QString logFile;
  bool    repeat;

  minPrio =-19; /* Default */
  maxPrio = 20;

#ifdef OS_Linux
  minPrio = PRIO_MIN;
  maxPrio = PRIO_MAX;
#endif

#ifdef OS_SunOS
  minPrio = -19; /* I hope this values are OK */
  maxPrio = 20;
#endif  

  config = (KApplication::getKApplication())->getConfig();  
  config->setGroup(KCONFIG_GENERAL);

  setPrio     = config->readBoolEntry(KCONFIG_GENERAL_PRIOENABLE,false);
  defaultPrio = config->readNumEntry(KCONFIG_GENERAL_PRIOLEVEL,0);

  boxPrio      = new QGroupBox(i18n("Priority of KJukeBox"), this, "boxPrio" );  
  setPrioBox   = new QCheckBox(i18n("enable a special priority"), boxPrio, "prioenable");
  prioLevelBox = new QComboBox(FALSE, boxPrio, "priority");

  setPrioBox->setChecked(setPrio);  
  int tmp=0;
  for(int i=minPrio; i<=maxPrio; i++){
    pp.sprintf("%2d",i);
    prioLevelBox->insertItem(pp.data(),i - minPrio);
    if(i==defaultPrio) tmp = i - minPrio;
  }
  prioLevelBox->setCurrentItem(tmp);
  prioLevelLabel = new QLabel(i18n("Set the Process Priority for the\nPlayer."),boxPrio, "bla");


  upcase  = config->readBoolEntry(KCONFIG_GENERAL_UPCASE,false);

  config->setGroup(KCONFIG_MP3);
  loadWithoutTag = config->readBoolEntry(KCONFIG_MP3_LOAD_WITHOUT_TAG,true);
  artist  = config->readEntry(KCONFIG_MP3_DEFAULT_ARTIST,i18n("Unknown"));
  album   = config->readEntry(KCONFIG_MP3_DEFAULT_ALBUM,i18n("Unknown"));

  boxMP3 = new QGroupBox(i18n("MP3 Settings"), this, "boxMP3" );

  loadWithoutTagBox = new QCheckBox(i18n("load songs without MP3 tag"), boxMP3, "load");
  loadWithoutTagBox->setChecked(loadWithoutTag);

  defaultArtist = new QLineEdit(boxMP3,"artist le");
  defaultArtistLabel = new QLabel(defaultArtist, i18n("default Artist"), boxMP3);
  defaultArtist->setText(artist);
  defaultAlbum  = new QLineEdit(boxMP3,"album  le");
  defaultAlbumLabel = new QLabel(defaultAlbum, i18n("default Album"), boxMP3);
  defaultAlbum->setText(album);

  upcaseFirstLettersBox = new QCheckBox(i18n("up case first letter of each word"), boxMP3, "upcase");
  upcaseFirstLettersBox->setChecked(upcase);



  config->setGroup(KCONFIG_SONGLOGGER);
  enableLog = config->readBoolEntry(KCONFIG_SONGLOGGER_ENABLE,true);
  logFile   = config->readEntry(KCONFIG_SONGLOGGER_LOGFILE,"kjukebox.log");

  boxLog = new QGroupBox(i18n("Song logging"), this, "boxLog" );

  enableLogBox = new QCheckBox(i18n("enable logging"), boxLog, "enable Log");
  enableLogBox->setChecked(enableLog);

  logFileEdit  = new QLineEdit(boxLog,"log file edit");
  logFileLabel = new QLabel(logFileEdit, i18n("Log file"), boxLog);
  logFileEdit->setText(logFile);
  logFileBrowse  = new QPushButton(i18n("Browse"),boxLog,"Browse Button");
  connect(logFileBrowse,SIGNAL(clicked()), this, SLOT(openBrowser()));
  


  config->setGroup(KCONFIG_GENERAL);
  repeat = config->readBoolEntry(KCONFIG_GENERAL_REPEAT,true);

  boxRepeat = new QGroupBox(i18n("Repeat"), this, "boxRepeat" );

  enableRepeat = new QCheckBox(i18n("if all songs played unmark all and repeat"), boxRepeat, "enableRepeat");
  enableRepeat->setChecked(repeat);

}

ConfigGeneral::~ConfigGeneral(){
}

void ConfigGeneral::openBrowser(){
  QString file =  KFileDialog::getSaveFileName(0,"*.log",0, "Log File Dialog");
  if ( !file.isEmpty() ) {
    unsigned int index = file.findRev(".log",-1,false);
    if (index != (file.length()-4)) 
      file.append(".log");   
    logFileEdit->setText(file);
  }
}


void ConfigGeneral::cancel(){
  config->setGroup(KCONFIG_GENERAL);  
  setPrioBox->setChecked(config->readBoolEntry(KCONFIG_GENERAL_PRIOENABLE,false));  
  upcaseFirstLettersBox->setChecked(config->readBoolEntry(KCONFIG_GENERAL_UPCASE,false));

  int defaultPrio = config->readNumEntry(KCONFIG_GENERAL_PRIOLEVEL,0);
  int tmp = 0;
  for(int i=minPrio; i<=maxPrio; i++){
    if(i==defaultPrio) tmp  = i - minPrio;
  }
  prioLevelBox->setCurrentItem(tmp);

  config->setGroup(KCONFIG_MP3);
  bool loadWithoutTag = config->readBoolEntry(KCONFIG_MP3_LOAD_WITHOUT_TAG,true);
  QString artist  = config->readEntry(KCONFIG_MP3_DEFAULT_ARTIST,i18n("Unknown"));
  QString album   = config->readEntry(KCONFIG_MP3_DEFAULT_ALBUM,i18n("Unknown"));

  loadWithoutTagBox->setChecked(loadWithoutTag);
  defaultArtist->setText(artist);
  defaultAlbum->setText(album);

  config->setGroup(KCONFIG_SONGLOGGER);
  bool enableLog = config->readBoolEntry(KCONFIG_SONGLOGGER_ENABLE,true);
  QString logFile   = config->readEntry(KCONFIG_SONGLOGGER_LOGFILE,"kjukebox.log");
  enableLogBox->setChecked(enableLog);
  logFileEdit->setText(logFile);

  config->setGroup(KCONFIG_GENERAL);
  bool repeat = config->readBoolEntry(KCONFIG_GENERAL_REPEAT,true);
  enableRepeat->setChecked(repeat);
}

void ConfigGeneral::accept(){
  config->setGroup(KCONFIG_GENERAL);  
  config->writeEntry(KCONFIG_GENERAL_PRIOENABLE, setPrioBox ->isChecked());
  config->writeEntry(KCONFIG_GENERAL_PRIOLEVEL, atoi(prioLevelBox->currentText()));
  config->writeEntry(KCONFIG_GENERAL_UPCASE,upcaseFirstLettersBox->isChecked());

  config->setGroup(KCONFIG_MP3);
  config->writeEntry(KCONFIG_MP3_LOAD_WITHOUT_TAG,loadWithoutTagBox->isChecked());
  config->writeEntry(KCONFIG_MP3_DEFAULT_ARTIST,defaultArtist->text());
  config->writeEntry(KCONFIG_MP3_DEFAULT_ALBUM,defaultAlbum->text());

  config->setGroup(KCONFIG_SONGLOGGER);
  config->writeEntry(KCONFIG_SONGLOGGER_ENABLE,enableLogBox->isChecked());
  config->writeEntry(KCONFIG_SONGLOGGER_LOGFILE,logFileEdit->text());

  config->setGroup(KCONFIG_GENERAL);
  config->writeEntry(KCONFIG_GENERAL_REPEAT, enableRepeat->isChecked());

  config->sync();
}

void ConfigGeneral::resizeEvent( QResizeEvent * ){
  boxPrio  -> setGeometry(10,10,width()-20,85);
  setPrioBox     -> setGeometry( 10, 20, boxPrio->width()-20, 25);
  prioLevelLabel -> setGeometry( 10, 50,200,30);
  prioLevelBox   -> setGeometry(210, 50,boxPrio->width()-220,25);

  boxMP3  -> setGeometry(10,110,width()-20,145);
  loadWithoutTagBox     -> setGeometry( 10, 20, boxMP3->width()-20, 25);
  defaultArtistLabel    -> setGeometry( 10, 50, 150, 25);
  defaultArtist         -> setGeometry(180, 50, boxMP3->width()-190, 25);
  defaultAlbumLabel     -> setGeometry( 10, 80, 150, 25);
  defaultAlbum          -> setGeometry(180, 80, boxMP3->width()-190, 25);
  upcaseFirstLettersBox -> setGeometry( 10,110, boxMP3->width()-20, 25);

  boxLog  -> setGeometry(10,270,width()-20, 85);
  enableLogBox  -> setGeometry( 10, 20, 200, 25);
  logFileBrowse -> setGeometry(boxLog->width()-110, 20,100, 25);
  logFileLabel  -> setGeometry( 10, 50,170,30);
  logFileEdit   -> setGeometry(180, 50,boxLog->width()-190,25);


  boxRepeat -> setGeometry( 10, 370, width()-20, 55);  
  enableRepeat  -> setGeometry( 10, 20, boxRepeat->width()-20, 25);

}

