#include "execrequest.h"

ExecRequest::ExecRequest(Arts::ArtsServer *Server, long StructureID, const char *structureName)
{
	this->_Server = Arts::ArtsServer::_duplicate(Server);
	mid = _Server->createModules();
	_ServerID = Server->ID();
	_StructureID = StructureID;
	_structureName = structureName;
}

const char *ExecRequest::structureName()
{
	return _structureName.c_str();
}

Arts::ArtsServer *ExecRequest::Server()
{
	return _Server;
}

long ExecRequest::ServerID()
{
	return _ServerID;
}

long ExecRequest::StructureID()
{
	return _StructureID;
}

long ExecRequest::MID()
{
	return mid;
}

const Arts::ModuleDescSeq& ExecRequest::Modules()
{
	return _Modules;
}

// FIXME: eventually implement releaseModules which releases the modules
// sequence as soon as it is no longer needed in the creation process

bool ExecRequest::createModule(Arts::ModuleDesc *desc)
{
	unsigned long l = _Modules.length();
	_Modules.length(l+1);
	_Modules[l] = Arts::ModuleDesc::_duplicate(desc);

	return(_Server->createModule(mid, desc));
}

bool ExecRequest::localConnectModules()
{
	return(_Server->localConnectModules(mid));
}

bool ExecRequest::remoteConnectModules(ExecRequest *remote)
{
	return(_Server->remoteConnectModules(mid,remote->mid,remote->Modules(),remote->_Server));
}

bool ExecRequest::finalizeModules()
{
	return(_Server->finalizeModules(mid));
}

void ExecRequest::startModules()
{
	_Server->startModules(mid);
}

void ExecRequest::deleteModules()
{
	_Server->deleteModules(mid);
}
