
#define compose_16le(ptr) \
	((((*((ptr)+1)+128)&0xff) << 8)+*(ptr))

#define conv_16le_float(x) \
	((float)((x)-32768)/32768.0)

void convert_mono_16le_float(unsigned long samples, unsigned char *from, float *to)
{
	float *end = to+samples;

	while(to<end)
	{
		*to++ = conv_16le_float(compose_16le(from));
		from += 2;
	}
}

void convert_stereo_i16le_2float(unsigned long samples, unsigned char *from, float *left, float *right)
{
	float *end = left+samples;
	while(left < end)
	{
		*left++ = conv_16le_float(compose_16le(from));
		*right++ = conv_16le_float(compose_16le(from+2));
		from += 4;
	}
}

void convert_stereo_2float_i16le(unsigned long samples, float *left, float *right, unsigned char *to)
{
	float *end = left+samples;
	long syn;

	while(left < end)
	{
		syn = (long)((*left++)*32767)+65536;
		*to++ = syn & 0xff;
		*to++ = (syn >> 8) & 0xff;

		syn = (long)((*right++)*32767)+65536;
		*to++ = syn & 0xff;
		*to++ = (syn >> 8) & 0xff;
	}	
}

void convert_mono_float_16le(unsigned long samples, float *from, unsigned char *to)
{
	float *end = from+samples;

	while(from < end)
	{
		long syn = (long)((*from++)*32767)+65536;
		*to++ = syn & 0xff;
		*to++ = (syn >> 8) & 0xff;
	}	
}
