    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guimodule.h"
#include "qwidget.h"
#include "qlabel.h"
#include "qlayout.h"
#include "qpixmap.h"
#include "qbitmap.h"
#include "qobject.h"

class Gui_SLIDER : public GuiModule
{
	QLabel  *Widget,*SLWidget;
	QWidget *ParentWidget;

	QPixmap bgpixmap;
	QPixmap slpixmap;
	float maxvalue, minvalue;
	float currentvalue;

	long valuePort;

	int x,y,ypos,ysize;
public:
	Gui_SLIDER();
	~Gui_SLIDER();
	void publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker);

	static void *Creator();

	void applyParameters(Arts::ModuleDesc *desc);
	void finalize();
	void start();
	void setParent(QWidget *Parent,QBoxLayout *layout);

	Arts::StringSeq *saveSessionParameters(list<long>&);
	void restoreSessionParameters(const Arts::StringSeq& params);

	void sendPosChange(float x, float y);
	void widgetDestroyed(QWidget *widget);
};

class MovingLabel :public QLabel
{
public:
	MovingLabel(int minx, int miny, int maxx, int maxy, Gui_SLIDER *slider);

protected:
	void mouseMoveEvent(QMouseEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);

	Gui_SLIDER *slider;
	QPoint movestart;
	bool isMoving;
	int sx,sy, minx,miny,maxx,maxy;
};
