    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _GUI_MIXER_H
#define _GUI_MIXER_H

#include "guimodule.h"
#include "qwidget.h"
#include "qlayout.h"
#include "qframe.h"
#include  "guiserver_impl.h"
#include <list>

class Gui_MIXER :public GuiModule
{
	QWidget *Widget, *ParentWidget;
	QBoxLayout *Layout;
	string name, output, structure;
	long idPort,channels;
	long channels_created;
	list<long> freeList;

public:
	Gui_MIXER();
	~Gui_MIXER();

	void publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker);

	static void *Creator();

	void applyParameters(Arts::ModuleDesc *desc);
	void finalize();
	void start();
	void tick();
	void setParent(QWidget *Parent,QBoxLayout *layout);
	QWidget *isParent();
	QBoxLayout *parentLayout();
	void widgetDestroyed(QWidget *widget);

	void mkChannel(class StructureBuilder& sb, long nr);

	Arts::StringSeq *saveSessionParameters(list<long>& IDs);
	void restoreSessionParameters(const Arts::StringSeq& params);
};

#endif
