    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guimixer.h"
#include "qframe.h"
#include "kiconloader.h"
#include "structbuilder.h"
#include "sequenceutils.h"

Gui_MIXER::Gui_MIXER()
{
	Widget = 0;
	Layout = 0;
	ParentWidget = 0;
}

Gui_MIXER::~Gui_MIXER()
{
	if(Widget) delete Widget;
	while(freeList.size())
	{
		long id = *freeList.begin();
		freeList.pop_front();
		Synthesizer->freeStructure(id);
	}
}

void Gui_MIXER::widgetDestroyed(QWidget *widget)
{
	assert(Widget == widget);
	Widget = 0;
}

void Gui_MIXER::publish(Arts::ArtsServer *Server, Arts::ModuleBroker *Broker)
{
	Arts::ModuleInfo info;

	info.name = CORBA::string_dup("Gui_MIXER");
	info.isInterface = false;
	info.isStructure = false;

	addPort(info,"parent",Arts::input,Arts::audio_data,Arts::stream);
	addPort(info,"channels",Arts::input,Arts::audio_data,Arts::stream);
	addPort(info,"structure",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"name",Arts::input,Arts::string_data,Arts::property);
	addPort(info,"output",Arts::input,Arts::string_data,Arts::property);

	Broker->publishModule(Server, info);
}

void *Gui_MIXER::Creator()
{
	return new Gui_MIXER;
}

ModuleClient MC_Gui_MIXER(GuiModule::get_MS,"Gui_MIXER",Gui_MIXER::Creator);

void Gui_MIXER::applyParameters(Arts::ModuleDesc *desc)
{
	printf("crw\n");
	if(!Widget)
	{
		QFrame *Frame = new QFrame();
		Frame->setFrameStyle( QFrame::Panel | QFrame::Raised );
		Frame->setLineWidth( 2 );
		Widget = Frame;
		Widget->resize(0,0);
		watchWidget(Widget);
	}
	Layout = new QHBoxLayout(Widget);
	setupParent(desc,"parent");
	channels = (long)(getFloatParam(desc,"channels")+0.5);
	channels_created = 0;
	name = getStringParam(desc,"name");
	output = getStringParam(desc,"output");
	structure = getStringParam(desc,"structure");
}

QWidget *Gui_MIXER::isParent()
{
	return(Widget);
}

QBoxLayout *Gui_MIXER::parentLayout()
{
    printf("GW: layout requested\n");
	return Layout;
}                                                                               

void Gui_MIXER::setParent(QWidget *parent, QBoxLayout *layout)
{
/*
	Don't care about parentsetting at all. We are a window, and that's
	it!
*/
	if(Widget)
	{
		printf("recreating widget...\n");
		Widget->recreate(parent,0,QPoint(0,0));
		if(layout)
		{
			printf("adding widget to layout\n");
			layout->addWidget(Widget);
		}
		printf("ok.\n");
	}
}

void Gui_MIXER::finalize()
{
	//
}

void Gui_MIXER::start()
{
	Layout->activate();
	Widget->show();
}

void Gui_MIXER::tick()
{
	if(channels_created >= channels) return;

	// if somebody is so crazy and wants to implement "changing channels
	// with a slider" - do it ;)
	channels_created = channels;

	Arts::ArtsServerSeq preferredservers;

	preferredservers.length(1);
	preferredservers[0] = Arts::ArtsServer::_duplicate(GUIServer);

	long i;
	for(i=0;i<channels;i++)
	{
		StructureBuilder sb(Synthesizer);
 		mkChannel(sb,i);

		long id = sb.execute(preferredservers);
 
		if(sb.okay()) freeList.push_back(id);
	}
}

void Gui_MIXER::mkChannel(StructureBuilder& sb, long nr)
{
	char channelname[strlen(name.c_str())+50];

	sprintf(channelname,"%s%02ld",name.c_str(),nr+1);
	sb.createModule(structure.c_str(),"mixer");
 
	sb.setStringValue("mixer.input",channelname);
	sb.setStringValue("mixer.output",output.c_str());
	sb.setFloatValue("mixer.parent",(float)_GlobalID);

	if(!sb.okay())
	{
    	fprintf(stderr,"error in SBuilder: %s\n",sb.error());
	}
}

Arts::StringSeq *Gui_MIXER::saveSessionParameters(list<long>& IDs)
{
	Arts::StringSeq *result = new Arts::StringSeq;
	list<long>::iterator i;

	for(i=freeList.begin(); i != freeList.end(); i++)
	{
		sqprintf(result,"channel_id=%ld",(*i));
		IDs.push_back(*i);
	}
	return result;
}

void Gui_MIXER::restoreSessionParameters(const Arts::StringSeq& params)
{
	Arts::ArtsServerSeq preferredservers;

	preferredservers.length(1);
	preferredservers[0] = Arts::ArtsServer::_duplicate(GUIServer);

   	char *cmd,*param;
	unsigned long i;
   	for(i=0;i<params.length();i++)
   	{
   		if(parse_line(params[i],cmd,param))   // otherwise: empty or comment
   		{
   			if(strcmp(cmd,"channel_id") == 0) {
				long oldID = atol(param);

				StructureBuilder sb(Synthesizer);
				mkChannel(sb,channels_created++);

				if(sb.okay()) // FIXME: write sb.restore()
				{
					Arts::StructureDesc_var sd = sb.structureDesc();

					long id = Synthesizer->restoreStructure(sd,preferredservers,
															restoreID,oldID);
 
					if(id) freeList.push_back(id);
				}
			}
		}
   	}
}
