#ifndef _QTDRUM_H_
#define _QTDRUM_H_

#include "qtEditor.h"
#include "kbPosition.h"

class KbPart;

/**
 * This qt class presents the contents of a part in a drum presentation
 * @short Qt Drum Class
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtDrum : public QtEditor
{
  Q_OBJECT

 private:

  int ybottom;
  QString help;
  int beats;
  int xLeft;
  int xRight;
  KbNote * note;
  int xx;
  int yy;
  int showY;
  int showY_old;
  QPixmap img[8];
  int x;
  int y;
  int yGrab;

 public:

  QtDrum(KbPart * kbpart);
  virtual int Pitch(int);
  virtual void addOptions();

 public slots:

  void paintEvent( QPaintEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void resizeEvent( QResizeEvent * );
  virtual void optionsMenu(int);
};

#endif
