#ifndef _KBSCORETRACK_H_
#define _KBSCORETRACK_H_

#include "kbTrack.h"

class KbScoreTrack : public KbTrack
{
 private:
  bool toggle[3];
  int program;
  int channel;
  int output;
  int volume;
  int transpose;
  int delay;

 public:
  KbScoreTrack();
  KbScoreTrack( KbMain * kbMain );
  /**
   * @return the current midi program.
   * @see #sProgram
   */
  int gProgram();

  /**
   * @return the current midi channel.
   * @see #sChannel
   */
  int gChannel();

  /**
   * @return the current output device.
   * @see #sOutput
   */
  int gOutput();

  /**
   * @return the current relative volume.
   * @see #sVolume
   */
  int gVolume();

  /**
   * @return the current delay.
   * @see #sDelay
   */
  int gDelay();

  /**
   * @return the current transpose.
   * @see #sTranspose
   */
  int gTranspose();

  /**
   * Each track has (currently three) toggle buttons: mute, type and lock
   * For mute and lock the states TRUE and FALSE mean on and off respectively. For type
   * TRUE means MIDI-Track and FALSE means Audio-Track (which is not implemented yet).
   * @version 24.12.98
   * @param n describes the toggle button: 0=mute, 1=type, 2=lock.
   * @return the state of the tracks n'th toggle button.
   * @see #sToggle
   */
  bool gToggle(int n);

  /**
   * @param n the midi program, the track will be set to.
   * @see #gProgram
   */
  void sProgram(int n);

  /**
   * @param n the midi channel, the track will be set to.
   * @see #gChannel
   */
  void sChannel(int n);

  /**
   * @param n the output device, the track's midi events will be sent to.
   * @see #gOutput
   */
  void sOutput(int n);

  /**
   * @param n the relative volume, the track will be set to.
   * @see #gVolume
   */
  void sVolume(int n);

  /**
   * @param n the delay, the track will be set to.
   * @see #gDelay
   */
  void sDelay(int n);

  /**
   * @param n the transpose value, the track will be set to.
   * @see #gTranspose
   */
  void sTranspose(int n);

  /**
   * @param i the track's toggle button (0=mute, 1=type, 2=lock).
   * @param n the track's i'th toggle button's state.
   * @see #gToggle
   */
  void sToggle(int i,bool n);
};

#endif
