#ifndef _KBMASTEREVENT_H_
#define _KBMASTEREVENT_H_

#include "kbAtom.h"

/**
 * Objects of this class are masterevents. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to. This is done in editors.
 * @short Masterevent Class
 * @author Jan Wuerthner
 * @version 0.97
 */
class KbMasterEvent : public KbAtom
{
 private:
  KbPosition pos;
  int tempo;
  int meter0;
  int meter1;

 public:
  KbMasterEvent( );
  KbMasterEvent(KbPosition p, int t);
  KbMasterEvent(KbPosition p, int a, int b);
  KbMasterEvent(KbPosition p, int a, int b, int t);
  KbPosition gPos();
  int gTempo();
  int gMeter0();
  int gMeter1();
  void sMeter1(int);
  void sMeter0(int);
  void sTempo(int t);
  void sPos(KbPosition p);
  virtual bool isNote();
  virtual bool isAuxElement();
  virtual bool isMidiEvent();
  virtual bool isMasterEvent();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};


#endif
