#ifndef _KBAUXELEMENT_H_
#define _KBAUXELEMENT_H_

#include "kbAtom.h"

/**
 * Objects of this class are auxelements. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to. This is done in editors.
 * @short Auxelement Class
 * @author Jan Wuerthner
 * @version 0.97
 */
class KbAuxElement : public KbAtom
{
 protected:
  KbPosition pos;
 public:
  KbAuxElement(KbPosition p);
  virtual KbPosition gPos();
  virtual void sPos(KbPosition);
  virtual bool isNote();
  virtual bool isAuxElement();
  virtual bool isMidiEvent();
  virtual bool isMasterEvent();
  //
  virtual bool isAuxText();
  virtual bool isAuxSymbol();
  virtual bool isAuxParSymbol();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};


class KbText : public KbAuxElement
{
 private:
  char * txt;
  int yoff;

 public:
  KbText(KbPosition p,char * t=0, int o=0);
  char * gText();
  void sText(char*);
  int gOffset();
  void sOffset(int);
  virtual bool isAuxText();
  virtual bool isAuxSymbol();
  virtual bool isAuxParSymbol();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};

class KbSymbol : public KbAuxElement
{
 private:
  int symbol;
  int yoff;

 public:
  KbSymbol(KbPosition p,int s=0,int o=0);
  int gSymbol();
  void sSymbol(int);
  int gOffset();
  void sOffset(int);
  virtual bool isAuxText();
  virtual bool isAuxSymbol();
  virtual bool isAuxParSymbol();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};

class KbParSymbol : public KbAuxElement
{
private:
  int symbol;
  int yoff;
  int parameter;

 public:
  KbParSymbol(KbPosition p,int s=0,int o=0,int par=0);
  int gSymbol();
  void sSymbol(int);
  int gOffset();
  void sOffset(int);
  int gParameter();
  void sParameter(int);
  virtual bool isAuxText();
  virtual bool isAuxSymbol();
  virtual bool isAuxParSymbol();
  virtual ostream & print(ostream&);
  virtual KbAtom * copy();
};

#endif
