#ifndef _QTWEDIT_C_
#define _QTWEDIT_C_

#include "qtWEdit.h"

#include "kbPart.h"
#include "kbMain.h"
#include <string.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include "math.h"
#include "kbAtom.h"
#include "kbWaveEvent.h"

QtWaveEdit::QtWaveEdit(KbPart * p) : part(p), name(0) {
  setFixedWidth(184);
  setFixedHeight(84);

  QLabel * lab = new QLabel("Filename: ",this);
  lab->setGeometry(4,18,64,20);
  lab->show();

  le = new QLineEdit(this);
  le->setGeometry(68,18,68,20);
  connect(le,SIGNAL(returnPressed()),SLOT(setName()));
  le->show();

  QPushButton * browseBtn = new QPushButton("Browse",this);
  browseBtn->setGeometry(2,48,64,24);
  browseBtn->show();
  connect(browseBtn,SIGNAL(released()),SLOT(browse()));

  QPushButton * exit = new QPushButton(" OK ",this);
  exit->setGeometry(120,48,64,24);
  exit->show();
  connect(exit,SIGNAL(released()),SLOT(exit()));

  // ---

  KbAtom * atom = part->gFirstAtom();
  if (atom) {
    // DOIT: if (atom->isWaveEvent()) ...
    KbWaveEvent * wav = (KbWaveEvent*) atom;
    name = (char*) strdup(wav->gFileName());
  }

}

void QtWaveEdit::exit() {
  KbAtom * atom = part->gFirstAtom();
  if (atom) {
    // DOIT: if (atom->isWaveEvent()) ...
    KbWaveEvent * wav = (KbWaveEvent*) atom;
    wav->sFileName(name); // makes a copy of name!
  } else {
    setName();
    if (name && (strlen(name)>0)) part->addAtom(new KbWaveEvent(0,(char*)strdup(name)));
  }
  if (name) { delete[] name; }
  delete this;
}

void QtWaveEdit::setName() {
  name = (char*) strdup(le->text());
}

void QtWaveEdit::browse() {
  QString fname = QFileDialog::getOpenFileName(0,"*.wav",this);
  le->setText(fname);
  setName();
}

#endif
