#ifndef _QTTRACK_C_
#define _QTTRACK_C_

#include "kbTrack.h"
#include "qtTrack.h"
#include <iostream.h>
#include <qmessagebox.h>


MyChooser::MyChooser( QWidget * parent = 0, const char * name = 0 )
  : QLabel(parent,name), qttrack((QtTrack*)parent)
{
  KIconLoader * loader = kapp->getIconLoader();

  pmDrum = new QPixmap(loader->loadIcon( "drum.xpm" ));
  pmTime = new QPixmap(loader->loadIcon( "time.xpm" ));
  pmScor = new QPixmap(loader->loadIcon( "note.xpm" ));
  pmWave = new QPixmap(loader->loadIcon( "wav.xpm" ));
  pmComm = new QPixmap(loader->loadIcon( "comment.xpm" ));
  
  menu = new QPopupMenu;
  menu->setMouseTracking( TRUE );
  menu->connectItem( menu->insertItem(*pmScor,"Score Track",ID_SCORE), this, SLOT(chooseScore()) );
  menu->connectItem( menu->insertItem(*pmDrum,"Drum Track",ID_DRUM), this, SLOT(chooseDrum()) );
  menu->connectItem( menu->insertItem(*pmTime,"Mastertrack",ID_TIME), this, SLOT(chooseMaster()) );
  menu->connectItem( menu->insertItem(*pmWave,"Audio Track",ID_WAVE), this, SLOT(chooseWave()) );
  menu->connectItem( menu->insertItem(*pmComm,"Comment",ID_COMMENT), this, SLOT(chooseComment()) );
  
  setAlignment(AlignCenter);
}

void MyChooser::mousePressEvent ( QMouseEvent * mouse ) {
  menu->popup( mapToGlobal(mouse->pos()), 0 );
}

void MyChooser::chooseDrum() { setPixmap(*pmDrum); qttrack->convertType(1); }

void MyChooser::chooseMaster() { setPixmap(*pmTime); qttrack->convertType(2); }

void MyChooser::chooseScore() { setPixmap(*pmScor); qttrack->convertType(0); }

void MyChooser::chooseWave() { setPixmap(*pmWave); qttrack->convertType(3); }

void MyChooser::chooseComment() { setPixmap(*pmComm); qttrack->convertType(4); }

MyLabel::MyLabel( QWidget * parent = 0, const char * name = 0 )
  : QLabel(parent,name), qttrack((QtTrack*)parent)
{
  rbmenu = new QPopupMenu;
  rbmenu->setMouseTracking( TRUE );
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Change Trackname")), this, SLOT(changeName()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(klocale->translate("Delete Track")), this, SLOT(delTrack()) );
  
}

void MyLabel::mousePressEvent ( QMouseEvent * mouse ) {
  if (mouse->button()==LeftButton) {
  }
  if (mouse->button()==RightButton) {
    rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}

void MyLabel::changeName() { 
  le = new QLineEdit(this,qttrack->gTrack()->gName());//,WStyle_Customize | WStyle_NoBorder);
  //le->recreate(this,WStyle_Customize | WStyle_NoBorder,mapToGlobal(this->pos()+QPoint(-68,0)));
  le->setText((char*)qttrack->gTrack()->gName());
  le->setFixedHeight(height()-2); le->setFixedWidth(width()-8);
  // le->setGeometry(mapToGlobal(this->pos()).x(),mapToGlobal(this->pos()).y(),220,40);
  le->show();
  le->setActiveWindow();
  le->setFocus();
  connect(le,SIGNAL(returnPressed()),SLOT(setName()));
}

void MyLabel::setName() {
  qttrack->gTrack()->sName((char*) le->text());
  qttrack->update();
  delete le;
}

void MyLabel::delTrack() {
  QtMain * qtmain = qttrack->gQtMain();
  qttrack->gQtMain()->msg("Track deleted");
  KbTrack * mytr = qttrack->gTrack();
  KbTrack * tr=0;
  for (tr=qttrack->gQtMain()->gMain()->gTrack(); tr!=0&&tr->gNext()!=mytr; tr=tr->gNext()) {}
  if (tr!=0) {
    tr->sNext(mytr->gNext());
    delete mytr;
  } else {
    qttrack->gQtMain()->gMain()->sTrack(mytr->gNext());
    delete mytr;
  }
  qtmain->adjustHeight();
}


QtTrack::QtTrack(KbTrack * kbtrack)
  : QWidget((QWidget*)((QtMain*)kbtrack->gMain()->gInterface())->gLeft(),"track"), track(kbtrack)
{
  int n = track->trackNum()+1; // the underlying kbTrack of this qtTrack is not registered yet, that's why +1 !
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);

  KIconLoader * loader = kapp->getIconLoader();

  QPixmap * pmLock = new QPixmap(loader->loadIcon( "lock.xpm" )); pmLock->setMask(pmLock->createHeuristicMask());
  QPixmap * pmMute = new QPixmap(loader->loadIcon( "mute.xpm" ));
  // QPixmap * pmNote = new QPixmap(loader->loadIcon( "note.xpm" ));
  // QPixmap * pmWav  = new QPixmap(loader->loadIcon( "wav.xpm" ));

  mute = new TogBut( 0, track, pmMute, 0, this, "mute" );
  mute->setFrameStyle( QFrame::Panel | QFrame::Raised );
  mute->setGeometry(0,0,24,hh+1);

  type = new MyChooser(this);
  type->setFrameStyle( QFrame::Panel | QFrame::Raised );
  type->setGeometry(24,0,24,hh+1);

  lock = new TogBut( 1, track, pmLock, 0, this, "lock" );
  lock->setFrameStyle( QFrame::Panel | QFrame::Raised );
  lock->setGeometry(48,0,24,hh+1);

  trname = new MyLabel(this);
  trname->setText(track->gName());
  trname->setFrameStyle( QFrame::Panel | QFrame::Raised );
  trname->setGeometry(72,0,96,hh+1);

}

QtTrack::~QtTrack() {

}

QtMain * QtTrack::gQtMain() {
  return (QtMain*) track->gMain()->gInterface();
}

KbTrack * QtTrack::gTrack() {
  return track;
}

void QtTrack::erase() {
  delete this;
}

void QtTrack::update() {
  // mute->update(); track->gMain()->muteTrack(track->trackNum());
  // type->update();
  int n = track->trackNum()+1;
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);
  lock->update();
  trname->setText(track->gName());
}


int QtTrack::height() {
  return ((QtMain*)track->gMain()->gInterface())->gTrackHeight();
}

int QtTrack::width() {
  return ((QtMain*)track->gMain()->gInterface())->gTrackWidth();
}

void QtTrack::adjustHeight() {
  int n = track->trackNum()+1;
  int hh = height();
  setGeometry(0,n*(1+hh),width(),hh);
  mute->setGeometry(0,0,24,hh+1);
  type->setGeometry(24,0,24,hh+1);
  lock->setGeometry(48,0,24,hh+1);
}


bool QtTrack::convertType(int i) {
  bool rv = true;
  if (gTrack()->isA()==i) {
  } else {
    if (gTrack()->gPart()) {
      QMessageBox::information( this, "brahms",
				"You may not change the type unless the track is empty.\n"
				"" );
      rv = false;
    } else {
      gQtMain()->gMain()->convertTrack(gTrack(),i);
    }
  }
  return rv;
}


// *******************************************************
//
// Toggle Buttons
// ==============
//


TogBut::TogBut( int n, KbTrack * kbtrack, QPixmap * pic, QPixmap * pic2, QWidget * parent=0, const char * name=0 )
  : QLabel( parent, name ), num(n), track(kbtrack), qttrack((QtTrack*)parent), icon(pic), icon2(pic2)
{
  if (icon2==0) icon2 = new QPixmap();
  setAlignment(AlignCenter);
  setPixmap( *icon2 );
}

void TogBut::mousePressEvent( QMouseEvent * mouse ) {
  if (mouse->button()==LeftButton) {
    if (track->gToggle(num)==TRUE) {
      // Off
      setPixmap( *icon2 );
      track->sToggle(num,FALSE);
    } else {
      // On
      setPixmap( *icon );
      setAlignment(AlignCenter);
      track->sToggle(num,TRUE);
    }
    qttrack->update();
  }
}

void TogBut::update() {
  if (track->gToggle(num)==TRUE) {
    // On
    setPixmap( *icon );
  } else {
    // Off
    setPixmap( *icon2 );
  }
}








#endif
