#ifndef _QTPIANOBUTTONS_C_
#define _QTPIANOBUTTONS_C_

#include <qaccel.h>

#include "qtPianoButtons.h"
#include "qtPiano.h"

PButtonbar::PButtonbar( QWidget *parent=0, const char *name=0 )
  : KToolBar( parent ), piano((QtPiano*)parent)
  // QFrame( parent ), piano((QtPiano*)parent)
{
  KIconLoader *loader = kapp->getIconLoader();

  pb[0] = new QPushButton( this ); pb[0]->setPixmap( loader->loadIcon( "pnb1.xpm" ) );
  pb[1] = new QPushButton( this ); pb[1]->setPixmap( loader->loadIcon( "pnb2.xpm" ) );
  pb[2] = new QPushButton( this ); pb[2]->setPixmap( loader->loadIcon( "pnb4.xpm" ) );
  pb[3] = new QPushButton( this ); pb[3]->setPixmap( loader->loadIcon( "pnb8.xpm" ) );
  pb[4] = new QPushButton( this ); pb[4]->setPixmap( loader->loadIcon( "pnb16.xpm" ) );
  pb[5] = new QPushButton( this ); pb[5]->setPixmap( loader->loadIcon( "pnb32.xpm" ) );
  pb[6] = new QPushButton( this ); pb[6]->setPixmap( loader->loadIcon( "pnb64.xpm" ) );
  pb[7] = new QPushButton( this ); pb[7]->setPixmap( loader->loadIcon( "pnbD.xpm" ) );
  pb[8] = new QPushButton( this ); pb[8]->setPixmap( loader->loadIcon( "pnbT.xpm" ) );

  // position
  QLabel * lPos = new QLabel("pos",this);
  lPos->setGeometry(14,2,30,18);

  sprintf(position," - ");
  qlPosition = new QLabel(position,this);
  qlPosition->setFont(QFont("courier"));
  qlPosition->setGeometry(44,2,82,18);

  // freq
  QLabel * lFreq = new QLabel("pitch",this);
  lFreq->setGeometry(132,2,40,18);

  sprintf(freq," - ");
  qlfreq = new QLabel(freq,this);
  qlfreq->setGeometry(162,2,20,18);

  // Note Lengths
  for (int i=0;i<9;i++) {
    pb[i]->setGeometry(192+i*18, 2, 18, 18); pb[i]->setToggleButton(TRUE);
  }
  curlen = 3; pb[3]->setOn(TRUE);
  for (int i=0;i<7;i++) {
    connect(pb[i], SIGNAL(toggled(bool)),SLOT(noteToggle(bool))); pb[i]->setAccel(0x8000 + 49+i); // ALT = 0x8000
  }

  connect(pb[7], SIGNAL(toggled(bool)),SLOT(dotToggle(bool))); pb[7]->setAccel(0x8000 + '.');
  connect(pb[8], SIGNAL(toggled(bool)),SLOT(triToggle(bool))); pb[8]->setAccel(0x8000 + Key_T);


  setCursor(QCursor(0));

}

void PButtonbar::setPos(int a, int b, int c) {
  if (a+b+c>0) {
    sprintf(position,"%3d.%2d.%3d",a,b,c);
  } else {
    sprintf(position," - ");
  }  
  qlPosition->setText(position);
}

void PButtonbar::setFreq(char c, int o, bool shft, bool ctrl) {
  char s = ' ';
  if (o!=-2) {
    if (shft==TRUE) s = '#';
    if (ctrl==TRUE) s = 'b';
    if (s==' ') sprintf(freq,"%c%d",c,o);
    else sprintf(freq,"%c%c%d",c,s,o);
  } else {
    sprintf(freq," - ");
  }
  qlfreq->setText(freq);
}

void PButtonbar::noteToggle(bool on) {
  if (on==TRUE) {
    if (curlen != -1) pb[curlen]->setOn(FALSE);
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) curlen = i;
    }
    if (curlen==-1) curlen = 3;
    piano->sLenValue(curlen+1);
    // piano->updateCursor();
  } else {
    int x = -1;
    for (int i=0;i<7;i++) {
      if (pb[i]->isOn()==TRUE) x = i;
    }
    if (x==-1) { x=curlen; curlen=-1; pb[x]->setOn(TRUE); }
  }
}

void PButtonbar::dotToggle(bool on) {
  if (on==TRUE) {
    piano->sDotValue(TRUE);
  } else {
    piano->sDotValue(FALSE);
  }
}

void PButtonbar::triToggle(bool on) {
  if (on==TRUE) {
    piano->sTriValue(TRUE);
  } else {
    piano->sTriValue(FALSE);
  }
}



#endif
