#ifndef _KBTRACK_H_
#define _KBTRACK_H_

#include "ifFactory.h"
#include "kbMain.h"
#include "ifTrack.h"
#include "kbPart.h"
#include "kbPosition.h"

/**
 * A Brahms song can consist of several tracks, where each track may consist of several parts and 
 * each part finally consists of a bunch of notes (in future: as well as other midi-events).
 * The KbMain object is connected to the first track, the other tracks are added in a chain,
 * i.e. each track has a pointer next, that points to the next track and can be set via sNext() and
 * obtained via gNext().\\
 * The presentation is attached via the interface (as in KbMain and KbPart), which can be obtained
 * gInterface.
 * @see KbMain::gTrack
 * @see IfTrack
 * @see QtTrack
 * @see TxTrack
 * @short   The Brahms Track class
 * @author  Jan Wuerthner
 * @version 0.95
 */
class KbTrack
{
 protected:
  IfTrack * ifTrack;
  KbMain  * main;
  KbTrack * next;
  KbPart  * part;
  bool toggle[2];
  char name[201];
  int type;

 public:
  
  /**
   * Constructor to create a track.
   * @param kbMain to remember the main object.
   * @param i this optional parameter may set the midi channel, when constructing a track.
   */
  KbTrack( KbMain * kbMain, int i=-1 );
  
  ~KbTrack();

  /**
   * @return the next track in the chain.
   * @see #sNext
   */
  KbTrack * gNext();

  /**
   * sets the next track in the chain.
   * @param tr the track supposed to follow this track.
   * @see #gNext
   */
  void sNext( KbTrack * tr );

  /** 
   * @return the main object.
   * @see KbMain
   */
  KbMain * gMain();

  /**
   * calculates a track's order number within the chain.
   * @return the order number of the track within the chain. (This is calculated each time trackNum() is called!)
   */
  int trackNum();

  /** 
   * @return the interface to the presentation.
   * @see IfTrack
   */
  IfTrack * gInterface();

  /**
   * returns the first part
   */
  virtual KbPart * gPart();

  bool gToggle(int n);

  void sToggle(int i,bool n);

  /**
   * sets the first part
   */
  void sPart(KbPart * p);

  /**
   * adds a part to the track.
   */
  virtual KbPart * addPart(KbPosition os = 0);

  virtual void setPart(KbPart*);

  /**
   * returns the tracks name
   */
  char * gName();

  /**
   * sets the tracks name
   */
  void sName(char * n);

  int isA();
};

#endif
