#ifndef _KBAUXELEMENT_C_
#define _KBAUXELEMENT_C_

#include "kbAuxElement.h"

KbAuxElement::KbAuxElement(KbPosition p) : pos(p) {}

KbPosition KbAuxElement::gPos() { return pos; }

void KbAuxElement::sPos(KbPosition p) { pos=p; if (pos<0) pos = 0; }

bool KbAuxElement::isNote() { return false; }

bool KbAuxElement::isAuxElement() { return true; }

bool KbAuxElement::isMidiEvent() { return false; }

bool KbAuxElement::isMasterEvent() { return false; }

bool KbAuxElement::isAuxText() { return false; }

bool KbAuxElement::isAuxSymbol() { return false; }

bool KbAuxElement::isAuxParSymbol() { return false; }

ostream & KbAuxElement::print(ostream&s) { // DOIT
  s << "<AUX />" << endl;
}

KbAtom * KbAuxElement::copy() {
  KbAtom * retv = new KbAuxElement(pos);
  cout << "PANIC: KbAuxElement::copy() not implemented yet!" << endl;
  return retv;
}


KbText::KbText(KbPosition p, char * t, int o) : KbAuxElement(p), txt(t), yoff(o) {}

char * KbText::gText() { return txt; }

void KbText::sText(char * t) { txt = t; }

int KbText::gOffset() { return yoff; }

void KbText::sOffset(int i) { yoff = i; }

bool KbText::isAuxText() { return true; }

bool KbText::isAuxSymbol() { return false; }

bool KbText::isAuxParSymbol() { return false; }

ostream & KbText::print(ostream&s) {
  s << "<TEXT text=\"" << txt << "\" pos =\"" << pos << "\" offset=\"" << yoff << "\" />" << endl;
}

KbAtom * KbText::copy() {
  KbAtom * retv = new KbText(pos,txt,yoff);
  return retv;
}



KbSymbol::KbSymbol(KbPosition p, int s, int o) : KbAuxElement(p), symbol(s), yoff(o) {}

int KbSymbol::gSymbol() { return symbol; }

void KbSymbol::sSymbol(int i) { symbol = i; }

int KbSymbol::gOffset() { return yoff; }

void KbSymbol::sOffset(int i) { yoff = i; }

bool KbSymbol::isAuxText() { return false; }

bool KbSymbol::isAuxSymbol() { return true; }

bool KbSymbol::isAuxParSymbol() { return false; }

ostream & KbSymbol::print(ostream&s) {
  s << "<SYMBOL symbol=\"" << symbol << "\" pos=\"" << pos << "\" offset=\"" << yoff << "\" />" << endl;
}

KbAtom * KbSymbol::copy() {
  KbAtom * retv = new KbSymbol(pos,symbol,yoff);
  return retv;
}



KbParSymbol::KbParSymbol(KbPosition p, int s, int o, int par) : KbAuxElement(p), symbol(s), yoff(o), parameter(par) {}

int KbParSymbol::gSymbol() { return symbol; }

void KbParSymbol::sSymbol(int i) { symbol = i; }

int KbParSymbol::gOffset() { return yoff; }

void KbParSymbol::sOffset(int i) { yoff = i; }

int KbParSymbol::gParameter() { return parameter; }

void KbParSymbol::sParameter(int i) { parameter = i; }

bool KbParSymbol::isAuxText() { return false; }

bool KbParSymbol::isAuxSymbol() { return false; }

bool KbParSymbol::isAuxParSymbol() { return true; }

ostream & KbParSymbol::print(ostream&s) {
  s << "<PARSYMBOL symbol=\"" << symbol << "\" parameter=\"" << parameter << "\" pos=\"" << pos << "\" offset=\"" << yoff << "\" />" << endl;
}

KbAtom * KbParSymbol::copy() {
  KbAtom * retv = new KbParSymbol(pos,symbol,yoff,parameter);
  return retv;
}

#endif
