// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "MainWindow.h"
#include "CDTrack.h"
#include "TrackWindow.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qlayout.h>


#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurl.h>

#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

extern KLocale *locale;

void MainWindow::newProject(void)
 {
  ProjectPath[0]=0;
  if (TrackEdit!=0)
   {
    delete (TrackEdit);
    TrackEdit=0;
   }
   {
    int i;
    for (i=0;i<MAX_TRACKS_PER_PROJECT;++i)
     {

      if (ProjectTracks[i]!=0)
       {
        delete(ProjectTracks[i]);
       }
      if (TrackItems[i]!=0)
       {
        delete(TrackItems[i]);
       }
      ProjectTracks[i]=0;
      TrackItems[i]=0;
     }
    CurrentTrack=-1;
   }
  checkWidgetEnable();
 }

void MainWindow::openProject(void)
 {
  QString openname;
  newProject();
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(QString::null,"*.cdp",this,locale->translate("Open project")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(0,"*.cdp",this,locale->translate("Open project"));
  KURL::decodeURL(openname);
#endif
  strcpy(ProjectPath,openname.data());
  if (ProjectPath[0]==0)
   {
    return;
   }
   {
    KConfig kc(ProjectPath);
    loadProjectFromConfig(&kc);
   }

  checkWidgetEnable();
 }

void MainWindow::saveProject(void)
 {
  QString savename;
  if (ProjectPath[0]==0)
   {
#if QT_VERSION >= 200
    savename=KFileDialog::getSaveURL(QString::null,"*.cdp",this,locale->translate("Save project")).path();
    KURL::decode(savename);
#else
    savename=KFileDialog::getSaveFileName(0,"*.cdp",this,locale->translate("Save project"));
    KURL::decodeURL(savename);
#endif
    strcpy(ProjectPath,savename.data());
    if (ProjectPath[0]==0) return;

     {
      char *cptr,i=0;
      cptr=ProjectPath;
      while (*(cptr++)!=0) ++i;
      if ( (i<4) || (strcmp (cptr-5,".cdp")!=0) )
       {
        if ( (i>0) && (*(cptr-2)=='/') ) strcat(ProjectPath,"kreatecd");
        strcat(ProjectPath,".cdp");
       }
     }
   }
  remove(ProjectPath);
   {
    KConfig kc(ProjectPath);
    saveProjectToConfig(&kc);
   }
 }

void MainWindow::loadProjectFromConfig(KConfig *kc)
 {
  int tracks=0,i;
  kc->setGroup("Global");
  tracks=kc->readNumEntry("Tracks",0);

  for (i=0;i<tracks;++i)
   {
    char xgroup[12];
    sprintf(xgroup,"Track%d",i+1);
    kc->setGroup(xgroup);
    ProjectTracks[i]= new CDTrack(kc);
    if (ProjectTracks[i]==0) break;
    TrackItems[i]=new QListViewItem(MWTracklist);
    if (TrackItems[i]==0)
     {
      delete(ProjectTracks[i]);
      ProjectTracks[i]=0;
      break;
     }

    CurrentTrack=i;

    MWEditTrack->setEnabled(TRUE);
    MWDeleteTrack->setEnabled(TRUE);
    MWTrackUp->setEnabled(TRUE);
    MWTrackUpdate->setEnabled(TRUE);
    MWTrackDown->setEnabled(TRUE);

    updateTrackItem();
    CurrentTrack=-1;

   }
 }

void MainWindow::saveProjectToConfig(KConfig *kc)
 {
  int i,tracks=0;

  kc->setGroup("Global");
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i)
   {
    if (ProjectTracks[i]==0) break;
   }
  tracks=i;
  kc->writeEntry("Tracks",tracks);
  for (i=0;i<tracks;++i)
   {
    char xgroup[12];
    sprintf(xgroup,"Track%d",i+1);
    kc->setGroup(xgroup);
    ProjectTracks[i]->saveTrack(kc);
   }
 }

void MainWindow::saveProjectAs(void)
 {
  ProjectPath[0]=0;
  saveProject();
 }
