// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "ProgressDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kprogress.h>
#include <keditcl.h>

#include <qpushbutton.h>
#include <qwindowdefs.h>
#include <qlayout.h>
#include <qlabel.h>



#include <strings.h>
#include <stdio.h>
#include <stdlib.h>


extern KLocale *locale;

ProgressDialog::ProgressDialog( QWidget *parent, const char *name,const char *prefworktext,
                                enum ProgressType ptyp,bool modal)
               :QWidget(parent,name,modal?WType_Modal:0)
 {
  KConfig *config;
  QRect DefaultRect(100,100,400,200);

  isModal=modal;
  oldval=-1;
  oldmax=-1;
  oldval2=-1;
  oldmax2=-1;
  this->setCaption(locale->translate("KreateCD is working..."));
  pvlayout=new QVBoxLayout(this);

#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif

  pwork=new QLabel(this,"prograss label");
  pwork->setAlignment(AlignCenter);
  pwork->setMinimumSize(300,80);
  pvlayout->addWidget(pwork,10);
  pvlayout->addStretch(1);


  if (ptyp!=Progress_None)
   {
    pwidget=new KProgress(KProgress::Horizontal,this,"progress dialog");
    pwidget->setMinimumSize(pwidget->sizeHint());
    pvlayout->addWidget(pwidget,1);
    pvlayout->addStretch(1);
   }
   else
   {
    pwidget=0;
   }

  if (ptyp==Progress_Double)
   {
    pwidget2=new KProgress(KProgress::Horizontal,this,"progress dialog");
    pwidget2->setMinimumSize(pwidget2->sizeHint());
    pvlayout->addWidget(pwidget2,1);
    pvlayout->addStretch(1);
   }
   else
   {
    pwidget2=0;
   }

  pcancel=new QPushButton(locale->translate("Abort"),this,"progress cancel");
  pcancel->setFixedSize(pcancel->sizeHint());
  pvlayout->addWidget(pcancel);

  setWorkText(prefworktext);

  pvlayout->activate();

  connect(pcancel,SIGNAL(clicked()),this,SLOT(cancelPressed()));

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("ProgressDialogGeo",&DefaultRect)); 
  edit=0;
 }

ProgressDialog::~ProgressDialog(void)
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Geometry");
  config->writeEntry("ProgressDialogGeo",SaveRect); 
 }

int ProgressDialog::exec(void)
 {
  wasShown=isVisible();
  if ( isModal && !wasShown) show();
  kapp->enter_loop();
  if ( isModal && !wasShown) hide();
  return progressResult;
 }

void ProgressDialog::done(int result)
 {
  progressResult=result;
  kapp->exit_loop();
 }

void ProgressDialog::printStatusLine(QString line)
 {
  if (edit==0) return;
  edit->insertLine(line);
  edit->setCursorPosition(edit->numLines(),0,false);
 }

void ProgressDialog::addStatusView(void)
 {
  QSize vsiz(100,50);
  if (edit!=0) return;
#if QT_VERSION >= 200
  edit=new KEdit(this);
#else
  edit=new KEdit(kapp,this);
#endif
  edit->setReadOnly(true);
  vsiz.setHeight(edit->font().pointSize()*10);
  edit->setMinimumSize(vsiz);
  pvlayout->addStretch(1);
  pvlayout->addWidget(edit,60);
 }

void ProgressDialog::cancelPressed(void)
 {
  emit canceled();
 }

void ProgressDialog::setWorkText(const char *newworktext)
 {
  if (newworktext)
   {
    strcpy(worktext,newworktext);
   }
   else
   {
    worktext[0]=0;
   }
  strcpy(progresstext,locale->translate("KreateCD is working..."));
  if (worktext[0])
   {
    strcat(progresstext,"\n\n");
    strcat(progresstext,worktext); 
   }
  pwork->setText(progresstext);


 }

void ProgressDialog::setProgress(long int val,long int maxval)
 {
  if (pwidget==0) return;
  if (val!=oldval)
   {
    pwidget->setValue(val);
    oldval=val;
   }
  if (maxval!=oldmax)
   {
    pwidget->setRange(0,maxval);
    oldmax=maxval;
   }
 } 

void ProgressDialog::setProtectedProgress(long int val,long int maxval)
 {
  int c1=0,c2=0;
  int p1,p2;

  if (pwidget==0) return;
  p1=oldval*100/oldmax;
  if (val>oldval)
   {
    c1=1;
    oldval=val;
   }
  if (maxval!=oldmax)
   {
    c2=1;
    c1=1;
    oldmax=maxval;
    oldval=val;
   }
  p2=oldval*100/oldmax;
  if ( (!c2) && (p2==p1) ) return;
  if (c1) 
   {
    pwidget->setValue(val);
   }
  if (c2) 
   {
    pwidget->setRange(0,maxval);
   }
 } 

void ProgressDialog::setSecondProgress(long int val,long int maxval)
 {
  if (pwidget2==0) return;
  if (val!=oldval2)
   {
    pwidget2->setValue(val);
    oldval2=val;
   }
  if (maxval!=oldmax2)
   {
    pwidget2->setRange(0,maxval);
    oldmax2=maxval;
   }
 }

void ProgressDialog::setSecondProtectedProgress(long int val,long int maxval)
 {
  int c1=0,c2=0;
  int p1,p2;

  if (pwidget2==0) return;
  p1=oldval2*100/oldmax2;
  if (val>oldval2)
   {
    c1=1;
    oldval2=val;
   }
  if (maxval!=oldmax2)
   {
    c2=1;
    oldmax2=maxval;
    c1=1;
    oldval2=val;
   }
  p2=oldval2*100/oldmax2;
  if ( (!c2) && (p2==p1) ) return;
  if (c1) 
   {
    pwidget2->setValue(val);
   } 
 if (c2)
   {
    pwidget2->setRange(0,maxval);
   }
 }


void ProgressDialog::abortDialog(int returncode)
 {
  done(returncode);
 }


void ProgressDialog::abortCancel(void)
 {
  done(-1);
 }

