// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "BusScanner.h"
#include "ProgressDialog.h"

#include <qstring.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "uidcontrol.h"
#include "pathconfig.h"

extern KLocale *locale;

void BusScanner::scanSCSIBus(void)
 {
  int i,k;
  KConfig *config;

  prepareProcess(ProgressDialog::Progress_None);

#if QT_VERSION >=200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif

  config->setGroup("Path");
  if ROOT_CALLED
   {
    *this<<config->readEntry("PathCdrecord",PATH_CDRECORD)<<"-scanbus";
   }
   else
   {
    *this<<PATH_CDRECORD<<"-scanbus";
   }
 current_scsibus=-1;
  for (k=0;k<MAX_SCSI_HOSTS;++k)
   {
    for (i=0;i<MAX_SCSI_UNITS;++i)
     {
      scsitype[k][i]=0;
      scsimanuf[k][i][0]='-';
      scsimanuf[k][i][1]=0;
      scsiprod[k][i][0]='-';
      scsiprod[k][i][1]=0;
     }
   }
  unsetenv("CDR_DEVICE"); // workaround for cdrecord
  setWorkText(locale->translate("Scanning SCSI bus..."));
  startProcess();
  closeProcess();
 }

int BusScanner::getSCSIType(int unit,int host)
 {
  if ( (unit>=MAX_SCSI_UNITS) || (unit<0) ) return(0);
  if ( (host>=MAX_SCSI_HOSTS) || (host<0) ) return(0);
  return (scsitype[host][unit]);
 }

const char * BusScanner::getSCSIManu(int unit,int host)
 {
  if ( (unit>=MAX_SCSI_UNITS) || (unit<0) ) return(0);
  if ( (host>=MAX_SCSI_HOSTS) || (host<0) ) return(0);
  return(scsimanuf[host][unit]);
 }

const char * BusScanner::getSCSIProd(int unit,int host)
 {
  if ( (unit>=MAX_SCSI_UNITS) || (unit<0) ) return(0);
  if ( (host>=MAX_SCSI_HOSTS) || (host<0) ) return(0);
  return(scsiprod[host][unit]);
 }

static int copyQuotedString(char **ptr,char *dest)
 {
  while (**ptr==' ') ++(*ptr);
  if (**ptr!='\'') return(0);
  ++(*ptr);
  while ( (**ptr!=0) && (**ptr!='\'') )
   {
    *(dest++)=**ptr;
    ++(*ptr);
   }
  *dest=0;
  if (**ptr==0) return(0);
  ++(*ptr);

  return(1);
 }

bool BusScanner::processStdoutLine(char *linebuffer)
 {
   if (strncmp("scsibus",linebuffer,7)==0)
    {
     long int sbus;
     sbus=strtol(linebuffer+7,0,10);
     if ( (sbus<0) || (sbus>(MAX_SCSI_HOSTS-1)) )
      {
       sbus=-1;
      }
     current_scsibus=sbus;
    }
    else
    {
     char *cptr,*dptr;
     long int unit;
     char dummy[40];
     cptr=linebuffer;
     do
      {
       if (*cptr==',') ++cptr;
       while ( (*cptr==' ') || (*cptr==9) )
        {
         ++cptr;
        }
       unit=strtol(cptr,&dptr,10);
       if (cptr==dptr) return(true);
       cptr=dptr;
      } while ( (*cptr==',') || (*cptr==' ') || (*cptr==9));
     if (*(cptr++)!=')') return(true);
     unit=unit%100;
     if ( (unit<0) || (unit>(MAX_SCSI_UNITS)) ) return(true);
     if (current_scsibus==-1) return(true);
     if (!copyQuotedString(&cptr,scsimanuf[current_scsibus][unit])) return(true);
     if (!copyQuotedString(&cptr,scsiprod[current_scsibus][unit])) return(true);
     if (!copyQuotedString(&cptr,dummy)) return(true);
     while (*cptr==' ') ++cptr;
     scsitype[current_scsibus][unit]=1;
     if (strncmp("Removable CD-ROM",cptr,16)==0) scsitype[current_scsibus][unit]=2;
     if (strncmp("Removable WORM",cptr,14)==0) scsitype[current_scsibus][unit]=2;
    }
  return(true);
 }

