// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

#include "DriveAccess.h"

class ConfSCSI : public QWidget
 {
  Q_OBJECT;
  
 
  public:
    ConfSCSI( QWidget *parent=0, const char *name=0);
    ~ConfSCSI(void);
    void hide(void);
 
  signals:
    void closed(void);


  protected slots:
         void clickedWriter(int unit);
         void clickedCDROM(int unit);
         void applySettings(void);
         void okButton(void);
         void cancelButton(void);

         void updateWriterButtons(void);
         void updateCdromButtons(void);
         void increaseWriterHost(void);
         void decreaseWriterHost(void);
         void increaseCdromHost(void);
         void decreaseCdromHost(void);

  private:

    class QButtonGroup *scsiboxes[2];
    class QRadioButton *scsibuttons[2][MAX_SCSI_UNITS];
    class QPushButton  *okbutton;
    class QPushButton  *applybutton;
    class QPushButton  *cancelbutton;

    class KNumericSpinBox   *writerhostspin;
    class KNumericSpinBox   *cdromhostspin;

    class DriveAccess  *SCSIBus;

    char scsidevs[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][32];
    


    int cdrom_id;
    int writer_id;
    int cdrom_host;
    int writer_host;



 };


