// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "MainWindow.h"
#include "CDTrack.h"
#include "AudioFile.h"
#include "DriveAccess.h"

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qkeycode.h>
#include <qpopupmenu.h>
#include <qlayout.h>


#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>



#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>



void MainWindow::setupCopy(void)
 {
  int i;
  DriveAccess da;
  newProject();

  if (!da.readTOC())
   {
    return;
   }
  i=0;
  while (1)

   {
    if (da.getTOCDuration(i+1)==-1) break;
    ProjectTracks[i]=new CDTrack();
    if (ProjectTracks[i]==0) break;
     {
      char trd[20];
      sprintf(trd,"Track %d",i+1);
      ProjectTracks[i]->setDescription(trd);
     }
    ProjectTracks[i]->setTrackType(ProjectTracks[i]->getTOCType(da.getTOCType(i+1),da.getTOCMode(i+1)));
    ProjectTracks[i]->setSourceTrack(i+1,da.getTOCSum(),da.getTOCDuration(i+1),
                                     da.getTOCLBA(i+1));

    TrackItems[i]=new QListViewItem(MWTracklist);
    if (TrackItems[i]==0)
     {
      delete(ProjectTracks[i]);
      ProjectTracks[i]=0;
      break;
     }

    CurrentTrack=i;
    updateTrackItem();

    ++i;
   }
  CurrentTrack=-1;
  checkWidgetEnable();
 }

void MainWindow::normalizeMax(void)
 {
  int i;
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i)
   {
    float cboost;
    AudioFile *audi;
    if (ProjectTracks[i]==0) continue;
    if (ProjectTracks[i]->getAudioFile()==0)
     {
      ProjectTracks[i]->validateTrack();
     }
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    audi->setMaxBoost();
    ProjectTracks[i]->clearImage();
    cboost=audi->getBoost();
   }
 }

void MainWindow::normalizeAllSame(void)
 {
  int i;
  float mmboost=99999;
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i)
   {
    float cboost;
    AudioFile *audi;
    if (ProjectTracks[i]==0) continue;
    if (ProjectTracks[i]->getAudioFile()==0)
     {
      ProjectTracks[i]->validateTrack();
     }
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    ProjectTracks[i]->clearImage();
    audi->setMaxBoost();
    cboost=audi->getBoost();
    if (cboost<mmboost) mmboost=cboost;
   }
  for (i=0;i<MAX_TRACKS_PER_PROJECT;++i)
   {
    AudioFile *audi;
    if (ProjectTracks[i]==0) continue;
    audi=ProjectTracks[i]->getAudioFile();
    if (audi==0) continue;
    audi->setBoost(mmboost);
   }
 }