/***************************************************************************
                          koncd.cpp  -  description
                             -------------------
    begin                : Don Mr  1 19:38:27 CET 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <kiconloader.h>

#include "koncd.h"
#include "setup.h"
#include "tools.h"
#include "imagetype.h"
#include "copycd.h"
#include "mastercd.h"
#include "audiocd.h"

KOnCD::KOnCD(QWidget *parent, const char *name) : KOnCD_MainWindow(parent, name){
	setupMenubar();
}

KOnCD::~KOnCD(){
}

// Setup menubar
void KOnCD::setupMenubar(){

	// KOnCD-menu entries
	KPopupMenu *p = new KPopupMenu;

	p->insertItem( i18n( "&Setup" ), this, SLOT( slot_setup() ) );
	p->insertSeparator();
	p->insertItem( i18n( "&Copy CD" ), this, SLOT( slot_copyCD() ) );
	p->insertItem( i18n( "&Master CD" ), this, SLOT( slot_masterCD() ) );
	p->insertItem( i18n( "&Audio CD" ), this, SLOT( slot_audioCD() ) );
	p->insertSeparator();
	p->insertItem( i18n( "&Tools" ), this, SLOT( slot_tools() ) );
	p->insertItem( i18n( "&Image Type" ), this, SLOT( slot_image_type() ) );
	p->insertSeparator();
	p->insertItem( i18n( "&Quit" ), this, SLOT( slot_exitApp() ), CTRL+Key_Q);

	// Help-menu entries
  const KAboutData *aboutData = KGlobal::instance()->aboutData();
  KHelpMenu *help_menu = new KHelpMenu( this, aboutData);
  KPopupMenu *help = help_menu->menu();

	// Insert menu
	KMenuBar *menubar = new KMenuBar( this );
	menubar->insertItem( i18n( "K&OnCD" ), p);
	menubar->insertItem( i18n( "&Help" ), help);
}

// 'Setup' clicked
void KOnCD::slot_setup(){
	Setup* dlg = new Setup;
	dlg->show();
}

// 'CopyCD-Button' clicked
void KOnCD::slot_copyCD(){
	CopyCD* dlg = new CopyCD;
	dlg->show();
}

// 'MasterCD-Button' clicked
void KOnCD::slot_masterCD(){
	MasterCD* dlg = new MasterCD;
	dlg->show();
}

// 'AudioCD-Button' clicked
void KOnCD::slot_audioCD(){
	AudioCD* dlg = new AudioCD;
	dlg->show();
}

// 'Tools-Button' clicked
void KOnCD::slot_tools(){
	Tools* dlg = new Tools;
	dlg->show();
}

// 'ImageType' clicked
void KOnCD::slot_image_type(){
	ImageType* dlg = new ImageType;
	dlg->show();
}

// 'Exit-Button' clicked
void KOnCD::slot_exitApp(){
	delete this;
}

//Close app
void KOnCD::closeEvent(QCloseEvent *){
	delete this;
}
