/***************************************************************************
                          cddata.h  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/
#ifndef CDDATA_H
#define CDDATA_H

#include <qobject.h>
#include <kprocess.h>

/**
  *@author Kai Heitkamp
  */

struct DEVICES {
	short bus, dev, speed;
	char vendor[30], name[30], version[20], desc[50], devstr[20];
	bool cdrw;
	struct DEVICES *next;
};

class CDdata : public QObject{
	Q_OBJECT
public: 
	CDdata( QObject * parent=0, const char * name=0 );
	~CDdata();
	bool isRW( int n );
	int eject( int n );
	int load( int n );
	int reset( int n );
	const char *showOutput();
	int getDev( int n, const char *(*arr)[4] );	
	int getDevParams( int n, const short *(*arr)[3] );
	const char * getDevStr( int n );
private:
	bool HaveRights;
	char prog[128];
	KProcess proc;
	struct DEVICES *Devices;
	QString output;
	char dummystr[20];
private slots:
	void slotOutput(KProcess *p, char *s, int n);
	void slotOutput1(KProcess *p, char *s, int n);
};

#endif
