/***************************************************************************
                          mastercd.cpp  -  description
                             -------------------
    begin                : Thu Jan 27 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <qfile.h>
#include <qdir.h>

#include <kfiledialog.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kmsgbox.h>

#include <ctype.h>

#include "koncd.h"
#include "cddata.h"
#include "mastercd.h"
#include "imagetype.h"
#include "createdirstruc.h"

MasterCD::MasterCD(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption( i18n( "KOnCD - Master CD" ) );
	initDialog();
	QLabel_ImageType->setAlignment( AlignCenter );
	setupConnections();

	//Read Image-Type from config file and display it
	KConfig *config = kapp->getConfig();
	config->setGroup("Image-Type");
	QLabel_ImageType->setText( config->readEntry( "Name" ) );

	//Check for RW-Device
	config->setGroup( "CD-Writer" );
	if ( config->readEntry( "isRW" ) == "false" )
	{
	QComboBox_CDRWBlanking->clear();	
	QComboBox_CDRWBlanking->insertItem(i18n( "None RW !" ));
	QComboBox_CDRWBlanking->setEnabled( false );
	}

/*	//-----for development only-----
	QLineEdit_SourceDir->setText( "/home/kai/Multimedia" );
	QLineEdit_ImageFile->setText( "/home/kai/mm.iso" );
	QCheckBox_Simulate->setChecked( true );	
	QCheckBox_nofix->setChecked( true );	
*/
}

MasterCD::~MasterCD(){
}

// Setup Connections
void MasterCD::setupConnections(){
	connect( QPushButton_ImageType, SIGNAL(clicked()), SLOT(slotImageType()) );
	connect( QPushButton_Start, SIGNAL(clicked()), SLOT(slotStart()) );
	connect( QPushButton_Quit, SIGNAL(clicked()), SLOT(slotExit()) );
	connect( QPushButton_Calculate, SIGNAL(clicked()), SLOT(slotCalculateSize()) );
	connect( QPushButton_SourceDir, SIGNAL(clicked()), SLOT(slotSetSourceDir()) );
	connect( QPushButton_FileManager, SIGNAL(clicked()), SLOT(slotFileManager()) );
	connect( QPushButton_ImageFile, SIGNAL(clicked()), SLOT(slotSetImageFile()) );
	connect( QPushButton_BootImage, SIGNAL(clicked()), SLOT(slotSetBootImage()) );
	connect( QCheckBox_BootableCD, SIGNAL(clicked()), SLOT(slotToggleBootableCD()) );
	connect( QCheckBox_CreateImage, SIGNAL(clicked()), SLOT(slotToggleCreateImage()) );
	connect( QCheckBox_WriteCD, SIGNAL(clicked()), SLOT(slotToggleWriteCD()) );
	connect( QCheckBox_Multisession, SIGNAL(clicked()), SLOT(slotMultisession()) );
}

//'SourceDir-Button' clicked
void MasterCD::slotSetSourceDir(){
	QString getName;
	getName = KFileDialog::getSaveFileName();
	QLineEdit_SourceDir->setText( getName );
}

//'File-Manager-Button' clicked
void MasterCD::slotFileManager(){
	CreateDirStruc* sdlg = new CreateDirStruc;
	sdlg->show();
	QLineEdit_SourceDir->setText( i18n( "User defined ISO-Tree !" ) );
	QLineEdit_ImageFile->setText( QDir::homeDirPath() + "/userdef.iso" );
}

//'ImageFile-Button' clicked
void MasterCD::slotSetImageFile(){
	QString getName;
	getName = KFileDialog::getSaveFileName();
	QLineEdit_ImageFile->setText( getName );
}

//'BootImage-Button' clicked
void MasterCD::slotSetBootImage(){
	QString getName;
	getName = KFileDialog::getSaveFileName();
	QLineEdit_BootImage->setText( getName );
}

//'Image-Type Button' clicked
void MasterCD::slotImageType(){
	ImageType* sdlg = new ImageType;
	sdlg->show();

	//Read Image-Type from config file and display it
	KConfig *config = kapp->getConfig();
	config->setGroup("Image-Type");
	QLabel_ImageType->setText( config->readEntry( "Name" ) );
}

//'QCheckBox_BootableCD' clicked , toggle BootableCD-QLineEdit and -Button
void MasterCD::slotToggleBootableCD(){
	QLineEdit_BootImage->setEnabled( QCheckBox_BootableCD->isChecked() ? true:false );
	QPushButton_BootImage->setEnabled( QCheckBox_BootableCD->isChecked() ? true:false );
}

//'QCheckBox_WriteCD' clicked
void MasterCD::slotToggleWriteCD(){
	QCheckBox_EjectCD->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_nofix->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_Simulate->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
//	QCheckBox_Multisession->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_Force->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_ignoresize->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
	QCheckBox_LeaveImage->setEnabled( QCheckBox_WriteCD->isChecked() ? true:false );
}

//'QCheckBox_CreateImage' clicked
void MasterCD::slotToggleCreateImage(){
	QCheckBox_BootableCD->setEnabled( QCheckBox_CreateImage->isChecked() ? true:false );
}

//'QCheckBox_Multisession' clicked
void MasterCD::slotMultisession(){
	QCheckBox_nofix->setEnabled( QCheckBox_Multisession->isChecked() ? false:true );
	if ( QCheckBox_nofix->isChecked() ) QCheckBox_nofix->setChecked( false );
}

//'Start-Button' clicked / master image and write the CD
void MasterCD::slotStart(){
	//--CheckBox_CreateImage is true--
	if ( QCheckBox_CreateImage->isChecked() ) {
		//If not valid Source-Dir specified
		if( ! strlen( QLineEdit_SourceDir->text() ) ) {
			KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Not valid Source-Dir !" ), 2 );
			return;
		}
		//If not valid Image-File specified
		if( ! strlen( QLineEdit_ImageFile->text() ) ) {
			KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Not valid Image-File !" ), 2 );
			return;
		}
		//If QCheckBox_BootableCD enabled and not valid Boot-Image specified
		if( QCheckBox_BootableCD->isChecked() && ! strlen( QLineEdit_BootImage->text() ) ) {
			KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Not valid Boot-Image !" ), 2 );
			return;
		}
		//Check for ImageType
		if( ! strlen( QLabel_ImageType->text() ) ) {
			KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Not valid Image-Type !" ), 2 );
			return;
		}
		//If multisession
		if ( QCheckBox_Multisession->isChecked() ) slotMSInfo();

		//Create the CD-Image
		else slotMakeImage();
	}

	//--CheckBox_WriteCD is true--
	if ( QCheckBox_WriteCD->isChecked() && ! QCheckBox_CreateImage->isChecked() ) {
		//If the Imagefile exists, than write the CD
		if ( ! QFile::exists( QLineEdit_ImageFile->text() ) ) {
			KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "The Imagefile does not exists !" ), 2 );
			return;
		}
		//Write the CD
		slotWriteCD();
		}
}

//---Create CD-Image with mkisofs---
void MasterCD::slotMakeImage(){
	KConfig *config = kapp->getConfig();

	//KProcess arguments
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "mkisofs" << "-f";

	//Image-Type
	config->setGroup("Image-Type");
	if ( config->readEntry( "Allowlongfilenames" ) == "true" ) (*process) << "-l";
	if ( config->readEntry( "Rockridgeextensions" ) == "true" ) (*process) << "-R";
	if ( config->readEntry( "Rockridgewithanonymity" ) == "true" ) (*process) << "-r";
	if ( config->readEntry( "Jolietextensions" ) == "true" ) (*process) << "-J";
	if ( config->readEntry( "Omittrailingperiods" ) == "true" ) (*process) << "-d";
	if ( config->readEntry( "Dontusedeepdirrelocations" ) == "true" ) (*process) << "-D";
	if ( config->readEntry( "Allowfilesbeginningwithadot" ) == "true" ) (*process) << "-L";
	if ( config->readEntry( "Omitisoversionnumbers" ) == "true" ) (*process) << "-N";

	//Arguments for multisession
	if ( QCheckBox_Multisession->isChecked() && existsSession ) {
		char tmp[50], dev[10], outdev[10];
		char *tmpdev;
		sprintf( tmp, "%d,%d", MS_Start, MS_End );
	 	(*process) << "-C" << tmp;
		config->setGroup("CD-Writer");
		strcpy(dev, config->readEntry("Device"));
		printf("%s\n", strtok(dev, "="));
		while ( (tmpdev=strtok(NULL, "=")) != NULL)
		strcpy(outdev, tmpdev);
		(*process) << "-M" << outdev;
	}

	//Bootable CD
	if( QCheckBox_BootableCD->isChecked() ) (*process) << "-b" << QLineEdit_BootImage->text() << "-c" << "boot_catalog";

	//CD-Identification
	if( QLineEdit_AppID->text()[0] ) (*process) << "-A" << QLineEdit_AppID->text();
	if( QLineEdit_Publisher->text()[0] ) (*process) << "-P" << QLineEdit_Publisher->text();
	if( QLineEdit_Preparer->text()[0] ) (*process) << "-p" << QLineEdit_Preparer->text();
	if( QLineEdit_VolumeID->text()[0] ) (*process) << "-V" << QLineEdit_VolumeID->text();

	//Image-File and Source-Dir
	QString sdir = QLineEdit_SourceDir->text();
	if( sdir == "User defined ISO-Tree !" ) (*process) << "-o" << QLineEdit_ImageFile->text() << "/tmp/isoimage/";
	else (*process) << "-o" << QLineEdit_ImageFile->text() << QLineEdit_SourceDir->text();

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( imgprocoutdlg.Button, SIGNAL(clicked()), this, SLOT(abortHandler()));

	//Connect the 'processExited' Signal to the 'slotBurnProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotMakeImageProcessExited(KProcess *)));

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotMakeImageStdout(KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotMakeImageStdout(KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start mkisofs !" ), 2 );

	imgprocoutdlg.StatusLabel -> setText( i18n("Creating CD-Image...") );
	if ( ! imgprocoutdlg.isVisible() ) imgprocoutdlg.show();
}

//---Write CD with cdrecord---
void MasterCD::slotWriteCD(){
	int rc;
	KConfig *config = kapp->getConfig();

	procoutdlg.QPushButton_OK->setEnabled( false );

	//KProcess argument
	KProcess *process = new KProcess();
	process->clearArguments();
	(*process) << "cdrecord" << "-v";

	//Set the CD-Writer first
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device");

	//Set CD-Writer Options to K(*process)
	if( QCheckBox_EjectCD->isChecked() ) (*process) << "-eject";
	if( QCheckBox_Force->isChecked() ) (*process) << "-force";
	if( QCheckBox_Multisession->isChecked() ) (*process) << "-multi";
	if( QCheckBox_Simulate->isChecked() ) (*process) << "-dummy";
	if( QCheckBox_nofix->isChecked() ) (*process) << "-nofix";
	if( QCheckBox_ignoresize->isChecked() ) (*process) << "-ignsize";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWBlanking -> currentItem()) )
		{
	   	if( rc == 1 ) (*process) << "blank=all";
	   	if( rc == 2 ) (*process) << "blank=fast";
	   	if( rc == 3 ) (*process) << "blank=track";
	   	if( rc == 4 ) (*process) << "blank=unreserve";
	   	if( rc == 5 ) (*process) << "blank=trtrail";
	   	if( rc == 6 ) (*process) << "blank=unclose";
	   	if( rc == 7 ) (*process) << "blank=session";
	   	}

	//Set CD-Writer Speed to KProcess)
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) (*process) << "speed=1";
	   	if( rc == 1 ) (*process) << "speed=2";
	   	if( rc == 2 ) (*process) << "speed=4";
	   	if( rc == 3 ) (*process) << "speed=6";
	   	if( rc == 4 ) (*process) << "speed=8";
	   	}

	//Set the Image
	(*process) << QLineEdit_ImageFile->text();

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( procoutdlg.QPushButton_OK, SIGNAL(clicked()), this, SLOT(abortHandler()));

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotBurnProcessExited(KProcess *)));

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotBurnRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotBurnRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n("Couldn't start cdrecord !"), 2 );
		return;
		}

	if ( ! procoutdlg.isVisible() ) procoutdlg.show();
}

//'Calculate-Button' clicked
void MasterCD::slotCalculateSize() {
	//If not valid Source-Dir specified
	if( ! strlen( QLineEdit_SourceDir->text() ) ) {
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Not valid Source-Dir !" ), 2 );
		return;
	}

	QPushButton_Start->setEnabled( false );
	QPushButton_Quit->setEnabled( false );
	QPushButton_Calculate->setText( "working..." );
	setCaption( i18n( "KOnCD - Master CD: Calculating CD-Image size" ) );

	//Start KProcess for calculating ISO-Image size with mkisofs
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "mkisofs" << "-print-size" << "-f";

	//Source-Dir
	QString sdir = QLineEdit_SourceDir->text();
	if( sdir == "User defined ISO-Tree !" ) (*process) << "/tmp/isoimage/";
	else (*process) << QLineEdit_SourceDir->text();

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT(slotCalculateProcessExited(KProcess *)));

	//Connect with all Signals from KProcess to Slot 'slotRecStderr'
	connect( process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotCalculateRecStderr (KProcess *, char *, int) ));
	connect( process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotCalculateRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start mkisofs !" ), 2 );			

}

//KProcess finished
void MasterCD::slotCalculateProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
 				KMsgBox::message( this, i18n( "KOnCD - Calculating" ), i18n( "An Error is occurred !\n" + statusout ), 4 );
				QPushButton_Start->setEnabled( true );
				QPushButton_Quit->setEnabled( true );
				QPushButton_Calculate->setText(i18n("&Calculate"));
				setCaption( i18n( "KOnCD - Master CD" ) );
				return;
			}
		QPushButton_Start->setEnabled( true );
		QPushButton_Quit->setEnabled( true );
		QPushButton_Calculate->setText(i18n("&Calculate"));
		setCaption( i18n( "KOnCD - Master CD" ) );
	}
}

//KProcess outout analysis
void MasterCD::slotCalculateRecStderr( KProcess *proc, char *buffer, int buflen) {
	char *c, buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	if( strstr( buf, "written =" ) ) {
		if( (c = rindex( buf, ' ' ) ) ) {		
			int s = atoi( c ) * 2 / 1024;
			char tmp[50];
			sprintf( tmp, "%d MB", s );
			QLabel_DataSize->setText( tmp );

			if( s > 650 && s < 730 ) {
				KMsgBox::message( this, i18n("KOnCD - Warning"), i18n( "The CD-Image becomes over 650 MB !\n"
																														"The 'Ignore medium size' options must be enabled\n"
																														"and use a CD-R 700 or higher !" ), 2 );
				QCheckBox_ignoresize->setChecked( true );
				return;
			}
			if( s > 730 ) {
				KMsgBox::message( this, i18n("KOnCD - Warning"), i18n( "The CD-Image becomes over 730 MB !\n"
																														"You can't write that on a CD-R !" ), 2 );
				return;
			}

		}
	}
}

//KProcess outout analysis
void MasterCD::slotBurnRecStderr(KProcess *proc, char *buffer, int buflen) {
	char *c, buf[1024];
	int wrote, total, load;

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	procoutdlg.Output->insertLine( buf );
	//Go to the End of the Output-Text
	procoutdlg.Output->setCursorPosition(procoutdlg.Output->numLines(),0,false);
	
	//Blanking a CD-RW
	if( strstr( buf, "Blanking" )) {
		procoutdlg.StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	//Burn without Fixating
	if( strstr( buf, "Writing  time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
	}

	//Fixating the CD-R
	if( strstr( buf, "Fixating..." )) {
		procoutdlg.StatusLabel -> setText( i18n("Writing TOC...") );
	}

	//	//Burn with Fixating
	if( strstr( buf, "Fixating time:" )) {
		procoutdlg.StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}
	
	if( strstr( buf, "MB written" )) {
		c = index( buf, ':' );
		if( c && *c ) {
			c = strtok( c, ":\r\t " );
			if( c ) {
				wrote = atoi( c );
				c = strtok( NULL, "\r\t " );
				c = strtok( NULL, "\r\t " );
				if( c ) {
					total = atoi( c );
					c = strtok( NULL, "\r" );
					c = strstr( c, "fifo " );
					if( c ) {
						c = strtok( c + 5, "%\r\t " );
						if( c ) {
							load = atoi( c );
							procoutdlg.WriteProgress -> setValue( total ? wrote * 100 / total : 0 );
	  						procoutdlg.BufferProgress -> setBarColor( QColor( 220, 30, 30 ) );
							if( load > 40 )
  							procoutdlg.BufferProgress -> setBarColor( QColor( 200, 200, 120 ) );
							if( load > 80 )
  							procoutdlg.BufferProgress -> setBarColor( QColor( 40, 100, 60 ) );
							procoutdlg.BufferProgress -> setValue( load );

							if( ( total == wrote ) ) {
								procoutdlg.StatusLabel -> setText( i18n("Writing TOC...") );
							}
							
							if( wrote ) {
								procoutdlg.StatusLabel -> setText( i18n("Writing to CD...") );
							}

						}
					}
				}
			}
		}		
	}	

}

//KProcess finished
void MasterCD::slotBurnProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				switch ( rcproc->exitStatus() )
				{
					case 13:		procoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
										break;

					case 19:		procoutdlg.StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
										break;

					case 254:	procoutdlg.StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
										break;

					case 255:	procoutdlg.StatusLabel -> setText( i18n( "Error: No CD in the Writer-Device !" ) );
										break;
				}
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
 				KMsgBox::message( this, i18n( "KOnCD - Burning" ), i18n( "An Error is occurred !\n" + statusout ), 4 );
				procoutdlg.QPushButton_OK->setEnabled( true );
				return;
			}
		//If 'Leave Image' CheckBox false, delete the Imagefile
		if ( rcproc->exitStatus() == 0 && ! QCheckBox_LeaveImage->isChecked() ) QFile::remove( QLineEdit_ImageFile->text() );
		procoutdlg.QPushButton_OK->setEnabled( true );
	}
}

//KProcess outout analysis
void MasterCD::slotMakeImageStdout(KProcess *proc, char *buffer, int buflen) {
	char *c, buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );

	//Add cdrecord Messages to the Output-Window
	imgprocoutdlg.Output->insertLine( buf );
	//Go to the End of the Output-Text
	imgprocoutdlg.Output->setCursorPosition(imgprocoutdlg.Output->numLines(),0,false);

	if( strstr( buf, "extents written" ) ) {
		imgprocoutdlg.ImgProgress->setValue( 100 );
		return;
	}

	if( strstr( buf, "% done" ) ) {
		if( (c = strtok( buf, "%" ) ) ) {
			imgprocoutdlg.ImgProgress->setValue( atoi( c ) );
		}
	}
}

//KProcess finished
void MasterCD::slotMakeImageProcessExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				if( rcproc->exitStatus() == 13 ) imgprocoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
 				KMsgBox::message( this, i18n( "KOnCD - Error" ), i18n( "An Error is occurred !\n" + statusout ), 4 );
				imgprocoutdlg.Button->setText( "&OK" );
				return;
			}
			//If CheckBox 'Write CD' checked, close the dialog and write the CD
			else if ( QCheckBox_WriteCD->isChecked() ){
				imgprocoutdlg.StatusLabel -> setText( i18n("Image creating completed.") );
				//Close ProcessDialog
				imgprocoutdlg.close();
				slotWriteCD();
			}
			else {
				imgprocoutdlg.StatusLabel -> setText( i18n("Image creating completed.") );
				imgprocoutdlg.Button->setText( "&OK" );
			}
	}
}

//KProcess for multisession info
void MasterCD::slotMSInfo() {
	KConfig *config = kapp->getConfig();

	//KProcess arguments
	KProcess *process = new KProcess();
	process->clearArguments();
 	(*process) << "cdrecord" << "-v";
	config->setGroup("CD-Writer");
	(*process) << config->readEntry("Device") << "-msinfo";

	//Connect the Abort-Button from ImgProOut-Dialog to Abort-Handler
	connect( imgprocoutdlg.Button, SIGNAL(clicked()), this, SLOT(abortHandler()));

	//Connect the 'processExited' Signal
	connect( process, SIGNAL(processExited(KProcess *)), this, SLOT( slotMSInfoExited( KProcess * ) ));

	//Connect with slotRecStderr to update KProgress
	connect( process, SIGNAL(receivedStdout(KProcess *, char *, int) ), this, SLOT( slotMSOutput(KProcess *, char *, int ) ));
	connect( process, SIGNAL(receivedStderr(KProcess *, char *, int) ), this, SLOT( slotMSOutput(KProcess *, char *, int ) ));

	//Start KProcess
	if( ! process->start( KProcess::NotifyOnExit, KProcess::AllOutput ) ) KMsgBox::message( this, i18n("KOnCD - Error"), i18n( "Couldn't start cdrecord !" ), 2 );			

	imgprocoutdlg.Button->setText( "&Abort" );
	imgprocoutdlg.StatusLabel -> setText( i18n("Retrieve multisession info...") );
	imgprocoutdlg.show();
}

//KProcess Analyse for msinfo output
void MasterCD::slotMSOutput( KProcess *p, char *s, int n ){
	char *c, *b, buf[1024];

	if( !n ) return;
	
	bzero( buf, sizeof( buf ) );
	strncpy( buf, s, n > (int) sizeof( buf ) ? sizeof(buf) - 1 : n );

	//Check for exists session
	if( strstr( buf, "status: 0x2 (CHECK CONDITION)" )) {
		imgprocoutdlg.StatusLabel -> setText( i18n( "None session available, creating image..." ) );
		existsSession = false;
	}

	c = strtok( buf, "\n" );
	while( c ) {
  	if( (b = strchr( c, ',' )) && isdigit( *c ) ) {
  		b = strtok( c, ",\n" );
  		if( b ) MS_Start = atoi( b );
  		b = strtok( NULL, ",\n" );
  		if( b ) MS_End = atoi( b );
  	}
		c = strtok( NULL, "\n" );	
	}
}

//KProcess 'msinfo' finished
void MasterCD::slotMSInfoExited(KProcess *rcproc) {
	//Check, if KProcess exited normally...
	if( rcproc->normalExit() ) {
 			if( rcproc->exitStatus() != 0 ) {
				switch ( rcproc->exitStatus() )
				{
					case 13:		imgprocoutdlg.StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
										break;

					case 19:		imgprocoutdlg.StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
										break;

					case 254:	imgprocoutdlg.StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
										break;

					case 255:	imgprocoutdlg.StatusLabel -> setText( i18n( "Error: No CD in the Writer-Device !" ) );
										break;
				}
				QString statusout;
				statusout.sprintf( "Exit status: %d", rcproc->exitStatus() );
 				KMsgBox::message( this, i18n( "KOnCD - MSInfo" ), i18n( "An Error is occurred !\n" + statusout ), 4 );
				imgprocoutdlg.Button->setText( "&OK" );
				return;
			}
		//Create the Image
		slotMakeImage();
	}
}

//Abort-Handler
void MasterCD::abortHandler(){
	//Close dialog
	if ( imgprocoutdlg.isVisible() ) imgprocoutdlg.close();
	if ( procoutdlg.isVisible() ) procoutdlg.close();
}

//'Quit-Button' clicked
void MasterCD::slotExit(){
	close(true);
}
