/***************************************************************************
                          CopyCD.cpp  -  description
                             -------------------
    begin                : Fri Jan 14 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <qprogressdialog.h>
#include <kmsgbox.h>

#include "copycd.h"
#include "koncd.h"

CopyCD::CopyCD(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption( i18n( "KOnCD - Copy CD" ) );
	initDialog();
	setupConnections();
}

CopyCD::~CopyCD(){
}

// Setup Connections
void CopyCD::setupConnections(){
	connect( QPushButton_Start, SIGNAL(clicked()), SLOT(slotStart()) );
	connect( QPushButton_Abort, SIGNAL(clicked()), SLOT(slotAbort()) );
	connect( QPushButton_Exit, SIGNAL(clicked()), SLOT(slotExit()) );

	//Check for RW-Device
	KConfig *config = kapp->getConfig();
	config->setGroup( "CD-Writer" );
	if ( config->readEntry( "isRW" ) == "false" )
	{
	QComboBox_CDRWOptions->clear();	
	QComboBox_CDRWOptions->insertItem(i18n( "None RW !" ));
	QComboBox_CDRWOptions->setEnabled( false );
	}
}

// 'Start-Button' clicked
void CopyCD::slotStart(){
	int rc;

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot to aktivate the Start- / Quit-Buttons
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	WriteProgress -> setBarStyle( KProgress::Solid );
	StatusLabel -> setText( i18n("Prepare for write...") );
	QPushButton_Start->setEnabled( false );
	QPushButton_Exit->setEnabled( false );

	process.clearArguments();
	process << "cdrecord" << "-v";

	//Set the CD-Writer first
	KConfig *config = kapp->getConfig();
	config->setGroup("CD-Writer");
	process << config->readEntry("Device");

	//Set CD-Writer Options to KProcess
	if( QCheckBox_Simulate->isChecked() ) process << "-dummy";
	if( QCheckBox_ignoresize->isChecked() ) process << "-ignsize";
	if( QCheckBox_isosize->isChecked() ) process << "-isosize";
	if( QCheckBox_Eject->isChecked() ) process << "-eject";
	if( QCheckBox_nofix->isChecked() ) process << "-nofix";
	if( QCheckBox_Force->isChecked() ) process << "-force";

	//Set CD-RW Options to KProcess
	if( (rc = QComboBox_CDRWOptions -> currentItem()) )
		{
	   	if( rc == 1 ) process << "blank=all";
	   	if( rc == 2 ) process << "blank=fast";
	   	if( rc == 3 ) process << "blank=track";
	   	if( rc == 4 ) process << "blank=unclose";
	   	}

	//Set CD-Writer Speed to KProcess
	if( (rc = QComboBox_WriterSpeed -> currentItem()) )
		{
	   	if( rc == 0 ) process << "speed=1";
	   	if( rc == 1 ) process << "speed=2";
	   	if( rc == 2 ) process << "speed=4";
	   	if( rc == 3 ) process << "speed=6";
	   	if( rc == 4 ) process << "speed=8";
	   	}

	//Set the CD-Reader
	config->setGroup("CD-Reader");
	process << config->readEntry("Device");


	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( &process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMsgBox::message( this, i18n("KOnCD - Error"), i18n("Couldn't start cdrecord !"), 4 );			
		slotAbort();		
		}

}

//KProcess outout analysis
void CopyCD::slotRecStderr( KProcess *proc, char *buffer, int buflen) {
	char *c, buf[1024];
	int wrote, total, load;

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	Output->insertLine( buf );
	//Go to the End of the Output-Text
	Output->setCursorPosition(Output->numLines(),0,false);
	
	//Blanking a CD-RW
	if( strstr( buf, "Blanking" )) {
		StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	//Burn without Fixating
	if( strstr( buf, "Writing  time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
	}

	//Fixating the CD-R
	if( strstr( buf, "Fixating..." )) {
		StatusLabel -> setText( i18n("Writing TOC...") );
	}

	//	//Burn with Fixating
	if( strstr( buf, "Fixating time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}
	
	if( strstr( buf, "MB written" )) {
		c = index( buf, ':' );
		if( c && *c ) {
			c = strtok( c, ":\r\t " );
			if( c ) {
				wrote = atoi( c );
				c = strtok( NULL, "\r\t " );
				c = strtok( NULL, "\r\t " );
				if( c ) {
					total = atoi( c );
					c = strtok( NULL, "\r" );
					c = strstr( c, "fifo " );
					if( c ) {
						c = strtok( c + 5, "%\r\t " );
						if( c ) {
							load = atoi( c );
							WriteProgress -> setValue( total ? wrote * 100 / total : 0 );
	  						BufferProgress -> setBarColor( QColor( 220, 30, 30 ) );
							if( load > 40 )
  							BufferProgress -> setBarColor( QColor( 200, 200, 120 ) );
							if( load > 80 )
  							BufferProgress -> setBarColor( QColor( 40, 100, 60 ) );
							BufferProgress -> setValue( load );
							
							if( wrote ) {
								StatusLabel -> setText( i18n("Writing to CD...") );
							}
				
							if( ( total == wrote ) && ( QCheckBox_Simulate->isChecked() == false )) {
								StatusLabel -> setText( i18n("Writing TOC...") );
							}

						}
					}
				}
			}
		}		
	}	

}

// 'Abort-Button' clicked
void CopyCD::slotAbort(){
	StatusLabel -> setText( i18n("Breaking process...") );

	//If KProcess running, kill it ! Otherwise aktivate Start- / Quit-Button etc.
	if( process.isRunning() )
	{
		process.kill();
	}
	else
	{
	QPushButton_Start->setEnabled( true );
	QPushButton_Exit->setEnabled( true );
	Output->clear();
	StatusLabel -> setText( i18n("Ready for burning...") );
	WriteProgress -> setValue( 0 );
	BufferProgress -> setValue( 0 );
   	}

	QPushButton_Start->setEnabled( true );
	QPushButton_Exit->setEnabled( true );
	Output->clear();
	StatusLabel -> setText( i18n("Ready for burning...") );
	WriteProgress -> setValue( 0 );
	BufferProgress -> setValue( 0 );
}

//KProcess finished
void CopyCD::slotProcessExited(KProcess *rcproc) {
   int noperms = 13;		//Exitcode for no enough permissions
   int nocd = 123;		//Exitcode for no CD in the Reader-Device
	int nocdr = 255;		//Exitcode for no CD-R in the Writer-Device
	int corruptcd = 254;	//Exitcode for corrupt CD in Writer-Device

	//KProcess did not exit normally
	if( ! rcproc -> normalExit() )
		{
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
		KMsgBox::message( this, i18n( "KOnCD - Warning" ), i18n( "The Process was aborted !" ), 3 );		
		if( process.isRunning() ) process.kill();
		return;
		}

	//KProcess did exit normally, it does have a valid exit status
	if( rcproc -> exitStatus() )
		{
		QString statusout;
		statusout.sprintf( "\nError, exit status: %d\n", rcproc->exitStatus() );
		Output->insertLine( statusout );
		Output->setCursorPosition(Output->numLines(),0,false);
		StatusLabel -> setText( i18n( "An Error is occurred !" ) );
		if( rcproc->exitStatus() == nocd ) StatusLabel -> setText( i18n( "Error: No CD in the Reader-Device !" ) );
		if( rcproc->exitStatus() == nocdr ) StatusLabel -> setText( i18n( "Error: No CD-R(W) in the Writer-Device !" ) );
		if( rcproc->exitStatus() == corruptcd ) StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
		if( rcproc->exitStatus() == noperms ) StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
		}
	//KProcess did exit normally, normalExit() = true
	else
		{		
		QPushButton_Start->setEnabled( true );
		QPushButton_Exit->setEnabled( true );
	   	}
	//If KProcess already running, kill it
	if( process.isRunning() ) process.kill();
}

// 'Exit-Button' clicked
void CopyCD::slotExit(){
	close( true );
}
