#include "edit.h"
#include "menu.id"
#define _slotLog


extern int         debuglevel;
extern t_debugFile debugFile; 


Edit::Edit(int aDebuglevel)
{
  debuglevel = aDebuglevel;  
  debugFile.setDirName(getPersConfigDir() + "/", "kisocdDebug");

  if (debuglevel & 2 != 0) getSysInfo(getNrFile(getPersConfigDir(), "/kisocdDebug"));

  // Versionsmeldung
  cerr << "Version " << ProggieVersion << "\n";

  getGlobalConfDat(globalConf);
  
  // Das Men erstellen:
  createMenu();
  
  createStatusBar();

  // Das Fenster fllen:
  createMainView();
    
  DDDirektaufnahme = new KDNDDropZone(DatList, DndURL);

  /* ***************************************** */      
  NOTsaved    = false;
  ProjectOpen = false;
  aktVerz     = ""; 
  aktDateiName = "";
  
  HeimatPfad = getPersConfigDir(); 
  
  fMounted = false;
  brennGesamtStatus = 0;
  texFileWatch.flag = false;
  
  makeNewLatexFile(HeimatPfad, kapp->kde_htmldir());

  /* ***************************************** */    
  brennSub = new subprocessoutput(i18n("This window just shows you the output of the process currently using\n"
				       "your cdwriter. You can safely close it."));
  imageSub = new subprocessoutput(i18n("This window just shows you the output of a subprocess currently\n"
				       "running. You can safely close it."));
  myFileView = new simplekfvdialog();
  
  /* ***************************************** */    
  connect (menu,    SIGNAL (activated (int)), SLOT (commandCallback (int)));
  connect (file,    SIGNAL (aboutToShow()), SLOT (setupFileMenu()));
  connect (cdDoc,    SIGNAL (aboutToShow()), SLOT (setupCDDocMenu()));
  connect (burnSingleStep,    SIGNAL (aboutToShow()), SLOT (setupSStepMenu()));
  
  connect (ktlist, SIGNAL (currentChanged (QListViewItem*)), 
	   SLOT (changedDirCallback (QListViewItem*)));
  
  connect (DDDirektaufnahme, 
	   SIGNAL (dropAction(KDNDDropZone *)), 
	   SLOT (DDDirektCB(KDNDDropZone *)));

  connect(myFileView, SIGNAL(fileDrop(string)), SLOT(dropAktion(string)));
    
  /* ***************************************** */    
  checkPrerequisites();

  /* ***************************************** */    
  if (ladeVorgaben(globalConf, HeimatPfad, aktOpts, fileOpts)) 
    {
      defOpts = aktOpts;

      myQuickHelp = new quickstartdialog(this, "name", true);  
      myQuickHelp->show();

      if ((globalConf->readEntry("mOptions_system", "enabled") == "enabled") ||
	  globalConf->readEntry("mOptions", "enabled") == "enabled")
	{
	  opt_sys tmpDiag(this, "name", globalConf, &fileOpts, true);
	  tmpDiag.exec();      
	}

      opt_cd tmpDiag(this, "name", globalConf, &defOpts, &aktOpts, &NOTsaved);    
      tmpDiag.exec();
    }
  else 
    {
      defOpts = aktOpts;

      myQuickHelp = new quickstartdialog();  

      opt_cd tmpDiag(this, "name", globalConf, &defOpts, &aktOpts, &NOTsaved);    
      tmpDiag.exec();    
    }  

  cerr << "Edit::Init() done\n";
}

void Edit::closeEvent(QCloseEvent* e)
{
  if (endeFrage()) e->accept();
  else e->ignore();
}

int Edit::createMenu()
{
  /* ***************************************** */
  file = new QPopupMenu;
  
  if (globalConf->readEntry("mFile_new", "enabled") == "enabled") 
    file->insertItem(i18n("New"),                ID_FILE_NEW);
  if (globalConf->readEntry("mFile_open", "enabled") == "enabled") 
    file->insertItem(i18n("Open.."),             ID_FILE_OPEN);
  file->insertSeparator();
  if (globalConf->readEntry("mFile_save", "enabled") == "enabled") 
    file->insertItem(i18n("Save"),               ID_FILE_SAVE);
  if (globalConf->readEntry("mFile_saveAs", "enabled") == "enabled") 
    file->insertItem(i18n("Save as.."),          ID_FILE_SAVEAS);
  file->insertSeparator();
  if (globalConf->readEntry("mFile_BurnCD", "enabled") == "enabled") 
    file->insertItem(i18n("Burn CD"),          ID_FILE_BURNCD);  
  file->insertSeparator();
  file->insertItem(i18n("E&xit"),              ID_FILE_EXIT);  

  /* ***************************************** */
  burnSingleStep = new QPopupMenu;

  if (globalConf->readEntry("mSStep_simulateImageCreation", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Simulate image creation"), ID_SSTEP_TESTIMAGE);
  if (globalConf->readEntry("mSStep_createImage", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Create Image"),            ID_SSTEP_CREATEIMAGE);
  if (globalConf->readEntry("mSStep_mountViewImage", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Mount and View Image"),    ID_SSTEP_MOUNTVIEWIMAGE);
  if (globalConf->readEntry("mSStep_createScript", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Create ShellScript"),      ID_SSTEP_CREATESCRIPT);
  if (globalConf->readEntry("mSStep_burnIt", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Burn CD now!"),            ID_SSTEP_BURNIT);
  if (globalConf->readEntry("mSStep_delImage", "enabled") == "enabled") 
    burnSingleStep->insertItem(i18n("Delete Image"),            ID_SSTEP_DELIMAGE);

  /* ***************************************** */  
  help = new QPopupMenu;

  help->insertItem(i18n("Help"),     ID_HELP_HELP);
  help->insertItem(i18n("quick start"),     ID_HELP_QUICKSTART);
  help->insertSeparator();
  help->insertItem(i18n(AboutProggie), ID_HELP_ABOUT);  

  /* ***************************************** */  
  cdDoc = new QPopupMenu;

  if (globalConf->readEntry("mCDDoc_edit", "enabled") == "enabled") 
    cdDoc->insertItem(i18n("Edit"),    ID_CDDOC_EDIT);
  if (globalConf->readEntry("mCDDoc_compile", "enabled") == "enabled") 
    cdDoc->insertItem(i18n("Compile"), ID_CDDOC_COMPILE);
  if (globalConf->readEntry("mCDDoc_view", "enabled") == "enabled") 
    cdDoc->insertItem(i18n("View"),    ID_CDDOC_VIEW);
  if (globalConf->readEntry("mCDDoc_print", "enabled") == "enabled") 
    cdDoc->insertItem(i18n("Print"),   ID_CDDOC_PRINT);
  cdDoc->insertSeparator();
  if (globalConf->readEntry("mCDDoc_create", "enabled") == "enabled") 
    cdDoc->insertItem(i18n("Create from current view"), ID_CDDOC_CREATE);
  cdDoc->setItemEnabled(ID_CDDOC_CREATE, FALSE);
  
  /* ***************************************** */
  CDRW = new QPopupMenu;

  if (globalConf->readEntry("mCDRW_eraseAll", "enabled") == "enabled") 
    CDRW->insertItem(i18n("erase all"),          ID_CDRW_ERASEALL);
  if (globalConf->readEntry("mCDRW_eraseFast", "enabled") == "enabled") 
    CDRW->insertItem(i18n("fast erase"),         ID_CDRW_ERASEFAST);
  if (globalConf->readEntry("mCDRW_eraseLastSession", "enabled") == "enabled") 
    CDRW->insertItem(i18n("erase last session"), ID_CDRW_ERASELASTSESS);
  
  /* ***************************************** */
  m_options = new QPopupMenu;

  if (globalConf->readEntry("mOptions_system", "enabled") == "enabled") 
    m_options->insertItem(i18n("system"),         ID_OPTIONS_SYSTEM);
  if (globalConf->readEntry("mOptions_cd", "enabled") == "enabled") 
    m_options->insertItem(i18n("cd"),             ID_OPTIONS_CD);
  if (globalConf->readEntry("mOptions_cdDoc", "enabled") == "enabled") 
    m_options->insertItem(i18n("cdDoc"),          ID_OPTIONS_CDDOC);
  
  /* ***************************************** */
  m_view = new QPopupMenu;

  if (globalConf->readEntry("mView_sub1", "enabled") == "enabled") 
    m_view->insertItem(i18n("output of subprocess:cdwriter"),         ID_VIEW_SUBCD);
  if (globalConf->readEntry("mView_sub2", "enabled") == "enabled") 
    m_view->insertItem(i18n("output of subprocess:image"),         ID_VIEW_SUBIMAGE);
  m_view->insertSeparator();
  if (globalConf->readEntry("mView_simplefm", "enabled") == "enabled") 
    m_view->insertItem(i18n("simple filemanager"),         ID_VIEW_SIMPLEFM);
  if (globalConf->readEntry("mView_kfm", "enabled") == "enabled") 
    m_view->insertItem(i18n("kFileManager"),         ID_VIEW_KFM);
  m_view->setItemEnabled(ID_VIEW_SUBIMAGE, FALSE);
  m_view->setItemEnabled(ID_VIEW_SUBCD,    FALSE);

  /* ***************************************** */    
  m_virtcd = new QPopupMenu;

  m_virtcd->insertItem(i18n("Edit.."),          ID_VIRTCD_EDIT);
  m_virtcd->insertItem(i18n("New directory.."), ID_VIRTCD_ADDDIR);
  m_virtcd->setItemEnabled(ID_VIRTCD_EDIT,    FALSE);
  m_virtcd->setItemEnabled(ID_VIRTCD_ADDDIR,  TRUE);

  /* ***************************************** */    
  menu = new KMenuBar( this );
  CHECK_PTR( menu );

  menu->insertItem( i18n("&File"),    file );
  if (globalConf->readEntry("mSStep", "enabled") == "enabled")   
    menu->insertItem( i18n("&Single Step"), burnSingleStep);
  menu->insertItem( i18n("Virtual &CD"),    m_virtcd );  
  if (globalConf->readEntry("mCDDoc", "enabled") == "enabled")   
    menu->insertItem( i18n("cd&Doc"),   cdDoc );
  if (globalConf->readEntry("mOptions", "enabled") == "enabled") 
    menu->insertItem( i18n("&Options"), m_options );
  if (globalConf->readEntry("mCDRW", "enabled") == "enabled") 
    menu->insertItem( i18n("CDR&W"), CDRW );
  if (globalConf->readEntry("mView", "enabled") == "enabled") 
    menu->insertItem( i18n("&View"), m_view );
  menu->insertSeparator();
  menu->insertItem( i18n("&Help"),    help );
  
  menu->show();
  setMenu(menu);
  
  return(0);
}

int Edit::createStatusBar()
{
  statusBar = new KStatusBar(this);
  statusBar->insertItem(i18n("Welcome to KisoCD!"), 0);
  statusBar->insertItem("99999 MBytes", 1);
  VoelleGefuehl = new KProgress(0, 100, 0, KProgress::Horizontal, statusBar);
  statusBar->insertWidget((QWidget *)VoelleGefuehl, 300, 2);
  setStatusBar(statusBar);
  QToolTip::add(statusBar, i18n("statusbar: shows size of selected dir and subdirs, size of entire CD"));
  statusBar->changeItem("", 1);  
  return(0);
}

int Edit::createMainView()
{
  string tmp;
  Panner = new KNewPanner(this, 0, KNewPanner::Vertical, 
			   KNewPanner::Percent, 30);
  setView(Panner);
      
  // Die TreeList erzeugen:
  ktlist = new QListView(Panner, "CD-Vorschau Verzeichnisse");
  ktlist->addColumn(i18n("directories"));
  ktlist->setRootIsDecorated(true);
  QToolTip::add(ktlist, i18n("shows directory tree of your CD"));
  
  // die ListBox(Dateien im gewhlten Verzeichnis) erzeugen
  DatList = new QListView(Panner, "CD-Vorschau Dateien");  
  DatList->addColumn(i18n("files"));
  DatList->addColumn(i18n("size"));   
  DatList->addColumn(i18n("from"));  
  DatList->setColumnWidth(0, 187);
  DatList->setColumnWidth(1, 80);
  DatList->setColumnWidth(2, 147);
  QToolTip::add(DatList, i18n("shows files in the selected dir. Drop things here!"));

  Panner->activate(ktlist, DatList);

  return(0);
}

int Edit::saveToFile(const char* filename)
{
  ofstream   outDat;
  string     SrcPath,
             DstPath;  
  
  outDat.open(filename);
  if (!outDat)
    {
      fehlermeldung(i18n("Unable to open file for saving!\n"));
      cerr << filename << "\n";
      return(-1);
    }
  outDat << "# " << ProggieName << " " << ProggieVersion << "\n";
  outDat << "# Projectfile Type 3\n";
  for (int Cnt = 0; Cnt < 9; Cnt++) 
    {
      if (aktOpts.switches[Cnt]) outDat << " 1\n"; 
      else outDat << " 0\n"; 
    }
  
  outDat << aktOpts.IDdisc      << "\n";
  outDat << aktOpts.IDvolume    << "\n";
  outDat << aktOpts.IDpreparer  << "\n";
  outDat << aktOpts.IDpublisher << "\n";
  if (aktOpts.fCreateImage) outDat << " 1\n";
  else outDat << " 0\n";
  if (aktOpts.fDummyWrite) outDat << " 1\n"; 
  else outDat << " 0\n"; 
  if (aktOpts.fbootCD) outDat << " 1\n"; 
  else outDat << " 0\n"; 
  outDat << aktOpts.bootImagePath << "\n";
  if (aktOpts.fMulti) outDat << " 1\n"; 
  else outDat << " 0\n"; 
  if (aktOpts.fMultiFirstSess) outDat << " 1\n"; 
  else outDat << " 0\n"; 
  if (aktOpts.fMultiLastSess) outDat << " 1\n"; 
  else outDat << " 0\n"; 

  // new option at end
  if (aktOpts.fPadTrack) outDat << " 1\n"; 
  else outDat << " 0\n"; 

  outDat << "[\n";
  
  // Gibt es MeineCD an dieser Stelle schon ?
  
  if (ProjectOpen) 
    {  
      for (int Cnt = 0; Cnt < MeineCD->getExNum(); Cnt++) 
	{
	  MeineCD->getEx(Cnt, SrcPath);
	  outDat << SrcPath << "\n";
	}
    }
  outDat << "[\n";
  
  if (ProjectOpen)
    {
      for (int Cnt = 0; Cnt < MeineCD->getVerzNum(); Cnt++) 
	{
	  MeineCD->getVerz(Cnt, SrcPath, DstPath);
	  DstPath.replace(0, 3, "");
	  outDat << DstPath << "=" << SrcPath << "\n";
	}
    }
  outDat << "[\n";
  // das latex-File ans Ende kopieren
  {
    ifstream  latexFile;
    string    latexFilePfad = HeimatPfad;
    char      c;
    
    latexFilePfad += "/cdDoc.tex";
    latexFile.open(latexFilePfad.c_str());
    while ((c = latexFile.get()) != EOF) outDat << c;
    
    latexFile.close();
  }
  close_ofs(outDat);  
  
  NOTsaved = false;
  
  return(0);
}

int Edit::loadFromFile(const char* filename)
  // Die Nummerierung der sections in der Eingabedatei:
  //   0. Konfig-Daten
  //   1. Ausschlsse (Verzeichnis, Datei, Muster)
  //   2. einfache Zuordnungen (Zielverz=Quellverz, Zielverz=Quellverz+Datei) 
  //   3. die LaTeX-Datei
  // Trennzeichen zwischen den sections: ffnende eckige Klammer
{
  ifstream      inDat;
  ofstream      latexFile;
  string        latexFilePath;
  char          Zeile[500];
  int           section = 0;
  string        Zeile2;
  unsigned int  TrennPos = 0;
  bool          fileType1 = false;
  bool          fileType3 = false;
  
  latexFilePath = HeimatPfad + "/cdDoc.tex";
  latexFile.open(latexFilePath.c_str());
  if (!latexFile) 
    {
      fehlermeldung(i18n("Unable to create cdDoc.tex!\n"));
      return(-1);
    }
  
  inDat.open(filename);
  if (!inDat) 
    {
      fehlermeldung(i18n("Unable to open file!\n"));
      return(-1);
    }
   else 
     {
       // prfen, ob es die Datei einer alten Version ist;
       // wenn es so ist, mit der alten Methode einlesen, dabei
       // allerdings nur die Dinge einlesen, die auch nach dem 
       // neuen Dateityp Auswirkungen htten.
       inDat.getline(Zeile, 499);
       inDat.getline(Zeile, 499); 
       if (Zeile[1] == '0' || Zeile[1] == '1') 
	 {
	   fileType1 = true;
	   inDat.close();
	   inDat.open(filename);
	   infomeldung(i18n("Loading file in old format and saving in new one..."));
	 }
       else
         {
           if (Zeile[19] == '3')
             {
               fileType3 = true;
             }
         }
     }
  
  if (ProjectOpen) delete MeineCD;   
  
  MeineCD = new T_cdTree();

  // wenn es ein Project File vor Version 3 ist, ist die PadTrack-Option noch nicht vorhanden.
  // Damit sich das Programm dann wie gewohnt verhlt, wird PadTrack standardmssig abgeschaltet.
  aktOpts.fPadTrack = false;

  if (fileType1)
    {
      aktOpts.fMulti           = false;
      aktOpts.fMultiFirstSess  = false;
      aktOpts.fMultiLastSess   = false;

      while (!inDat.eof()) 
	{
	  inDat.getline(Zeile, 499);
	  if (Zeile[0] == '[') section++; 
	  else 
	    {
	      if ((strlen(Zeile) != 0) || (section == 3)) 
		{
		  switch (section) {
		  case 0:
		    if (TrennPos <= 8) aktOpts.switches[TrennPos] = (Zeile[1] == '1');	     
		    else 
		      {
			switch (TrennPos) {
			case  9: aktOpts.IDdisc        = Zeile;             break;
			case 10: aktOpts.IDvolume      = Zeile;             break;
			case 11: aktOpts.IDpreparer    = Zeile;             break;
			case 12: aktOpts.IDpublisher   = Zeile;             break;
			case 13: aktOpts.fCreateImage  = (Zeile[1] == '1'); break;
			case 14:                                            break;
			case 15:                                            break;
			case 16:                                            break;
			case 17: aktOpts.fDummyWrite   = (Zeile[1] == '1'); break;  
			case 18: aktOpts.fbootCD       = (Zeile[1] == '1'); break;
			case 19: aktOpts.bootImagePath = Zeile;             break;
			case 20: break; // hier steht nur die Versionsnummer
			}
		      }
		    TrennPos++;
		    break;
		  case 1:
		    Zeile2 = Zeile;
		    MeineCD->Exclude(Zeile2);
		    break;
		  case 2:
		    Zeile2 = Zeile;
		    TrennPos = Zeile2.find("=");
		    if (TrennPos != string::npos) 
		      {
			MeineCD->Append(Zeile2.substr(TrennPos+1, Zeile2.size()-TrennPos-1), 
					"/CD" + Zeile2.substr(0, TrennPos), 
					aktOpts.switches[0]);
		      }
		    break;
		  case 3:
		    latexFile << Zeile << "\n";
		    break;	  
		  }
		}
	    }
	}               
    }
  else
    {
      while (!inDat.eof()) 
	{
	  inDat.getline(Zeile, 499);
	  if (Zeile[0] == '[') section++; 
	  else 
	    {
	      if ((strlen(Zeile) != 0) || (section == 3)) 
		{
		  switch (section) {
		  case 0:
		    if (TrennPos <= 8) aktOpts.switches[TrennPos] = (Zeile[1] == '1');
		    else 
		      {
			switch (TrennPos) {
			case  9: aktOpts.IDdisc        = Zeile;             break;
			case 10: aktOpts.IDvolume      = Zeile;             break;
			case 11: aktOpts.IDpreparer    = Zeile;             break;
			case 12: aktOpts.IDpublisher   = Zeile;             break;
			case 13: aktOpts.fCreateImage  = (Zeile[1] == '1'); break;
			case 14: aktOpts.fDummyWrite   = (Zeile[1] == '1'); break;  
			case 15: aktOpts.fbootCD       = (Zeile[1] == '1'); break;
			case 16: aktOpts.bootImagePath = Zeile;             break;
			case 17: aktOpts.fMulti          = (Zeile[1] == '1'); break;
			case 18: aktOpts.fMultiFirstSess = (Zeile[1] == '1'); break;  
			case 19: aktOpts.fMultiLastSess  = (Zeile[1] == '1'); break;
                          /* file type == 3 */
			case 20: aktOpts.fPadTrack = (Zeile[1] == '1'); break;
			}
		      }
		    TrennPos++;
		    break;
		  case 1:
		    Zeile2 = Zeile;
		    MeineCD->Exclude(Zeile2);
		    break;
		  case 2:
		    Zeile2 = Zeile;
		    TrennPos = Zeile2.find("=");
		    if (TrennPos != string::npos) 
		      {
			MeineCD->Append(Zeile2.substr(TrennPos+1, Zeile2.size()-TrennPos-1), 
					"/CD" + Zeile2.substr(0, TrennPos), 
					aktOpts.switches[0]);
		      }
		    break;
		  case 3:
		    latexFile << Zeile << "\n";
		    break;	  
		  }
		}
	    }
	}    
    }
  inDat.close();
  close_ofs(latexFile);
  
  cout << "Datei eingelesen\n";
  cout.flush();
  // zweiter Teil: Zielbaum erzeugen lassen und anzeigen:
  MeineCD->calcSize();
  cout << "Ende calcSize\n";
  cout.flush();
  
  MeineCD->getCDVerzTree(ktlist, false);
  cout << "Ende getCDVerzTree\n";
  cout.flush();
  
  setzeVoelleGefuehl(MeineCD->getCDSize());
  clearLabels();
  DatList->clear();
  ProjectOpen = true;
  m_virtcd->setItemEnabled(ID_VIRTCD_EDIT, true);
  aktDateiName = filename;
    
  // new und save disablen
  NOTsaved = false;
  texFileWatch.flag = false;
  
  ktlist->setSelected(ktlist->firstChild(), true);
  ktlist->setOpen(ktlist->firstChild(), true);
    
  cout << "Ende LoadFromFile\n";
  cout.flush();
    
  // berprfen von fileOpts.imageFilePath
  if (fileOpts.imageFilePath[fileOpts.imageFilePath.size()-1] == '/')
    {
      fehlermeldung(i18n("Please give a valid path for the imagefile!\n"
		    "(options|more)\n"
		    "I corrected it to a default which possibly makes\n"
		    "no sense but will not cause strange errors. The point\n"
		    "is that you have to give a file, not a directory!"));  
      fileOpts.imageFilePath = "/usr/local/stupid_place.raw";
    }

  // Wenn es eine Datei der alten Version war, gleich unter dem 
  // neuen Format speichern:
  if (fileType1) saveToFile(filename);
  
  return(0);
}

Edit::~Edit()
{
  cerr << "Destructor called..\n";
  cerr.flush();
  
  if (fMounted) unmountImage(fMounted, fileOpts.mountPoint);
  
  // die Optionen speichern
  saveOptions(defOpts, fileOpts, HeimatPfad);

  // den Menkram lschen:  
  delete menu;
  delete file;
  delete help;
  delete CDRW;
  delete m_view;
  delete cdDoc;
  delete m_virtcd;
  
  // alles freigeben, was mit der Anzeige im Hauptfenster zu tun hat:
  
  delete VoelleGefuehl;
  delete ktlist;
  delete DatList;
  delete DDDirektaufnahme;
  
  delete Panner;
  if (ProjectOpen) delete MeineCD;
  cerr << "..bye!\n";
  cerr.flush();
  //  delete brennSub;
  //  delete imageSub;
  //  delete myFileView;
  //  delete myQuickHelp;
}

bool Edit::endeFrage()
{
  bool tmp = true;
  
  if (prozessAktiv())
    if (QMessageBox::warning(this, i18n("Running subprocesses"), 
			     i18n("There is at least one subprocess still running." 
				  "You will kill it if you exit now."),
			     i18n("Exit"), i18n("Cancel"), 
			     0, 1, 1)) tmp = false;
  if (tmp)
    if (NOTsaved) 
      if (QMessageBox::warning(this, i18n("Unsaved Changes"), 
			       i18n("You have unsaved changes, you will lose " 
				    "them if you exit now."),
			       i18n("Exit"), i18n("Cancel"), 
			       0, 1, 1)) tmp = false;
  return(tmp);
}

void Edit::commandCallback(int id_)
{
#ifdef slotLog
  cerr << "Slot: commandCallback, id_ = " << id_ << "\n";
  cerr.flush();
#endif
  KShellProcess*  process = NULL;
  bool processStarted = false;
  bool tmp = true;
  
  
  switch(id_) {
  case ID_FILE_EXIT:
    if (endeFrage()) delete(this);    
    break;
  case ID_FILE_OPEN: 
    if (NOTsaved) 
      if (QMessageBox::warning(this, i18n("Unsaved Changes"), 
			       i18n("You have unsaved changes, you will lose " 
			       "them if you open a file now."),
			       i18n("open file"), i18n("Cancel"), 
			       0, 1, 1)) tmp = false;     
    if (tmp) {    
      QString name= KFileDialog::getOpenFileName(HeimatPfad.c_str(), "*.cd");   
      if (!name.isEmpty()) 
	{ 
	  if (fMounted) unmountImage(fMounted, fileOpts.mountPoint);
	  if (loadFromFile((const char*)(name)) == 0)
	    {
	      string newCaption = ProggieName;
	      
	      aktVerz = "";
	      newCaption += ": " + aktDateiName;
	      setCaption((const char*)newCaption.c_str());
	    }
	}      
    }
    break;
  case ID_FILE_SAVEAS:{
    QString name1= KFileDialog::getSaveFileName(HeimatPfad.c_str(), "*.cd");
    if (!name1.isEmpty())       
      {	
	string name = (const char*)name1;
	
	if ((name.length() != 0) && (name[name.length()-1] != '/')) { 
	  string newCaption = ProggieName;
	  if (name.find(".cd") != name.length()-3) { name += ".cd"; }
	  saveToFile(name.c_str()); 
	  
	  aktDateiName = name;    
	  
	  newCaption += ": " + name;
	  setCaption((const char*)newCaption.c_str());
	}
	else fehlermeldung(i18n("You must give a filename!"));
      }
  } break;
  case ID_FILE_SAVE:
    saveToFile(aktDateiName.c_str());
    break;
  case ID_FILE_NEW:
    if (NOTsaved) 
      if (QMessageBox::warning(this, i18n("Unsaved Changes"), 
			       i18n("You have unsaved changes, you will lose " 
				    "them if you open a new project now."),
			       i18n("new project"), i18n("Cancel"), 
			       0, 1, 1)) tmp = false;         
    if (tmp) 
      {    
	if (fMounted) unmountImage(fMounted, fileOpts.mountPoint);
	
	ProjectOpen = false;
	m_virtcd->setItemEnabled(ID_VIRTCD_EDIT, false);
	NOTsaved    = false;
	texFileWatch.flag = false;
	// Optionen auf default-Werte setzen
	aktOpts = defOpts;
	// die Labels, listbox und treelist reinigen:
	setzeVoelleGefuehl(0);
	clearLabels();
	ktlist->clear();
	DatList->clear();           
	aktVerz = "";
	aktDateiName = "";
	// cd-objekt lschen
	delete MeineCD;     
	setCaption(ProggieName);      
	makeNewLatexFile(HeimatPfad, kapp->kde_htmldir());
      }
    break;
  case ID_FILE_BURNCD:
    if (prozessAktiv()) fehlermeldung(i18n("process already running!"));
    else
      {
	  debugFile.newFile();
	  burnCD_guided();
      }
    break;
  case ID_SSTEP_CREATEIMAGE:   
    if (imageSub->isRunning()) fehlermeldung(i18n("process already running!"));
    else
      { 
	  debugFile.newFile();
	  startCreateImage();
      }
    break;
  case ID_SSTEP_TESTIMAGE: 
    if (imageSub->isRunning()) fehlermeldung(i18n("process already running!"));
    else
      { 
	  debugFile.newFile();
	  startImageSim(0);
      }
    break;
  case ID_SSTEP_MOUNTVIEWIMAGE: 
    // Vorhandensein der Datei testen:
    if (!existDat(fileOpts.imageFilePath.c_str())) fehlermeldung(i18n("image does not exist!"));
    else
      { 
	  debugFile.newFile();
	  mountViewImage(fMounted, fileOpts);
      }
    break;
  case ID_SSTEP_DELIMAGE:
    if (unlink(fileOpts.imageFilePath.c_str()) != 0) 
      fehlermeldung(i18n("Error deleting image file:\n"
			 "  Does it exist?\n"
			 "  Do I have the permissions to delete it?\n"
			 "  Is the image mounted?"));
    break;
  case ID_SSTEP_CREATESCRIPT:
    createFinalScript(true);
    break;
  case ID_SSTEP_BURNIT:
    if (brennSub->isRunning())
      fehlermeldung(i18n("process already running!"));
    else
      { 
	  debugFile.newFile();
	  startBrennProzess();
      }
    break;
  case ID_HELP_HELP: 
    kapp->invokeHTMLHelp("kisocd/kisocd.html", "KisoCD"); 
    break;
  case ID_HELP_QUICKSTART: 
    myQuickHelp->gotoFirstChapter();
    myQuickHelp->show(); 
    break;
  case ID_HELP_ABOUT:{   
    string textStr;
    textStr = ProggieName;
    textStr += " v";
    textStr += ProggieVersion;
    textStr += "\n";
    textStr += AuthorDate;
    textStr += i18n("\n\n Please report bugs, tips, .... to the above address.");
    QMessageBox::about(0, AboutProggie, textStr.c_str());
  } break;
  case ID_CDDOC_EDIT: {
    string Befehl = HeimatPfad + "/cdDoc.tex";
    
    process = new KShellProcess;
    (*process) << fileOpts.editorCmd.c_str() << Befehl.c_str();
    process->start(KShellProcess::DontCare);
    processStarted = true;    
    NOTsaved    = true;
  } break;  
  case ID_CDDOC_COMPILE: 
    startLatexCompile(process, processStarted);
    break;  
  case ID_CDDOC_VIEW: {
    if (texFileWatch.flag == false || texFileWatch.hasChanged())
      startLatexCompile(process, processStarted, true);

    string Befehl = HeimatPfad + "/cdDoc.dvi";
    
    process = new KShellProcess;
    (*process) << fileOpts.viewCmd.c_str() << Befehl.c_str();
    process->start(KShellProcess::DontCare);
    processStarted = true;        
  } break;  
  case ID_CDDOC_PRINT: {
    if (texFileWatch.flag == false || texFileWatch.hasChanged())
      startLatexCompile(process, processStarted, true);

    string Befehl = "cdDoc.dvi";   
    chdir(HeimatPfad.c_str());
    
    process = new KShellProcess;
    (*process) << fileOpts.printCmd.c_str() << Befehl.c_str();
    process->start(KShellProcess::DontCare);
    processStarted = true;        
  } break;  
  case ID_CDDOC_CREATE:
    if (!QMessageBox::warning(this, i18n("sure?"), 
			      i18n("This will overwrite your old file!"),
			      i18n("OK"), i18n("Abort"), 
			      0, 1, 1)) {
      /* Neue Doku erzeugen, abhngig davon, welche ste im QListView offen sind */ 
      string Pfad = HeimatPfad + "/cdDoc.tex";
      string koverPfad = HeimatPfad;
      ofstream outDat;
      ofstream koverDat;
      
      
      if (NOTsaved) koverPfad += "/cdDoc.kover";
      else 
	{
	  string tmpStr = aktDateiName;
	  while (tmpStr.find("/") != string::npos) tmpStr.replace(0, 1, "");
	  tmpStr.replace(tmpStr.length()-2, 2, "kover");
	  koverPfad += "/" + tmpStr;
	}      
      
      koverDat.open(koverPfad.c_str());
      if (!koverDat)
	{
	  koverPfad = i18n("Could not write kover-file: ") + koverPfad;
	  fehlermeldung(koverPfad.c_str());
	}
      else 
	{
	  koverPfad = i18n("kover-file saved as\n") + koverPfad;    
	  QMessageBox::about(0, i18n("Info"), koverPfad.c_str());	
	  writeKoverFileHeader(koverDat);
	}
      
      outDat.open(Pfad.c_str());
      if (!outDat) {
	Pfad = i18n("Could not write tex-file ") + Pfad;
	fehlermeldung(Pfad.c_str());
      }
      else {
	QListViewItem *tmpItem;
	QListViewItem *tmpItem2;
	
	writeLatexFileHeader(outDat);	
	
	/* Jetzt den Baum abgrasen und das Zeugs schreiben...                      */
	/* mit firstChild einsteigen, dann mit firstChild/nextSibling weitermachen */
	/* Sichtbarkeit der Kinder mit isOpen() mit prfen                         */ 
	/* Anzahl der Kinder eines Items mit childCount() prfen                   */
	tmpItem = ktlist->firstChild();
	tmpItem = tmpItem->firstChild();
		
	/* ES MSSEN FR LATEX SONDERZEICHEN KONVERTIERT WERDEN!!!!!! */
	
	while (tmpItem != NULL) {
	  outDat <<  "          \\item[" << str2Latex(tmpItem->text(0)) << "]\n";	  	
	  koverDat << tmpItem->text(0) << ": ";
	  
	  if (tmpItem->isOpen()) {
	    // es hat Kinder und ist offen. Die Kinder einfach nur auflisten
	    tmpItem2 = tmpItem->firstChild();
	    while (tmpItem2 != NULL) {
	      outDat << "            " << str2Latex(tmpItem2->text(0)) << ";\n";	  	
	      koverDat << tmpItem2->text(0) << ", ";
	      tmpItem2 = tmpItem2->nextSibling();
	    }
	    koverDat << ">|<";
	  }
	  
	  tmpItem = tmpItem->nextSibling();
	}

	writeLatexFileFooter(outDat);
	close_ofs(outDat);
	
	writeKoverFileFooter(koverDat);
	close_ofs(koverDat);

	startLatexCompile(process, processStarted);
      }
    }
    break;
  case ID_OPTIONS_SYSTEM: {
    opt_sys tmpDiag(this, "name", globalConf, &fileOpts, !brennSub->isRunning());
    tmpDiag.exec();
  } break;
  case ID_OPTIONS_CDDOC:{
    opt_cddoc tmpDiag(this, "name", globalConf, &fileOpts);
    
    tmpDiag.exec();
  } break;
  case ID_OPTIONS_CD: {
    opt_cd tmpDiag(this, "name", globalConf, &defOpts, &aktOpts, &NOTsaved);
    
    tmpDiag.exec();
  } break;  
  case ID_CDRW_ERASEALL:
    debugFile.newFile();
    blankRW(id_, true);
    break;
  case ID_CDRW_ERASEFAST:
    debugFile.newFile();
    blankRW(id_, true);
    break;
  case ID_CDRW_ERASELASTSESS:
    debugFile.newFile();
    blankRW(id_, true);
    break;  
  case ID_VIEW_SUBIMAGE:
    imageSub->show();
    break;  
  case ID_VIEW_SUBCD:
    brennSub->show();
    break;  
  case ID_VIEW_SIMPLEFM:
    myFileView->show();
    break;  
  case ID_VIEW_KFM: 
    if (execKFM("/")) fehlermeldung("Error executing kfm!");
    break;  
  case ID_VIRTCD_EDIT:
    editwindowClick();
    break;  
  case ID_VIRTCD_ADDDIR:
    machNeuVerz();
    break;  
  }
  if (processStarted) delete process;
}

int Edit::getSessionData(long int      &ms1, 
			 long int      &ms2, 
			 string        &sessPfad)
{
  int      exitCode = 0;
  string   tmp; 
  string   tmpPfad;
  bool     infoFehler;
  
  infomeldung(i18n("Please insert the cd you want to add the session to into your cd-writer\n"
	      "and press OK when you're finished."));
  
  tmp = getDevID(fileOpts.writeDevice);
  tmp = "cdrecord -msinfo dev=" + tmp + " &> ";
  tmpPfad = getNrFile("/tmp/", "kisocd");
  tmp += tmpPfad;

  system(tmp.c_str());

  tmp = dateiInhalt(tmpPfad);
  
  unlink(tmpPfad.c_str());
  infoFehler = (tmp.find("cdrecord: No disk / Wrong disk") != string::npos ||
		tmp.find("cdrecord: No disc / Wrong disc") != string::npos ||
		tmp.find("cdrecord: Cannot read session offset") != string::npos ||
		tmp.find("cdrecord: Cannot read first writable address") != string::npos ||
		tmp.find("cdrecord: ") != string::npos);

  {
    // Die Werte herauslesen
    string tmpStr2;
    string tmpStr3 = tmp;
    
    while (isspace(tmpStr3[tmpStr3.length()-1])) tmpStr3.replace(tmpStr3.length()-1, 1, "");
    while (tmpStr3.find(" ") != string::npos) tmpStr3.replace(0, 1, "");

    tmpStr2 = tmpStr3.substr(0, tmpStr3.find(","));
    ms1 = atoi(tmpStr2.c_str());
    tmpStr3.replace(0, tmpStr3.find(",")+1, "");
    ms2 = atoi(tmpStr3.c_str());
  }

  if (infoFehler)
    {
      // MAYBE there was an error
      tmp += "\n-------------------------------------\n"
	"Decide if it was just a warning of if an error happened. If there are two numbers\n"
	"delimited by a \",\" at the end of the above output\n";
      tmp += "(I guess \"";
      tmp += itoStr(ms1, ' ', 1);
      tmp += ",";
      tmp += itoStr(ms2, ' ', 1);
      tmp += "\"), everything may be alright.";
      
      if (debuglevel & 1 != 0)
	{
	  debugFile.newSection("error on cdrecord -msinfo ?");
	  debugFile.output(tmp);
	}

      if (!QMessageBox::warning(this, i18n("Not everything was alright:"), 
				tmp.c_str(),
				i18n("Continue"), i18n("Cancel"), 
				0, 1, 1)) 
	infoFehler = false;
      else 
	exitCode = -1;
    }


  if (!infoFehler && !exitCode)
    {      
      // die CD mounten und ein Verzeichnis fr die nchste Session suchen
      // dazu muss das Image unmounted werden, was evtl. gerade gemounted ist!
      if (fMounted) 
	{
	  infomeldung(i18n("Please make sure no process uses the currently mounted image and\n"
		      "press OK."));
	  unmountImage(fMounted, fileOpts.mountPoint);
	}
      if (!fMounted)
	{
	  string tmpBef;
	  string tmpPfad;
	
	  exitCode = -1;  
	  tmpBef = "mount ";
	  tmpBef += fileOpts.writeDeviceSFile;
	  tmpBef += " ";
	  tmpBef += fileOpts.mountPoint;
	  tmpBef += " &> "; 
	  tmpPfad = getNrFile("/tmp/", "kisocd");
	  tmpBef += tmpPfad;
	  if (system(tmpBef.c_str()) != 0) 
	    {
	      string fehler = i18n("Error when mounting! I'll just show you mount's output:\n");
	      
	      fehler += dateiInhalt(tmpPfad);	 
	      fehlermeldung(fehler.c_str()); 
	    }
	  else 
	    {
	      fMounted = true;
	      exitCode = 0;
	    }
	  unlink(tmpPfad.c_str());
	  sessPfad = getNrPath(fileOpts.mountPoint + "/", "sess");
	  if (fMounted) unmountImage(fMounted, fileOpts.mountPoint);
	}
    }
  
  return(exitCode);
}

void Edit::changedDirCallback(QListViewItem* newItem)
{
#ifdef slotLog
  cerr << "Slot: changedDirCallback\n";
  cerr.flush();
#endif
  
  aktVerz = holPfadInhalt(newItem);
  MeineCD->Zeig(statusBar, DatList, ktlist, aktVerz);
}

void Edit::DDDirektCB(KDNDDropZone* _dropzone)
{
#ifdef slotLog
  cerr << "Slot: DDDirectCB\n";
  cerr.flush();
#endif
  
  string dropped;
  QString droppedQStr;
  
  droppedQStr = _dropzone->getData();
  KURL::decodeURL(droppedQStr);
  dropped = droppedQStr;
  dropAktion(dropped);
}

void Edit::dropAktion(string dropped)
{
  if (dropped.find("file:") == string::npos) 
    {
      fehlermeldung(i18n("You can only drop local files and dirs!\n"));
      if (dropped.find("http:") != string::npos || dropped.find("ftp:") != string::npos)
	downloadFile(dropped);
    }
  else 
    {
      string  rechteSeite;
      
      if (aktVerz == "") rechteSeite = "/CD/"; 
      else rechteSeite = aktVerz; 
      
      // testen, ob mehrere Elemente gedropped werden, die erfahren dann eine 
      // Spezialbehandlung
      if (dropped.find("\nfile:") != string::npos)
	{
	  // mehrere Elemente:
	  int choiceDND;
	  
	  if (globalConf->readEntry("oUI_simpleDND", "false") == "true") choiceDND = 0;
	  else 
	    {
	      QPopupMenu  *pm;
	      pm = new QPopupMenu;
	      pm->insertItem(i18n("just copy")); // 0
	      pm->insertItem(i18n("copy to new dir")); // 1
	      choiceDND = pm->exec(QCursor::pos());
	      delete pm;
	    }
	  
	  switch (choiceDND) {
	  case 1:
	    {
	      rechteSeite.replace(0, 3, "");
	      
	      neuVerzDiag tmpDiag(this, "name", 
				  "~#0123456789_-.abcdefghijklmnopqrstuvwxyz '()[]{}ABCDEFGHIJKLMNOPQRSTUVWXYZ/", 
				  i18n("Please give a directory under which the new files/dirs should appear on the cd, for example /user/pics/ or /files/."), 
				  rechteSeite);
	      rechteSeite = "/CD" + rechteSeite;
	      
	      string ziel;
	      
	      if (tmpDiag.exec() == QDialog::Accepted) 
		{
		  ziel = tmpDiag.tmpQLineEdit->text();
		  ziel = rmSlashes(ziel);
		  if (ziel == "") fehlermeldung(i18n("You gave an empty string!\n"));		
		  else 
		    {
		      if (ziel.length() > 0)
			if (ziel[ziel.size()-1] != '/') ziel += '/';		    
		      rechteSeite = "/CD/" + ziel;
		      cerr << "    " << rechteSeite << "\n";
		    }
		}
	      // neues Dir einlesen:
	      else break;
	      // ansonsten kein break, denn es muss ja noch ausgefhrt werden!
	    }
	  case 0:
	    // kein Dir zu setzen, es wird nach "rechteSeite" kopiert
	    // in einer Schleife alle Elemente einfgen:
	    // wenn unter den Elementen eins dabei ist, was nicht "file:" ist, 
	    // fllt das hier gar nicht auf! also auch keine Benachrichtigung darber...
	    // ist mir aber egal...
	    if (dropped.find("file:") == 0) dropped.replace(0, 5, "");
	    else dropped.replace(0, dropped.find("\nfile:")+6, "");
	    cout << dropped << "\n";
	    while (dropped.length() > 0) 
	      {
		string teilstring;
		string wohin;
		
		
		if (dropped.find("\n") == string::npos) teilstring = dropped;
		else teilstring = dropped.substr(0, dropped.find("\n"));
		
		wohin = rechteSeite;
		
		if (teilstring[teilstring.size()-1] == '/') 
		  {
		    string teilstring2 = teilstring;
		    
		    teilstring2.replace(teilstring2.size()-1, 1, "");
		    while (teilstring2.find("/") != string::npos)
		      {
			teilstring2.replace(0, 1, "");
		      }
		    wohin += teilstring2 + "/";
		  }
		
		cout << teilstring << "->" << wohin << "\n";
		
		addedDrop(teilstring, wohin);
		
		if (dropped.find("\nfile:") == string::npos) dropped = "";
		else dropped.replace(0, dropped.find("\nfile:")+6, "");
	      }
	    
	    
	    break;
	  default:
	    // gar nichts machen
	    break;
	  } 
	}
      else 
	{
	  // es wird nur ein Element gedropped:
	  int choiceDND;
	  
	  dropped.replace(0, 5, "");
	  
	  if (globalConf->readEntry("oUI_simpleDND", "false") == "true") 
	    {
	      if (dropped[dropped.size()-1] == '/') choiceDND = 2;
	      else choiceDND = 0;
	    }
	  else 
	    {
	      // Noch nachfragen, wie der Abwurf erfolgen soll:
	      QPopupMenu  *pm;
	      
	      pm = new QPopupMenu;
	      
	      if (dropped[dropped.size()-1] == '/') pm->insertItem(i18n("only the files"));   // 0
	      else pm->insertItem(i18n("only the file"));                                     // 0
	      if (dropped[dropped.size()-1] == '/') pm->insertItem(i18n("in new directory")); // 1
	      else pm->insertItem(i18n("in new directory/rename"));                           // 1
	      if (dropped[dropped.size()-1] == '/') pm->insertItem(i18n("with directory"));   // 2    
	      choiceDND = pm->exec(QCursor::pos());
	      delete pm;
	    }
	  
	  switch (choiceDND) {
	  case 0: 
	    addedDrop(dropped, rechteSeite);
	    break;
	  case 1:
	    {
	      string hilfeText;
	      if (dropped[dropped.size()-1] == '/') 
		hilfeText =  i18n("Please give a directory under which the new file(s) should appear on the cd, for example /user/pics/ or /files/.");	      
	      else 
		hilfeText = i18n("Please give a directory under which the new file should appear on the cd, for example /user/pics/ or /files/. If you don't close your input with a slash, the last item will be the new filename.");
	      
	      
	      rechteSeite.replace(0, 3, "");
	      
	      neuVerzDiag tmpDiag(this, "name", 
				  "~#0123456789_-.abcdefghijklmnopqrstuvwxyz '()[]{}ABCDEFGHIJKLMNOPQRSTUVWXYZ/", 
				  hilfeText.c_str(), 
				  rechteSeite);
	      
	      rechteSeite = "/CD" + rechteSeite;
	      string ziel;
	      
	      if (tmpDiag.exec() == QDialog::Accepted) 
		{
		  ziel = tmpDiag.tmpQLineEdit->text();
		  ziel = rmSlashes(ziel);
		  if (ziel == "") fehlermeldung(i18n("You gave an empty string!\n"));
		  else 
		    {
		      if (ziel.length() > 0)
			if ((ziel[ziel.size()-1] != '/') && 
			    (dropped[dropped.size()-1] == '/')) ziel += '/';		  
		      ziel = "/CD/" + ziel;
		      cerr << "    " << ziel << "\n";
		      addedDrop(dropped, ziel);
		    }
		}
	    }
	    break;
	  case 2:
	    {
	      string Ziel = dropped;
	      
	      Ziel.replace(Ziel.size()-1, 1, "");
	      while (Ziel.find("/") != string::npos) 
		Ziel.replace(0, 1, "");	      
	      Ziel = rechteSeite+Ziel+"/";
	      addedDrop(dropped, Ziel);
	    }
	    break;
	  
	  }
	}
    }
}

void Edit::addedDrop(string src, string dst)
  /*
    hier kommen z.B. solche Parameter an (/home/jens/download/ aus dem 
    System nach /download/ auf der CD):
    src: /home/jens/download/
    dst: /CD/download/
  */
{
  bool fFirstDrop = true;
    
  cout << "void Edit::addedDrop(string src, string dst);\n";
  cout << "  src: " << src << "\n";
  cout << "  dst: " << dst << "\n";
  
  if (ProjectOpen) fFirstDrop = (MeineCD->getVerzNum() == 0);
  
  if (!ProjectOpen) MeineCD = new T_cdTree();
  if (MeineCD->Append(src, dst, aktOpts.switches[0]) == 0) 
    {
      // zweiter Teil: Zielbaum erzeugen lassen und anzeigen:
      MeineCD->calcSize();
      MeineCD->getCDVerzTree(ktlist, ProjectOpen);
      setzeVoelleGefuehl(MeineCD->getCDSize());
      clearLabels();
      if (ProjectOpen) MeineCD->Zeig(statusBar, DatList, ktlist, aktVerz);
      else DatList->clear();
    
      // wenn dies der erste Drop war, sollte die Auswahl auf "CD" gesetzt werden, 
      // damit man gleich im rechten Fenster sieht, was im Root ist.
      if (fFirstDrop)
	{
	  ktlist->setSelected(ktlist->firstChild(), true);
	  ktlist->setOpen(ktlist->firstChild(), true);
	}
      ProjectOpen = true;
      m_virtcd->setItemEnabled(ID_VIRTCD_EDIT, true);
      NOTsaved    = true;
    }
}

void Edit::clearLabels()
{
  statusBar->changeItem("", 0);
  DatList->setColumnText(0, i18n("files"));
}

void Edit::setzeVoelleGefuehl(unsigned long WieVoll)
{
  unsigned int tmpVoll = WieVoll;
  
  // Was dazuaddieren, wenn "bootable cd" gewhlt ist:
  // Soll man die geschtzte Grsse eines Boot-Images dazuaddieren, 
  // wenn bootable gewhlt ist, aber das image nicht existiert?
  // Mache ich mal lieber nicht...
  if (aktOpts.fbootCD)
    {
      struct stat fAttr;
      
      tmpVoll += 2048; // fr boot.catalogue
      if (!stat(aktOpts.bootImagePath.c_str(), &fAttr)) tmpVoll += fAttr.st_size;      
    }
  
  statusBar->changeItem(getSizeText("", tmpVoll), 1);
  
  tmpVoll /= int(1024*1024*6.5); // hier steht 6.5 als Faktor fr eine Standard-650MB-CD!!!!
  
  if (tmpVoll > 100)
    {
      VoelleGefuehl->setBarColor(red);
      tmpVoll = 100;
      VoelleGefuehl->setTextEnabled(false);
    }
  else
    {
      VoelleGefuehl->setBarColor(green);
      VoelleGefuehl->setTextEnabled(true);
    }
  VoelleGefuehl->setValue(tmpVoll);
}

void Edit::editwindowClick()
{
#ifdef slotLog
  cerr << "Slot: editwindowClick\n";
  cerr.flush();
#endif
  
  if (ProjectOpen) 
    {
      cdEditData tmpDiag(this, "einName", MeineCD);
      
      tmpDiag.exec();
      // folgende Ausgabe bewirkte, dass es nach DialogBeendigung kein "segmentation fault" 
      // mehr gab!
      cerr << "Dialog beendet\n";
      cerr.flush();
      // Baum muss neu angezeigt werden, wenn was verndert wurde:
      if (tmpDiag.fEditiert)
	{
	  MeineCD->calcSize();
	  MeineCD->getCDVerzTree(ktlist, false);
	  setzeVoelleGefuehl(MeineCD->getCDSize());
	  clearLabels();
	  DatList->clear();
	  NOTsaved    = true;
	  // "CD" selektieren, ist einfach freundlicher fr den User
	  if (MeineCD->getVerzNum() != 0) ktlist->setSelected(ktlist->firstChild(), true);
	  // aktVerz muss gesetzt werden, damit das nchste hinzufgen nicht in die Hose
	  // geht:
	  if ((MeineCD->getVerzNum() == 0) || (ktlist->currentItem() == NULL)) {
	    aktVerz = "";
	    if (MeineCD->getVerzNum() == 0) setzeVoelleGefuehl(0);
	  }
	  else aktVerz = holPfadInhalt(ktlist->currentItem());	    
	  ktlist->setOpen(ktlist->firstChild(), true);
	}
    }
}

void Edit::writeMkisofsCommand(ofstream &outDat, 
			       bool     fImageFile,
			       bool     test,
			       string   bootDir,
			       long int ms1,
			       long int ms2)
{
  outDat << "mkisofs ";
  if (test)                outDat << "--print-size -q "; 
  if (aktOpts.switches[0] || needMirrorDir()) outDat << "-f ";
  if (aktOpts.switches[1]) outDat << "-L ";
  if (aktOpts.switches[2]) outDat << "-a ";
  if (aktOpts.switches[3]) outDat << "-l ";
  if (aktOpts.switches[4]) outDat << "-J ";
  if (aktOpts.switches[5]) outDat << "-T ";
  if (aktOpts.switches[6]) outDat << "-v ";
  if (aktOpts.switches[7]) outDat << "-r "; // flags werden gendert
  if (aktOpts.switches[8]) outDat << "-R ";
  
  if (aktOpts.fMulti && !aktOpts.fMultiFirstSess)
    if (fileOpts.writeDeviceSFile.length() != 0)
      outDat << "-C " << ms1 << "," << ms2 << " -M " << fileOpts.writeDeviceSFile << " ";
    else
      outDat << "-C " << ms1 << "," << ms2 << " -M " << getDevID(fileOpts.writeDevice) << " ";
  
  if (aktOpts.fbootCD)
    {
      // bootDir zurechtschneiden:
      while (bootDir.find("/") != string::npos) bootDir.replace(0, 1, "");
      
      outDat << "-b " << bootDir << "/boot.image ";
      outDat << "-c " << bootDir << "/boot.cat ";
    }
  
  outDat << "-A " << backslashifySpecial(aktOpts.IDdisc)      << " ";
  outDat << "-P " << backslashifySpecial(aktOpts.IDpublisher) << " ";
  outDat << "-p " << backslashifySpecial(aktOpts.IDpreparer)  << " ";
  outDat << "-V " << backslashifySpecial(aktOpts.IDvolume)    << " ";
  
  if (fImageFile) outDat << "-o " << backslashifySpecial(fileOpts.imageFilePath) << " ";
  
  string Pfad1, Pfad2;
    
  if (!needMirrorDir())
    {
      // Die Ausschlsse angeben:
      for (int Cnt = 0; Cnt < MeineCD->getExNum(); Cnt++) 
	{
	  MeineCD->getEx(Cnt, Pfad1);      
	  if (Pfad1[Pfad1.size()-1] == '/') 
	    {
	      outDat << "-x ";
	      Pfad1.replace(Pfad1.size()-1, 1, "");
	    }
	  else outDat << "-m ";	  
	  outDat << backslashifySpecial(Pfad1) << " ";
	}
    }
  
  if (aktOpts.fbootCD && !needMirrorDir())
    {
      MeineCD->getVerz(0, Pfad1, Pfad2);
      Pfad2.replace(0, 3, "");
      outDat << backslashifySpecial(Pfad1) << " ";
    }
  else   
    {
      if (needMirrorDir()) outDat << "$V ";		  	
      else      
	for (int Cnt = 0; Cnt < MeineCD->getVerzNum(); Cnt++) 
	  {
	    MeineCD->getVerz(Cnt, Pfad1, Pfad2);
	    if (Pfad1 != "dummydir")
	      {
		Pfad2.replace(0, 3, "");
		outDat << backslashifySpecial(Pfad2) << "=" 
		       << backslashifySpecial(Pfad1) << " ";
	      }
	  }
    }
}

void Edit::startLatexCompile(KShellProcess* &process, 
			     bool           &processStarted, 
			     bool           wait = false)
{
  ofstream compDat;                 
  string Befehl = HeimatPfad + "/compileScript.sh";    
  compDat.open(Befehl.c_str());
  compDat << "#! /bin/sh\n\n" << "cd " << HeimatPfad.c_str() << "\n" 
	  << fileOpts.latexCmd << " cdDoc.tex\necho \"\npress <return> to continue\"\nread\n";
  close_ofs(compDat);
  chmod(Befehl.c_str(), (S_IXGRP | S_IXOTH | S_IRWXU | S_IRGRP | S_IROTH));    
  process = new KShellProcess;
  (*process) << "xterm" << "-T" << "\"KisoCD: latex output\"" << "-e" << Befehl.c_str();
  if (wait) process->start(KShellProcess::Block);      
  else process->start(KShellProcess::DontCare);      
  processStarted = true;
  texFileWatch.lookNow(HeimatPfad + "/cdDoc.tex");
  texFileWatch.flag = true;
}

void Edit::startBrennProzess()
{
  bool rueckfrage;
  
  rueckfrage = preBurningBox();	
  
  if (rueckfrage) 
    {
      string pfad = HeimatPfad;
      
      pfad += "/cdScript.sh"; 
      if (createFinalScript(rueckfrage == 1, false) == 0)
	{
	  string infT;
	  if (aktOpts.fDummyWrite)
	    infT = i18n("This window just shows you the output of the process currently\n"
			"making the simulation write of the cd. You can safely close it.");
	  else
	    infT = i18n("This window just shows you the output of the process currently\n"
			"burning the cd. You can safely close it.");
	  
	  
	  startSubProc(brennSub, infT, ID_VIEW_SUBCD, pfad, 1, 1, 0);
	}
    }
}

void Edit::startImageSim(int bGS)
{
  long int ms1, ms2;
  int      exitCode = 0;
  string   sessPfad = "";  
  
  if (aktOpts.fMulti && !aktOpts.fMultiFirstSess)
    {
      exitCode = getSessionData(ms1, ms2, sessPfad);
      sessOffset = ms2;
    }
  else sessOffset = 0;
  string pfad = createImageScript(true, ms1, ms2, sessPfad);
  
  if (pfad != "" && exitCode == 0)
    startSubProc(imageSub,
		 i18n("This window just shows you the output of the subprocess\n"
		      "simulating the creation of the image. You can safely close it."),
		 ID_VIEW_SUBIMAGE, pfad, 2, 2, bGS);  
  else
    reenableMenuEntries();
}

int Edit::startCreateImage()
{
  long int ms1, ms2;
  int      exitCode = 0;
  string   sessPfad = "";  
  
  if (aktOpts.fMulti && !aktOpts.fMultiFirstSess) exitCode = getSessionData(ms1, ms2, sessPfad);
  
  string pfad = createImageScript(false, ms1, ms2, sessPfad);
  
  if (pfad != "" && exitCode == 0)
    {
      if (startSubProc(imageSub, i18n("This window just shows you the output of a the subprocess\n"
				   "creating the image. You can safely close it."),
		       ID_VIEW_SUBIMAGE, pfad, 1, 1, 0) == 1) exitCode = 1;
    }
  return(exitCode);
}

void Edit::machNeuVerz()
{
  string  startVerz;
  
  if (aktVerz == "") startVerz = "/"; 
  else 
    {
      startVerz = aktVerz; 
      startVerz.replace(0, 3, "");
    }
  
  neuVerzDiag tmpDiag(this, "name", 
		      "~#0123456789_-.abcdefghijklmnopqrstuvwxyz '()[]{}ABCDEFGHIJKLMNOPQRSTUVWXYZ/", 
		      i18n("Please give the path of the new directory!"), startVerz);
  string ziel;
  
  if (tmpDiag.exec() == QDialog::Accepted) 
    {
      ziel = tmpDiag.tmpQLineEdit->text();
      ziel = rmSlashes(ziel);
      if (ziel == "") fehlermeldung(i18n("We already have a root-directory!\n"));		
      else 
	{
	  if (ziel.length() > 0)
	    if (ziel[ziel.size()-1] != '/') ziel += '/';	  
	  ziel = "/CD/" + ziel;
	  cerr << "    " << ziel << "\n";
	  addedDrop("dummydir", ziel);
	}
    }
}

int Edit::bootableActions(ofstream &outDat, string &bootDir)
  // bootDir wird zurckgegeben, damit es nach Brennen/Imageerzeugung wieder gelscht
  // werden kann.
{
  // wenn mehrere Dateien/Pfade eingebunden sind oder nur einer, aber nicht
  // als root auf der CD, muss man dies ndern. In diesem Fall nicht null, sondern 1
  // zurckliefern.
  string Pfad1, Pfad2;
  int    retCode = 0;
  
  MeineCD->getVerz(0, Pfad1, Pfad2);
    
  if (needMirrorDir())
    {
      int nrCnt = 0;
      
      retCode = 1;
      
      do
	{
	  nrCnt++;
	  Pfad1 = "/CD/boot" + itoStr(nrCnt, '0', 3) + "/";
	}
      while (MeineCD->existDestDir(Pfad1) && (nrCnt < 1000));
      
      if (nrCnt == 1000) Pfad1 = "";
      else Pfad1 = "${V}/boot" + itoStr(nrCnt, '0', 3);
      bootDir = Pfad1;
    }
  else bootDir = getNrPath(Pfad1, "boot");
  
  // Befehle im Script, die das Verzeichnis anlegen und das Image reinkopieren.
  outDat << "# Anlegen des Boot-Verzeichnisses:\n";
  outDat << "if mkdir " << bootDir << ";\n";
  outDat << "then\n";
  outDat << "  echo \"KisoCD: created bootDir\";\n";
  outDat << "else\n";
  outDat << "  echo \"KisoCD: error creating bootDir\"\n";
  outDat << "  exit;\n";
  outDat << "fi\n\n";
  
  outDat << "if cp " << aktOpts.bootImagePath << " " << bootDir << "/boot.image;\n";
  outDat << "then\n";
  outDat << "  echo \"KisoCD: copied bootimage\";\n";
  outDat << "else\n";
  outDat << "  rmdir " << bootDir << "\n";
  outDat << "  echo \"KisoCD: error copying bootimage\"\n";
  outDat << "  exit;\n";
  outDat << "fi\n";
  outDat << "# Anlegen des Boot-Verzeichnisses beendet.\n\n";  
  
  return(retCode);
}

string Edit::createImageScript(bool     test,
			       long int ms1,
			       long int ms2, 
			       string   sessPfad)
{
  string bootDir;
  string scriptPfad = HeimatPfad; 
  scriptPfad += "/cdScript.sh";
  
  ofstream outDat;
  
  outDat.open(scriptPfad.c_str());
  if (!outDat) 
    { 
      fehlermeldung(i18n("Could not create file!\n")); 
      return("");
    }
  else 
    {
      outDat << "#! /bin/sh\n\n";
      outDat << "# " << ProggieName << " " << ProggieVersion << "\n";
      if (!test) outDat << "rm -f " << backslashifySpecial(fileOpts.imageFilePath) << "\n";
      
      if (needMirrorDir()) 
	{
	  string linkFile;
	  createMirrDir(outDat, sessPfad, fileOpts, linkFile, HeimatPfad);
	  MeineCD->erstellListe(linkFile);
	}
      // Besondere Infos und Massnahmen, wenn bootable gewhlt ist:
      if (aktOpts.fbootCD) bootableActions(outDat, bootDir);
      // image erzeugen
      writeMkisofsCommand(outDat, true, test, bootDir, ms1, ms2);
      outDat << "\n";
      
      if (aktOpts.fbootCD) 
	{
	  // das Boot-Zeug wieder lschen
	  outDat << "rm -f " << bootDir << "/boot.image\n";
	  outDat << "rm -f " << bootDir << "/boot.cat\n";
	  outDat << "rmdir " << bootDir << "\n";
	}
      if (needMirrorDir()) deleteMirrDir(outDat);
      // fertig
      close_ofs(outDat);
      chmod(scriptPfad.c_str(), (S_IXGRP | S_IXOTH | S_IRWXU | S_IRGRP | S_IROTH));
      return(scriptPfad);    
    }
}

int Edit::createFinalScript(bool allowShutdown,
			    bool delImage = false)
{
  string scriptPfad = HeimatPfad;
  scriptPfad += "/cdScript.sh";  
  ofstream outDat;
  
  outDat.open(scriptPfad.c_str());
  if (!outDat) 
    { 
      fehlermeldung(i18n("Could not create file!\n")); 
      return(-1);
    }
  else 
    {
      outDat << "#! /bin/sh\n\n";
      outDat << "# " << ProggieName << " " << ProggieVersion << "\n";
      
      if (aktOpts.fCreateImage) 
	{
	  // das Image sollte schon vorhanden sein, es muss nur noch gebrannt werden
	  writeCdrecordCmd(outDat, aktOpts, fileOpts);

	  if (delImage) outDat << "rm " << backslashifySpecial(fileOpts.imageFilePath) << "\n";
	}
      else 
	{
	  if (needMirrorDir()) 
	    {
	      string linkFile;
	      createMirrDir(outDat, "", fileOpts, linkFile, HeimatPfad);
	      MeineCD->erstellListe(linkFile);
	    }
	  
	  // Besondere Infos und Massnahmen, wenn bootable gewhlt ist:
	  string bootDir;
	  
	  if (aktOpts.fbootCD) bootableActions(outDat, bootDir);
	  // image erzeugen und durch eine pipe zu cdrecord schicken
	  writeMkisofsCommand(outDat, false, false, bootDir, 0, 0);      
	  outDat << "| ";

	  writeCdrecordCmd(outDat, aktOpts, fileOpts);
	  
	  if (aktOpts.fbootCD) 
	    {
	      // das Boot-Zeug wieder lschen
	      outDat << "rm -f " << bootDir << "/boot.image\n";
	      outDat << "rm -f " << bootDir << "/boot.cat\n";
	      outDat << "rmdir " << bootDir << "\n";
	    }
	  if (needMirrorDir()) deleteMirrDir(outDat);
	  if (allowShutdown && fileOpts.fShutdown) outDat << "shutdown -h now\n";
	}
      
      close_ofs(outDat);
      chmod(scriptPfad.c_str(), (S_IXGRP | S_IXOTH | S_IRWXU | S_IRGRP | S_IROTH));
    }  
  
  return(0);
}

void Edit::burnCD_guided(int someVar = 0)
{
  if (debuglevel & 1 != 0)
    {
	debugFile.output("just entered void Edit::burnCD_guided(" 
			 + itoStr(someVar, ' ', 1) + ")");
	debugFile.output("  brennGesamtStatus = " + itoStr(brennGesamtStatus, ' ', 1));
    }

  switch (brennGesamtStatus) {
  case 0:
    // Viele Menpunkte disablen, whrend dieser Gesamtvorgang luft
    disableMenuEntries();
    startImageSim(1);
    break;
  case 1:
    {
      subprocessoutput *zwischenergebnis;
      
      zwischenergebnis = 
	new subprocessoutput(i18n("Hit 'Continue' if everything looks alright and you want to\n"
				  "go on burning the CD. Especially check if the contents will\n"
				  "fit on your CD."), 
			     this, "noname", true, (someVar == 0));
      for (unsigned int cnt = 0; cnt < imageSub->QListBox_1->count(); cnt++)
	zwischenergebnis->QListBox_1->insertItem(imageSub->QListBox_1->text(cnt));	  
      zwischenergebnis->QListBox_1->setBottomItem(zwischenergebnis->QListBox_1->count()-1);
      
      imageSub->hide();
      
      if (zwischenergebnis->exec() == 1)
	{
	  // weiter im Text!
	  if (aktOpts.fCreateImage) 
	    // image erstellen:
	    {
	      if (startCreateImage() == 0) brennGesamtStatus = 2;
	      else
		{
		  reenableMenuEntries();
		  brennGesamtStatus = 0;
		  unlink(fileOpts.imageFilePath.c_str());
		}
	    }
	  else
	    // on-the-fly brennen:
	    {
	      startBrennProzess();
	      brennGesamtStatus = 0;
	      reenableMenuEntries();
	    }
	}
      else 
	{
	  reenableMenuEntries();
	  brennGesamtStatus = 0;
	}
      
      delete zwischenergebnis;
    }
    break;
  case 2:
    {
      subprocessoutput *zwischenergebnis;
      
      zwischenergebnis = 
	new subprocessoutput(i18n("Hit 'Continue' if everything looks alright and you want to\n"
				  "go on burning the CD."), 
			     this, "noname", true, false);
      for (unsigned int cnt = 0; cnt < imageSub->QListBox_1->count(); cnt++)
	zwischenergebnis->QListBox_1->insertItem(imageSub->QListBox_1->text(cnt));	  
      zwischenergebnis->QListBox_1->setBottomItem(zwischenergebnis->QListBox_1->count()-1);

      imageSub->hide();
      
      if (zwischenergebnis->exec() == 1) startBrennProzess();
      else unlink(fileOpts.imageFilePath.c_str());		  
      brennGesamtStatus = 0;
      
      reenableMenuEntries();
      
      delete zwischenergebnis;	      
    }
    break;
  }
}

void Edit::untersucheMkisofsAusgabe(KProcess *proc)
{
  unsigned long    size = 0;
  string           Ausgabe;
  
  disconnect(proc);
  
  Ausgabe = imageSub->getLatestLineWith("Total extents scheduled to be written = ", 0);
  if (Ausgabe.length() != 0)
    {
      Ausgabe.replace(0, 39, "");
      size = atoi(Ausgabe.c_str());
    }

  imageSub->QListBox_1->insertItem("#########################################################");
  if (size == 0) 
    {
      imageSub->QListBox_1->insertItem(i18n("Is your filesystem empty or"));
      imageSub->QListBox_1->insertItem(i18n("am I not able to read mkisofs' output?")); 
    }
  else 
    {
      
      imageSub->QListBox_1->insertItem(i18n("According to mkisofs, your CD will contain"));
      Ausgabe = getSizeText("", (size+sessOffset)*2048);
      imageSub->QListBox_1->insertItem(Ausgabe.c_str());
      if (aktOpts.fMulti && !aktOpts.fMultiFirstSess)
	{
	  imageSub->QListBox_1->insertItem(i18n("The size of the current session is"));
	  Ausgabe = getSizeText("", size*2048);
	  imageSub->QListBox_1->insertItem(Ausgabe.c_str());
	}
      imageSub->QListBox_1->insertItem(i18n("Check the difference to what KisoCD told you!"));
    }
  
  imageSub->QListBox_1->insertItem("#########################################################");
  imageSub->QListBox_1->setBottomItem(imageSub->QListBox_1->count()-1);

  if (debuglevel & 1 != 0) 
    {
      debugFile.newSection("imagecreation/simulation");
      for (unsigned int cnt = 0; cnt < imageSub->QListBox_1->count(); cnt++)
	  debugFile.output(imageSub->QListBox_1->text(cnt));	  
    }
  
  imageSub->show();
  imageSub->QLabel_1->setText(i18n("Simulation finished.\nPlease take a look at the last lines..."));
  delete proc; 
  imageSub->proc = NULL;	

  /************************************/
  
  if (brennGesamtStatus != 0) burnCD_guided(size);
}

void Edit::prozessEnde(KProcess *proc)
{
  int aktion = 0;
  
  if (proc == brennSub->proc || proc == imageSub->proc)
    {
      disconnect(proc);
      
      if (proc == brennSub->proc) 
	{
          if (debuglevel & 1 != 0) 
	    {
	      debugFile.newSection("process which used the burner");
	      for (unsigned int cnt = 0; cnt < brennSub->QListBox_1->count(); cnt++)
		debugFile.output(brennSub->QListBox_1->text(cnt));	  
	    }
      
	  if (brennSub->ID < 2)
	    {
	      // es war ein normaler Brennprozess
	      brennSub->show();
	      brennSub->QLabel_1->setText(i18n("Subprocess has terminated."));
	      if (brennSub->containsString("cdrecord: No disk / Wrong disk!")
		  || brennSub->containsString("cdrecord: No disc / Wrong disc!"))
		fehlermeldung(i18n("There is no disc/a wrong disc!\n"));
	      else 		
		infomeldung(i18n("Burning of the CD is finished.\n"
				 "Please take a look at the output."));
	    }
	  else
	    {
	      // es war ein RW-blank
	      // ich muss schauen, ob cdrecord den "-force"-Parameter angenommen hat.
	      if (brennSub->containsString("cdrecord: Bad Option: -force.")) aktion = brennSub->ID;
	      else 
		{
		  brennSub->show();
		  brennSub->QLabel_1->setText(i18n("Subprocess has terminated."));
		  if (brennSub->containsString("cdrecord: No disk / Wrong disk!")
		      || brennSub->containsString("cdrecord: No disc / Wrong disc!"))
		    fehlermeldung(i18n("There is no disc/a wrong disc!\n"));
		  else 
		    infomeldung(i18n("Blanking the CDRW is finished.\n"
				     "Please take a look at the output."));
		}
	    }
	}
      else 
	{
          if (debuglevel & 1 != 0) 
	    {
	      debugFile.newSection("imagecreation/simulation");
	      for (unsigned int cnt = 0; cnt < imageSub->QListBox_1->count(); cnt++)
		debugFile.output(imageSub->QListBox_1->text(cnt));	  
	    }
      
	  imageSub->show();
	  imageSub->QLabel_1->setText(i18n("Subprocess has terminated."));
	  if (brennGesamtStatus == 0) infomeldung(i18n("Finished creation of the imagefile\n"
						  "or its simulation.\n"
						  "Please take a look at the output."));
	  if (imageSub->ID == 1 && fMounted)
	    {
	      // das Image remounten:
	      infomeldung(i18n("As your image has now been changed, it makes sense to remount it.\n"
			  "Please make sure no process uses the currently mounted image and\n"
			  "press OK."));

	      unmountImage(fMounted, fileOpts.mountPoint);
	      mountViewImage(fMounted, fileOpts);
	    }

	  /***************************/

	  if (brennGesamtStatus != 0) burnCD_guided();
	}      
      delete proc;
      if (proc == brennSub->proc) brennSub->proc = NULL;
      else imageSub->proc = NULL;	
    }
  else 
    {
      cout << "void Edit::prozessEnde(KProcess *proc) ohne gltigen Parameter\n";
      cout.flush();
    }
  
  // Das erneute Starten des CDRW-blank, wenn cdrecord den "-force"-Parameter nicht kannte:
  switch (aktion)
    {
    case 2: blankRW(ID_CDRW_ERASEALL, false);
      break;
    case 3: blankRW(ID_CDRW_ERASEFAST, false);
      break;       
    case 4: blankRW(ID_CDRW_ERASELASTSESS, false);
      break;
    }  
}

void Edit::blankRW(int blankType, bool force)
{
  if (brennSub->isRunning())
    fehlermeldung(i18n("process already running!"));
  else 
    {	    
      string    pfad = HeimatPfad;
      ofstream  outDat;
      
      pfad += "/cdScript.sh"; 
      outDat.open(pfad.c_str());
      if (!outDat) fehlermeldung(i18n("Unable to create scriptfile!"));
      else 
	{
	  int anID = 0;
	  
	  outDat << "#! /bin/sh\n\n";
	  outDat << "# " << ProggieName << " " << ProggieVersion << "\n";
	  string device = getDevID(fileOpts.writeDevice);
	  
	  outDat << "cdrecord -v ";
	  if (force) outDat << "-force ";
	  outDat << "speed=" << fileOpts.nBlankingSpeed << " ";
	  outDat << "blank=";
	  switch (blankType)
	    {
	    case ID_CDRW_ERASEALL: 
	      outDat << "all";
	      anID = 2;
	      break;
	    case ID_CDRW_ERASEFAST: 
	      outDat << "fast";
	      anID = 3;
	      break;
	    case ID_CDRW_ERASELASTSESS: 
	      outDat << "session";
	      anID = 4;
	      break;
	    }
	  
	  outDat << " dev=" << device 
		 << "\n";
	  	  
	  close_ofs(outDat);
	  chmod(pfad.c_str(), (S_IXGRP | S_IXOTH | S_IRWXU | S_IRGRP | S_IROTH));

	  if (debuglevel & 1 != 0) debugFile.newFile();		  
  	  startSubProc(brennSub, i18n("This window just shows you the output of the process currently blanking\n"
				   "your CD. You can safely close it."),
		       ID_VIEW_SUBCD, pfad, 1, anID, 0);
	}
    }  
}

bool Edit::prozessAktiv()
{
  return(imageSub->isRunning() || brennSub->isRunning());
}

void Edit::setupFileMenu()
{
  bool tmp = false;
  
  if (aktDateiName != "") file->setItemEnabled(ID_FILE_SAVE, NOTsaved);
  else file->setItemEnabled(ID_FILE_SAVE, false);
  if (ProjectOpen) file->setItemEnabled(ID_FILE_NEW, (MeineCD->getVerzNum() != 0));
  else file->setItemEnabled(ID_FILE_NEW, false);
  file->setItemEnabled(ID_FILE_SAVEAS, true);

  if (ProjectOpen) tmp = (MeineCD->getVerzNum() != 0); 
  file->setItemEnabled(ID_FILE_BURNCD, tmp);

  if (brennGesamtStatus != 0)
    {
      file->setItemEnabled(ID_FILE_NEW, false);
      file->setItemEnabled(ID_FILE_OPEN, false);
      file->setItemEnabled(ID_FILE_BURNCD, false);
    }
}

void Edit::setupCDDocMenu()
{
  bool tmp = false;
  
  if (ProjectOpen) { tmp = (MeineCD->getVerzNum() != 0); }
  
  cdDoc->setItemEnabled(ID_CDDOC_CREATE,     tmp);
}

void Edit::setupSStepMenu()
{
  bool tmp = false;
  
  if (ProjectOpen) { tmp = (MeineCD->getVerzNum() != 0); }
  
  burnSingleStep->setItemEnabled(ID_SSTEP_TESTIMAGE,    tmp);
  burnSingleStep->setItemEnabled(ID_SSTEP_CREATEIMAGE,  (tmp && aktOpts.fCreateImage));
  burnSingleStep->setItemEnabled(ID_SSTEP_CREATESCRIPT, tmp);
  burnSingleStep->setItemEnabled(ID_SSTEP_BURNIT,       tmp);

  if (aktOpts.fCreateImage)
    {
      tmp = existDat(fileOpts.imageFilePath);
      if (imageSub->isRunning()) tmp = false;

      burnSingleStep->setItemEnabled(ID_SSTEP_CREATESCRIPT,   tmp);	  
      burnSingleStep->setItemEnabled(ID_SSTEP_BURNIT,         tmp);	  
      burnSingleStep->setItemEnabled(ID_SSTEP_DELIMAGE,       tmp);

      if (aktOpts.fMulti && !aktOpts.fMultiFirstSess) tmp = false;
      burnSingleStep->setItemEnabled(ID_SSTEP_MOUNTVIEWIMAGE, tmp);
    }
  else 
    {
      burnSingleStep->setItemEnabled(ID_SSTEP_MOUNTVIEWIMAGE, false);
      burnSingleStep->setItemEnabled(ID_SSTEP_DELIMAGE,       false);
    }

  if (brennSub->isRunning()) burnSingleStep->setItemEnabled(ID_SSTEP_BURNIT,       false);
  if (brennSub->isRunning() && aktOpts.fMulti)
    {
      burnSingleStep->setItemEnabled(ID_SSTEP_TESTIMAGE,    false);
      burnSingleStep->setItemEnabled(ID_SSTEP_CREATEIMAGE,  false);
    }

  if (brennGesamtStatus != 0)
    {
      burnSingleStep->setItemEnabled(ID_SSTEP_TESTIMAGE, false);
      burnSingleStep->setItemEnabled(ID_SSTEP_CREATEIMAGE, false);
      burnSingleStep->setItemEnabled(ID_SSTEP_CREATESCRIPT, false);
      burnSingleStep->setItemEnabled(ID_SSTEP_BURNIT, false);
      burnSingleStep->setItemEnabled(ID_SSTEP_DELIMAGE, false);
    }
}

bool Edit::needMirrorDir()
{
  bool    tmp = false;
  string  Pfad1, Pfad2;
  
  MeineCD->getVerz(0, Pfad1, Pfad2);
  if (aktOpts.fbootCD && 
      ((MeineCD->getVerzNum() != 1) || ((MeineCD->getVerzNum() == 1) && (Pfad2 != "/CD/"))))
    tmp = true;
    
  // folgendes muss noch verfeinert werden: nur wenn die Verzeichnisstruktur nicht 
  // das gewnscht Aussehen hat, muss die Sache angewandt werden....
  if (aktOpts.fMulti && !aktOpts.fMultiFirstSess) tmp = true;
  
  return(tmp);
}

void Edit::disableMenuEntries()
{
  m_options->setItemEnabled(ID_OPTIONS_CD, false);
  m_options->setItemEnabled(ID_OPTIONS_SYSTEM, false);

  CDRW->setItemEnabled(ID_CDRW_ERASEALL, false);
  CDRW->setItemEnabled(ID_CDRW_ERASEFAST, false);
  CDRW->setItemEnabled(ID_CDRW_ERASELASTSESS, false);

  m_virtcd->setItemEnabled(ID_VIRTCD_EDIT, false);
  m_virtcd->setItemEnabled(ID_VIRTCD_ADDDIR, false);
}

void Edit::reenableMenuEntries()
{
  file->setItemEnabled(ID_FILE_OPEN, true);

  m_options->setItemEnabled(ID_OPTIONS_CD, true);
  m_options->setItemEnabled(ID_OPTIONS_SYSTEM, true);

  CDRW->setItemEnabled(ID_CDRW_ERASEALL, true);
  CDRW->setItemEnabled(ID_CDRW_ERASEFAST, true);
  CDRW->setItemEnabled(ID_CDRW_ERASELASTSESS, true);

  m_virtcd->setItemEnabled(ID_VIRTCD_EDIT, true);
  m_virtcd->setItemEnabled(ID_VIRTCD_ADDDIR, true);
}

int Edit::startSubProc(subprocessoutput*   &subProc, 
		       string   shortInfoText, 
		       int      menuID, 
		       string   pfad, 
		       int      pType, 
		       int      ID, 
		       int      bGS)
{
  int exitCode = 0;

  subProc->newProc(shortInfoText, pfad);
  
  if (pType == 2) connect(subProc->proc, SIGNAL (processExited(KProcess *)), 
			  SLOT(untersucheMkisofsAusgabe(KProcess *)));
  else connect(subProc->proc, SIGNAL (processExited(KProcess *)), 
	       SLOT(prozessEnde(KProcess *)));

  if (!subProc->proc->start(KProcess::NotifyOnExit, KProcess::AllOutput))
    {
      fehlermeldung(i18n("error when starting subprocess!"));
      exitCode = 1;
    }
  else 
    {
      brennGesamtStatus = bGS;
      cout << "prozess gestartet\n";
      subProc->ID = ID;
      subProc->show();
      m_view->setItemEnabled(menuID, TRUE);
    }	

  if (debuglevel & 1 != 0) 
    {
      debugFile.newSection("Start of subprocess");
      debugFile.appendFile(pfad);
    }

  return(exitCode);
}

#include "edit_ext.cpp"

#include "edit.moc"














