#ifndef _MOUNTPROT_H_
#define _MOUNTPROT_H_

#include "fileprot.h"
#include <qstring.h>

class MountProtocol : public FileProtocol
{
public:
	MountProtocol(const char *device, const char *mpoint = 0, const char *fstype = 0);
	virtual ~MountProtocol();

	bool mount();
	bool umount();
	bool finish();
	bool isMountable() { return Mountable;}
	bool isMounted();
	const char* mountp() { return MountPoint.data();}

protected:
	bool getMountPoint();		// get default mount point

protected:
	QString		Device;
	QString		FSType;
	QString		MountPoint;
	bool		Mountable;	// False if error in configuration of device

};

inline MountProtocol::~MountProtocol()
{ finish();}

#endif
