#include "OptionsDetail.h"
#include <kapp.h>
#include <qlabel.h>
#include <qmessagebox.h>

OptionsDetail::OptionsDetail(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	ListView = new QListView(this);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Type"));
	ListView->addColumn(i18n("Width"));
	ListView->setGeometry(20,20,200,100);
	ListView->setSorting(-1);
	ListView->setAllColumnsShowFocus(TRUE);
	connect(ListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(selectionChanged(QListViewItem*)));

	ItemList.setAutoDelete(TRUE);

	QPushButton	*add = new QPushButton(i18n("Add"),this);
	add->setGeometry(290,30,70,30);
	connect(add,SIGNAL(clicked()),SLOT(addClicked()));
	QPushButton	*del = new QPushButton(i18n("Delete"),this);
	del->setGeometry(290,80,70,30);
	connect(del,SIGNAL(clicked()),SLOT(deleteClicked()));
	QPushButton	*mod = new QPushButton(i18n("Modify"),this);
	mod->setGeometry(290,130,70,30);
	connect(mod,SIGNAL(clicked()),SLOT(modifyClicked()));

	QLabel	*lab1 = new QLabel(i18n("Type"),this);
	lab1->setGeometry(20,130,100,25);
	QLabel	*lab2 = new QLabel(i18n("Width"),this);
	lab2->setGeometry(195,130,80,25);
	QLabel	*lab3 = new QLabel(i18n("Date format :"),this);
	lab3->setGeometry(20,195,110,25);

	Type = new QComboBox(this);
	Type->setGeometry(20,160,150,25);

	Width = new QLineEdit(this);
	Width->setGeometry(195,160,80,25);

	DateFormat = new QComboBox(this);
	DateFormat->setGeometry(140,195,130,25);
	DateFormat->insertItem(i18n("Date & Time"));
	DateFormat->insertItem(i18n("Date"));
	DateFormat->insertItem(i18n("Time"));
	DateFormat->insertItem(i18n("Condensed"));

	resize(390,235);
}

OptionsDetail::~OptionsDetail()
{
}

void OptionsDetail::addClicked()
{
	if (ItemList.count() == 5)
		QMessageBox::critical(this,i18n("Error"),i18n("Can't have more than 5 columns"),QMessageBox::Ok | QMessageBox::Default,0);
	else {
		QString	num, width(Width->text());
		num.setNum(Type->currentItem());
		QListViewItem	*item = new QListViewItem(ListView,ItemList.last(),Type->currentText(),(width.isEmpty() ? "0" : width.data()),num.data());
		ItemList.append(item);
		Modified = TRUE;
	}
}

void OptionsDetail::deleteClicked()
{
	if (ItemList.count() == 1)
		QMessageBox::critical(this,i18n("Error"),i18n("You must define at least one column"),QMessageBox::Ok | QMessageBox::Default,0);
	else {
		QListViewItem	*item = ListView->currentItem();
		if (item) { ItemList.removeRef(item); Modified = TRUE;}
	}
}

void OptionsDetail::modifyClicked()
{
	QListViewItem	*item = ListView->currentItem();
	if (item) {
		QString	num, width(Width->text());
		item->setText(0,Type->currentText());
		item->setText(1,(width.isEmpty() ? "0" : width.data()));
		num.setNum(Type->currentItem());
		item->setText(3,num.data());
		Modified = TRUE;
	}
}

void OptionsDetail::setColumns(QStrList& ColType, QStrList& ColWidth, QString *ColName)
{
	for (int i=0;i<5;i++) Type->insertItem(ColName[i].data());
	QString	num;
	for (int i=ColType.count()-1;i>=0;i--) {
		num = ColType.at(i);
		QListViewItem	*item = new QListViewItem(ListView,ColName[num.toInt()],ColWidth.at(i),num.data());
		ItemList.insert(0,item);
	}
}

void OptionsDetail::selectionChanged(QListViewItem *item)
{
	Width->setText(item->text(1));
	QString	num = item->text(2);
	Type->setCurrentItem(num.toInt());
}

void OptionsDetail::getColumns(QStrList& ColType, QStrList& ColWidth)
{
	ColType.clear();
	ColWidth.clear();
	QListIterator<QListViewItem>	it(ItemList);
	for (;it.current();++it) {
		ColType.append(it.current()->text(2));
		ColWidth.append(it.current()->text(1));
	}
}

