#include <iostream.h>
#include <kapp.h>
#include "kpiconloader.h"

KPIconLoader::KPIconLoader(const QString& pathname, bool useKDE)
{
	Path.setAutoDelete(TRUE);
	KDEPath.setAutoDelete(TRUE);
	UseKDE = useKDE;
	Icons.setAutoDelete(TRUE);
	QString		tmp(pathname.data());
	char *c = strtok(tmp.data(),";");
	while (c != 0) {
		QString		*tmp = new QString(c);
		Path.append(tmp);
		c = strtok(0,";");
	}
	Icons.insert("nulPixmap",new QPixmap);
	QString	*localkdedir = new QString(KApplication::localkdedir());
	(*localkdedir) += "/share/icons";
	KDEPath.append(localkdedir);
	QString	*kdedir = new QString(KApplication::kde_icondir());
	KDEPath.append(kdedir);
}

QPixmap* KPIconLoader::loadIcon(const QString& name, const QString& def)
{
	QPixmap	*icon = 0;
	if ((icon = Icons.find((const char*)name))) return icon;
	QListIterator<QString>	*it;
	if (UseKDE) it = new QListIterator<QString>(KDEPath);
	else it = new QListIterator<QString>(Path);
	for ( ; it->current(); ++(*it)) {
		icon = new QPixmap((const char*)(*(it->current()) + "/" + name));
		if (icon->isNull()) {delete icon; icon = 0;}
		else {
			Icons.insert((const char*)name,icon);
			delete it;
			return icon;
		}	
	}
	delete it;
	if (def.isEmpty()) return Icons.find("nulPixmap");
	else return loadIcon(def);
}

QPixmap* KPIconLoader::loadKDEIcon(const QString& name)
{
	QPixmap	*icon = 0;
	if ((icon = Icons.find((const char*)("kde/" + name)))) return icon;
	QListIterator<QString>	it(KDEPath);
	for ( ; it.current(); ++it) {
		icon = new QPixmap((const char*)(*it.current() + "/mini/" + name));
		if (icon->isNull()) { delete icon; icon = 0;}
		else {
			Icons.insert((const char*)("kde/" + name),icon);
			return icon;
		}
	}
	return Icons.find("nulPixmap");
}

QPixmap* KPIconLoader::loadMiniIcon(const QString& name, const QString& def)
{
	QPixmap	*icon = 0;
	if ((icon = Icons.find((const char*)("mini/" + name)))) return icon;
	QListIterator<QString>	*it;
	if (UseKDE) it = new QListIterator<QString>(KDEPath);
	else it = new QListIterator<QString>(Path);
	for ( ; it->current(); ++(*it)) {
		icon = new QPixmap((const char*)(*(it->current()) + "/mini/" + name));
		if (icon->isNull()) {delete icon; icon = 0;}
		else {
			Icons.insert((const char*)("mini/" + name),icon);
			delete it;
			return icon;
		}
	}
	delete it;
	if (def.isEmpty()) return Icons.find("nulPixmap");
	else return loadMiniIcon(def);
}

QPixmap* KPIconLoader::loadToolBarIcon(const QString& name)
{
	QPixmap	*icon = 0;
	if ((icon = Icons.find((const char*)("toolbar/" + name)))) return icon;
	QListIterator<QString>	it(Path);
	for ( ; it.current(); ++it) {
		icon = new QPixmap((const char*)(*it.current() + "/toolbar/" + name));
		if (icon->isNull()) {delete icon; icon = 0;}
		else {
			Icons.insert((const char*)("toolbar/" + name),icon);
			return icon;
		}	
	}
	return Icons.find("nulPixmap");
}

void KPIconLoader::reloadIcons(bool useKDE, const QString& str)
{
	QDictIterator<QPixmap>	itp(Icons);
	QListIterator<QString>	*its;
	UseKDE = useKDE;
	if (!UseKDE) {
		QString		tmp(str.data());
		char	*c = strtok(tmp.data(),";");
		Path.clear();
		while (c) {
			QString		*tmp2 = new QString(c);
			Path.append(tmp2);
			c = strtok(0,";");
		}
		its = new QListIterator<QString>(Path);
	}
	else its = new QListIterator<QString>(KDEPath);
	for ( ; itp.current(); ++itp) {
		if (strncmp(itp.currentKey(),"toolbar",7) == 0 || strcmp(itp.currentKey(),"nulPixmap") == 0 || strncmp(itp.currentKey(),"kde",3) == 0) continue;
		*(itp.current()) = changeIcon(its,itp.currentKey());
	}
}

QPixmap KPIconLoader::changeIcon(QListIterator<QString> *it, const char *name)
{
	QPixmap		retval;
	it->toFirst();
	for ( ; it->current(); ++(*it)) {
		retval = QPixmap((const char*)(*(it->current()) + "/" + QString(name)));
		if (!retval.isNull()) break;
	}
	return retval;
}

