#ifndef _KMIME_H_
#define _KMIME_H_

#include <qlist.h>
#include <qdict.h>
#include <qstrlist.h>
#include <ksimpleconfig.h>
#include <iostream.h>

class KMimeApplication
{
public:
	KMimeApplication(const QString& filename)
		: FileName(filename.data()), changed(FALSE)
	{
		KSimpleConfig	conf(filename,TRUE);
		conf.setGroup("KDE Desktop Entry");
		if (conf.readEntry("Type") != "Application") FileName = "";
		else {
			AppName = conf.readEntry("Name");
			Description = conf.readEntry("Comment");
			ExecString = conf.readEntry("Exec");
//			int	p = ExecString.find(' ');
//			if (p != -1) ExecString.truncate(p);
			MimeIcon = conf.readEntry("Icon");
			inShell = conf.readNumEntry("Terminal",0);
			QString		tmp = conf.readEntry("MimeType");
			if (!tmp.isEmpty() && tmp[tmp.length()-1] != ';') tmp += ";";
			int	pos = 0, len;
			while ((len = tmp.find(';',pos)-pos) > 0) {
				MimeTypes.append(tmp.mid(pos,len).data());
				pos += (len+1);
			}
			if (inShell) {
				QString		prog=ExecString.data(), option=conf.readEntry("TerminalOptions");
				ExecString.sprintf("%%shell %s -e %s ",option.data(),prog.data());
			}
		}
	}
	int nMimeType() { return (int)(MimeTypes.count());}
	const char* mimeType(int i) { return MimeTypes.at(i);}

	QString		FileName;
	QString		AppName;
	QString		Description;
	QString		ExecString;
	QString		MimeIcon;
	QStrList	MimeTypes;
	bool		inShell;
	bool		changed;
};

typedef QDict<KMimeApplication>	KMimeAppDict;
typedef QDictIterator<KMimeApplication>	KMimeAppDictIterator;

typedef QList<KMimeApplication>	KMimeAppListBase;
typedef QListIterator<KMimeApplication>	KMimeAppListIterator;

class KMimeAppList : public KMimeAppListBase
{
public:
	KMimeAppList() : KMimeAppListBase() {}

protected:
#define	IT1	((KMimeApplication*)(item1))
#define	IT2	((KMimeApplication*)(item2))
	virtual int compareItems(GCI item1, GCI item2)
	{ return strcmp(IT1->ExecString.data(),IT2->ExecString.data());}
#undef	IT1
#undef	IT2
};

//--------------------------------------------------------------------------------------

class KMimeExtension
{
public:
	KMimeExtension(const QString& filename)
		: FileName(filename.data()), changed(FALSE)
	{
		KSimpleConfig	conf(filename.data(),TRUE);
		conf.setGroup("KDE Desktop Entry");
		if (conf.readEntry("Type") != "MimeType") FileName = "";	// not a KDE MimeType file
		else {
			MimeName = conf.readEntry("MimeType");
			Description = conf.readEntry("Comment");
			MimeIcon = conf.readEntry("Icon");
			Application = "None";
			inShell = FALSE;
			QString		tmp(conf.readEntry("Patterns"));
			if (!tmp.isEmpty() && tmp[tmp.length()-1] != ';') tmp += ";";
			int	pos = 0, len;
			while ((len = tmp.find(';',pos)-pos) > 0) {
				Extensions.append(tmp.mid(pos,len).data());
				pos += (len+1);
			}
		}
	}
	KMimeExtension(const QString& mime, const QString& ext, const QString& applic, const QString& type, const QString& icon, bool shell)
		: MimeName(mime.data()), Application(applic.data()), Description(type.data()), MimeIcon(icon.data()), inShell(shell), changed(FALSE)
	{
		QString		tmp(ext);
		if (!tmp.isEmpty() && tmp[tmp.length()-1] != ';') tmp += ";";
		int	pos = 0, len;
		while ((len = tmp.find(';',pos)-pos) > 0) {
			Extensions.append(tmp.mid(pos,len).data());
			pos += (len+1);
		}
	}
	~KMimeExtension()
	{
		if (!FileName.isEmpty() && changed) {
			KSimpleConfig	conf(FileName,FALSE);
			conf.setGroup("[KDE DesktopEntry]");
			conf.writeEntry("Type","MimeType");
			conf.writeEntry("MimeType",MimeName.data());
			conf.writeEntry("Comment",Description.data());
			conf.writeEntry("Icon",MimeIcon.data());
			QString		tmp;
			for (uint i=0;i<Extensions.count();i++) {
				tmp += Extensions.at(i);
				tmp += ";";
			}
			conf.writeEntry("Patterns",tmp.data());
		}
	}
	int nExtension() { return (int)(Extensions.count());}
	const char* extension(int i) { return Extensions.at(i);}

	QString		FileName;
	QString		MimeName;
	QStrList	Extensions;
	QString		Application;
	QString		Description;
	QString		MimeIcon;
	bool		inShell;
	bool		changed;
	QList<KMimeApplication>	MimeApplications;
};

typedef QList<KMimeExtension>	KMimeExtListBase;
typedef QListIterator<KMimeExtension>	KMimeExtListIterator;

typedef QDict<KMimeExtension>	KMimeExtDict;
typedef QDictIterator<KMimeExtension>	KMimeExtDictIterator;

class KMimeExtList : public KMimeExtListBase
{
public:
	KMimeExtList() : KMimeExtListBase() {}

protected:
#define	IT1	((KMimeExtension*)(item1))
#define	IT2	((KMimeExtension*)(item2))
	virtual int compareItems(GCI item1, GCI item2)
	{ return strcmp(IT1->Description.data(),IT2->Description.data());}
#undef	IT1
#undef	IT2
};

//--------------------------------------------------------------------------------------

inline void associateMimeTypes(KMimeAppList *appList, KMimeExtDict *extDict)
{
	KMimeAppListIterator	it(*appList);
	for ( ; it.current(); ++it)
		for (int i=0; i<it.current()->nMimeType(); i++) {
			KMimeExtension	*current = extDict->find(it.current()->mimeType(i));
			if (current) {
				current->Application = it.current()->ExecString.data();
				current->MimeApplications.append(it.current());
			}
		}
}

#endif

