#ifndef _FILEPROT_H_
#define _FILEPROT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_DIRENT_H
#include <dirent.h>
#elif HAVE_NDIR_H
#include <ndir.h>
#elif HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#elif HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif

#define	MAXBUFFER	65536

//#include <qdir.h>
#include "protocol.h"

class FileProtocol : public Protocol
{
public:
	FileProtocol(const char *path = 0);
	~FileProtocol();

//	bool cd(const char *path);
//	bool cdUp();
//	int sorting();
//	void setSorting(int sort);
//	int filter();
//	void setFilter(int filt);
	const FileInfoList* entryInfoList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const QStrList* entryList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
//	bool isReadable();
	bool mkdir(const char *pathname);
	QString absPath();
	bool setPath(const char *pathname);
	QString dirName();
	bool remove(const char *filename);
	bool rmdir(const char *dirname, ProgressDlg *dlg = 0);
	bool isRoot();
	bool rename(const char *src, const char *dest);
	bool exists(const char *filename);
	bool chmod(const char *filename, int perm);

	bool copyToProtocol(const char *filename, const char *targetDir = 0, bool move = 0, ProgressDlg *dlg = 0);
	bool copyFromProtocol(const char *filename, const char *targetDir, bool move = 0, ProgressDlg *dlg = 0);
	bool init();
	virtual bool finish() { return TRUE;}
	bool cleanup();
	bool matchURL(KURL url);
	const char* currentURL();
	bool isLocal();
	uint freeSize(const char *dirname);
	bool hasChilds(const char *dirname);
	FileInfo* getInfo(KURL& url);

protected:
//	QDir	*dir;
	QString	CurrentPath;
	bool	rescanFlag;
	FileInfoList	*entries;
	QStrList	*namedEntries;
	int	in, out;
	DIR	*_dir;
	char	*buffer;

	void setFlag();
	void updateEntries(bool hidden = FALSE, bool dirsOnly = FALSE, bool showArchive = FALSE);
	void* thread_protocolCmd(ProtocolCmd *cmd);
	void thread_protocolCleanup(ProtocolCmd *cmd);
	bool copyFile(const char *source, const char *target, bool move, ProgressDlg *dlg);
	bool copyDir(const char *source, const char *target, bool move, ProgressDlg *dlg);
	bool removeFile(const char *name, ProgressDlg *dlg = 0);
	bool removeDir(const char *name, ProgressDlg *dlg = 0);

private:
	bool thread_copyToProtocol(const char *filename, const char *targetDir = 0, bool move = 0, ProgressDlg *dlg = 0);
	bool thread_copyFromProtocol(const char *filename, const char *targetDir, bool move = 0, ProgressDlg *dlg = 0);
	void thread_updateEntries(bool hidden = FALSE, bool dirsOnly = FALSE, bool showArchive = FALSE);
	bool thread_rmdir(const char *dirname);
	void completePath();
};

inline void FileProtocol::completePath()
{ if (CurrentPath.right(1) != "/") CurrentPath += "/";}

inline void FileProtocol::setFlag()
{ rescanFlag = TRUE;}

inline FileProtocol::FileProtocol(const char *path) : Protocol(Protocol::File)
{ CurrentPath = path; completePath(); entries = new FileInfoList; namedEntries = new QStrList(TRUE); setFlag(); Prefix = "file:"; Prefix += path; if (Prefix.right(1) != "/") Prefix += "/";}

inline FileProtocol::~FileProtocol()
{ delete entries; delete namedEntries;}

/*inline bool FileProtocol::cd(const char *path)
{ setFlag(); return dir->cd(path);}

inline bool FileProtocol::cdUp()
{ setFlag(); return dir->cdUp();}

inline int FileProtocol::sorting()
{ return dir->sorting();}

inline void FileProtocol::setSorting(int sort)
{ setFlag(); dir->setSorting(sort);}

inline int FileProtocol::filter()
{ return dir->filter();}

inline void FileProtocol::setFilter(int filt)
{ setFlag(); dir->setFilter(filt);}

inline bool FileProtocol::isReadable()
{ return dir->isReadable();}
*/
inline bool FileProtocol::mkdir(const char *path)
{ setFlag(); return (::mkdir(path,0777) == 0);}

inline QString FileProtocol::absPath()
{ return CurrentPath;}

inline bool FileProtocol::setPath(const char *path)
{ setFlag(); if (*path != '/') CurrentPath += path; else CurrentPath = path; completePath(); return TRUE;}

inline bool FileProtocol::remove(const char *filename)
{ setFlag(); return (::remove(filename) == 0);}

inline bool FileProtocol::chmod(const char *filename, int perm)
{ setFlag(); if (::chmod(filename,perm) == 0) return TRUE; else return FALSE;}

inline bool FileProtocol::isRoot()
{ return (CurrentPath == "/" || CurrentPath.isEmpty());}

inline bool FileProtocol::rename(const char *src, const char *dest)
{ setFlag(); return (::rename(src,dest) == 0);}

inline bool FileProtocol::exists(const char *filename)
{ return (::access(filename,F_OK) == 0);}

inline bool FileProtocol::isLocal()
{ return TRUE;}

#endif

