#ifndef _PROGRESSDLG_H_
#define _PROGRESSDLG_H_

#include <qwidget.h>
#include <qdrawutil.h>
#include <qstring.h>
#include <qpainter.h>
#include <qsemimodal.h>
#include <qpushbutton.h>
#include <qpixmap.h>

//------------------------------------------------------------------------------------------

class SyncLabel : public QWidget
{
public:
	SyncLabel(const char *text, QWidget *parent = 0, const char *name = 0);
	SyncLabel(QWidget *parent = 0, const char *name = 0);
	virtual ~SyncLabel();

	void setText(const char *text);

protected:
	virtual void paintEvent(QPaintEvent *);

private:
	QString		Text;
};

//------------------------------------------------------------------------------------------

class SyncProgress : public QWidget
{
public:
	SyncProgress(int min, int max, QWidget *parent = 0, const char *name = 0);
	virtual ~SyncProgress();

	void setValue(int val);
	void setPercent(int val);

protected:
	virtual void paintEvent(QPaintEvent *);

private:
	int	Min, Max;
	int	Value;
	bool	PercentSet;
};

//------------------------------------------------------------------------------------------

class ProgressDlg : public QSemiModal
{
	Q_OBJECT;

public:
	ProgressDlg(const char *labelText, const char *cancelText, int totalSteps, QWidget *parent = 0, const char *name = 0, bool modal = TRUE, WFlags f = 0);
	virtual ~ProgressDlg();

	void setProgress(int value);
	void setAbsoluteValue(int val);
	void setLabelText(const char *text, const char *text2 = 0);

public slots:
	void reset();

signals:
	void cancelled();

private:
	SyncProgress	*Bar;
	SyncLabel	*Label;
	SyncLabel	*Label2;
	int		TotalSteps;
	QPushButton	*Cancel;
};

#endif
