/***************************************************************************
                          keasycd.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Feb  7 09:35:03 MET 1999
                                           
    copyright            : (C) 1999 by Marcel Borred                         
    email                : marcel.borreda@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <keasycd.h>

#include "resource.h"


extern QString mkfiles;
extern QString audiofileslist;
KEasyCDView *kview;

KEasyCDApp::KEasyCDApp()
{
  setCaption("KEasyCD "  VERSION);
  ///////////////////////////////////////////////////////////////////
  // create basics 
  recentList = new QStrList(true);
  recentList->setAutoDelete(true);

  ///////////////////////////////////////////////////////////////////
  // read the config file options


  ///////////////////////////////////////////////////////////////////
  // call init() to invoke all other construction parts
  init();

}

KEasyCDApp::~KEasyCDApp()
{

}

void KEasyCDApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menu_bar->setItemEnabled(id_,true);
  tool_bar_0->setItemEnabled(id_,true);
}

void KEasyCDApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menu_bar->setItemEnabled(id_,false);
  tool_bar_0->setItemEnabled(id_,false);
}


void KEasyCDApp::init()
{ 

  ///////////////////////////////////////////////////////////////////
  // set up the base application features
  initMenuBar();
  initToolBars();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar_0)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menu_bar->setMenuBarPos(menu_bar_pos);
  tool_bar_0->setBarPos(tool_bar_0_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
/*  disableCommand(ID_FILE_SAVE);
  disableCommand(ID_FILE_SAVE_AS);
  disableCommand(ID_FILE_PRINT);
  disableCommand(ID_EDIT_CUT);
  disableCommand(ID_EDIT_COPY);*/
}

void KEasyCDApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  


  ///////////////////////////////////////////////////////////////////
  // file_menu entry file_menu_recent  (for recent documents)


  QPopupMenu *file_menu_recent = new QPopupMenu();
  for (uint i = 0; i < recentList->count(); i++)
    file_menu_recent->insertItem(recentList->at(i));


  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  QPopupMenu *file_menu = new QPopupMenu();
 // file_menu->insertItem(Icon("mini/keasycdapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  //file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
 // file_menu->insertItem(i18n("Open &recent..."), file_menu_recent, ID_FILE_RECENT );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(i18n("Save &as"), ID_FILE_SAVE_AS );
 // file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  //file_menu->insertSeparator();
 // file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  //file_menu->insertSeparator();
 // file_menu->insertItem(i18n("C&lose Widow"), ID_FILE_CLOSE_WINDOW);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_APP_EXIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
  file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_S, ID_FILE_SAVE);
  //file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE);
  //file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  file_menu->setAccel(CTRL+Key_Q, ID_APP_EXIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  //QPopupMenu *edit_menu = new QPopupMenu();
  //edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
  //edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
  //edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );
 
  //edit_menu key accelerators
 // edit_menu->setAccel(CTRL+Key_X, ID_EDIT_CUT);
 // edit_menu->setAccel(CTRL+Key_C, ID_EDIT_COPY);
 // edit_menu->setAccel(CTRL+Key_V, ID_EDIT_PASTE);

 
  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  QPopupMenu *view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR_0);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR_0, bViewToolbar_0);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QPopupMenu *help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menu_bar the current menuBar and the position due to config file
  menu_bar = menuBar();
  menu_bar->insertItem(i18n("&File"), file_menu);
  //menu_bar->insertItem(i18n("&Edit"), edit_menu);
  menu_bar->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menu_bar->insertSeparator(); 
  menu_bar->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
//  CONNECT_CMD(edit_menu);
  CONNECT_CMD(view_menu);

  //connect(file_menu_recent, SIGNAL(activated(int)),SLOT(slotFileRecent(int)));  

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC CONNECTS HERE



}
void KEasyCDApp::initToolBars()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set tool_bar_0 the current toolBar and the position due to config file
  tool_bar_0 = toolBar(0);
  tool_bar_0->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));
  tool_bar_0->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File"));
  tool_bar_0->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
 // tool_bar_0->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
 // tool_bar_0->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
 // tool_bar_0->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut"));
 // tool_bar_0->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  tool_bar_0->insertSeparator();
  tool_bar_0->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menu_bar and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(tool_bar_0);

}

void KEasyCDApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  //set status_bar the current statusBar
  status_bar = statusBar(); 
  status_bar->insertItem(IDS_DEFAULT, ID_STATUS_MSG );

}

void KEasyCDApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
 
  view = new KEasyCDView(this);
  doc = new KEasyCDDoc(view);
  kview=view;

  setView(view); 
  // TODO: Add a connect() from viewchanged or something to doc->setModified()

  bViewEnabled = true;
  this->resize(rMainGeom.width(), rMainGeom.height());
//readoptions
  KConfig *config = kapp->getConfig();

  config->setGroup("FILES");

  config->readListEntry("RecentList", *recentList);


  config->setGroup("APPEARANCE");
//  rMainGeom = config->readRectEntry("MainGeometry",&QRect(0,0,500,400));
  bViewToolbar_0 = config->readBoolEntry("ShowToolbar_0", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
  tool_bar_0_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_0_Pos", KToolBar::Top);

}



void KEasyCDApp::resizeEvent(QResizeEvent *evt)
{
    KTMainWindow::resizeEvent(evt);

    rMainGeom= this->geometry();
    view->resize(rMainGeom.width(),rMainGeom.height());
    updateRects();
}

void KEasyCDApp::addRecent(const char *filename)
{
  if(filename && strlen(filename) == 0 || recentList->contains(filename))
    return;

  if(recentList->count() < 5)
    recentList->insert(0,filename);
  else
    {
      recentList->remove(4);
      recentList->insert(0,filename);
    }
  file_menu_recent->clear();
  
  for(int i=0; i< (int)recentList->count(); i++)
    file_menu_recent->insertItem(recentList->at(i));

}

void KEasyCDApp::dlgModified()
{
  int qret=KMsgBox::yesNoCancel(this, i18n("Warning"),		
	    i18n("The current file has been modified. \nSave Changes ?"));     
  switch (qret)
   {
   case 1:
     slotFileSave();
     break;
   case 2:
     break;
   case 3:
     return;
     break;
   default:
     break;
   }
}

bool KEasyCDApp::queryExit()
{
  //int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));
 if(mkfiles!="" || audiofileslist!="")
querySave();

    return true;

}

void KEasyCDApp::saveOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("FILES");
  config->writeEntry("RecentList", *recentList);

  config->setGroup("APPEARANCE");
  config->writeEntry("MainGeometry",rMainGeom);
  config->writeEntry("ShowToolbar_0",tool_bar_0->isVisible());
  config->writeEntry("ShowStatusbar",status_bar->isVisible());
  config->writeEntry("MenuBarPos", (int)menu_bar->menuBarPos());
  config->writeEntry("ToolBar_0_Pos", (int)tool_bar_0->barPos());

  config->setGroup("RECOPTIONS");
//CHECKBOXES
  config->writeEntry("SIMULATE",view->dummy->isChecked());

config->writeEntry("VERBSCSI",view->cdrecverbosescsi->isChecked());
config->writeEntry("SHOWBUFF",view->cdrecshowbuffer->isChecked());
config->writeEntry("DEBUG",view->debug->isChecked());
config->writeEntry("MULTI",view->multi->isChecked());
config->writeEntry("NOFIX",view->nofix->isChecked());
config->writeEntry("LOAD",view->load->isChecked());
config->writeEntry("EJECT",view->eject->isChecked());
config->writeEntry("PREEMP",view->preemp->isChecked());
config->writeEntry("PAD",view->pad->isChecked());
config->writeEntry("SWAP",view->swap->isChecked());
config->writeEntry("IGNSIZE",view->ignsize->isChecked());
config->writeEntry("NOCLOSE",view->noclose->isChecked());

config->writeEntry("BOOTABLECD",view->bootablecd->isChecked());
config->writeEntry("ONTHEFLY",view->onthefly->isChecked());
config->writeEntry("PARACHECK",view->cdparacheck->isChecked());




config->setGroup("FILESYSTEM");
config->writeEntry("SUSPRR",view->susprr->isChecked());
config->writeEntry("SUSPRR2",view->susprr2->isChecked());
config->writeEntry("GENERATETBL",view->generatetbl->isChecked());
config->writeEntry("GENERATESUSPC",view->generatesuspforcompressed->isChecked());
config->writeEntry("JOLIET",view->joliet->isChecked());
config->writeEntry("NODEEPDIR",view->nodeepdirreloc->isChecked());
config->writeEntry("FOLLOWSYMLINKS",view->followsymlinks->isChecked());
config->writeEntry("SUNOSBUG",view->sunos414cdbugcomponets->isChecked());
config->writeEntry("SUNOSBIG",view->sunos414cdbigfields->isChecked());
config->writeEntry("ALLFILES",view->allfiles->isChecked());
config->writeEntry("TRAILING",view->trailingperiod->isChecked());
config->writeEntry("ALLOW32",view->allow32cfilenames->isChecked());
config->writeEntry("ALLOWDOT",view->allowdot->isChecked());
config->writeEntry("OMITVER",view->omitversionnumbers->isChecked());

//RADIO
config->setGroup("BLANK");
config->writeEntry("BLANKALL",view->blankall->isChecked());
config->writeEntry("BLANKFAST",view->blankfast->isChecked());
config->writeEntry("BLANKTRACK",view->blanktrack->isChecked());
config->writeEntry("BLANKUNRESERVE",view->blankunreserve->isChecked());
config->writeEntry("BLANKTRTAIL",view->blanktrtail->isChecked());
config->writeEntry("BLANKUNCLOSE",view->blankunclose->isChecked());
config->writeEntry("BLANKSESSION",view->blanksession->isChecked());

//LINEEDIT
config->setGroup("STRINGS");
config->writeEntry("VID",view->volumeid->text());
config->writeEntry("PUID",view->publisherid->text());
config->writeEntry("PID",view->preparerid->text());
config->writeEntry("APPID",view->appid->text());
config->writeEntry("IMGPATH",view->imagepath->text());
config->writeEntry("PACKSIZE",view->packetsize->text());
config->writeEntry("ELTORITO",view->eltorito->text());
config->writeEntry("BOOTCATALOG",view->bootcatalog->text());

//COMBOS
config->setGroup("COMBOS");

config->writeEntry("FSCOMBO",view->fscombo->currentItem());
config->writeEntry("CDBCOMBO",view->cdbcombo->currentItem());
config->writeEntry("CDRCOMBO",view->cdrcombo->currentItem());
config->writeEntry("CDRSPEED",view->cdrspeed->currentItem());
config->writeEntry("CDBSPEED",view->cdbspeed->currentItem());



}



/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KEasyCDApp::slotFileNewWindow()
{
  (new KEasyCDApp)->show();
}

void KEasyCDApp::slotFileNew()
{
/*  if (doc->isModified())
   this->dlgModified();

  ///////////////////////////////////////////////////////////////////
  // delete the current main view and create new view

  if (!bViewEnabled)
      view = new KEasyCDView(this);
  else
    {
      delete view;
      view = new KEasyCDView(this);
    }
  bViewEnabled = true;
  doc->deleteContents();
  setView(view); 
  view->show();
  updateRects(); 
*/
//needs check if saving is wanted
mkfiles="";
audiofileslist="";
view->datatree->clear();
view->audiotree->clear();
view->datatree->insertItem("CD Data Contents",view->mdatapixmap,-1,TRUE);
view->audiotree->insertItem("CD Audio Contents",view->maudiopixmap,-1,TRUE);

}

void KEasyCDApp::slotFileOpen()
{
  ///////////////////////////////////////////////////////////////////
  // close the actual file
  if (doc->isModified())
      this->dlgModified();  
  ///////////////////////////////////////////////////////////////////
  // open another file
  doc->deleteContents();
  doc->openFile();

}


void KEasyCDApp::slotFileSave()
{
  doc->saveFile();
  disableCommand(ID_FILE_SAVE);

}

void KEasyCDApp::slotFileSaveAs()
{
  doc->saveFile();
  disableCommand(ID_FILE_SAVE); 
}

void KEasyCDApp::slotFileClose()
{
  ///////////////////////////////////////////////////////////////////
  // close the actual file
  if (doc->isModified())
      this->dlgModified();  
  else
    {
      doc->deleteContents();
      delete view;
      bViewEnabled = false;
      disableCommand(ID_FILE_SAVE);
      disableCommand(ID_FILE_SAVE_AS);
      disableCommand(ID_FILE_CLOSE);
      disableCommand(ID_FILE_PRINT);
    }
}

void KEasyCDApp::slotFilePrint()
{
  QPrinter printer;
  if (printer.setup(this))
    {
      QPainter painter;
      painter.begin( &printer );

      ///////////////////////////////////////////////////////////////////
      // TODO: Define printing by using the QPainter methods here

      painter.end();
    };

}

void KEasyCDApp::slotFileCloseWindow()
{
  if (doc->isModified())
    this->dlgModified();
  else close();

}
void KEasyCDApp::slotAppExit()
{ 
  if (doc->isModified())
    this->dlgModified();

  ///////////////////////////////////////////////////////////////////
  // exits the Application
/*  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else return;
*/
if(mkfiles!="" || audiofileslist!="")
querySave();

    saveOptions();
    KTMainWindow::deleteAll();
    kapp->quit();

}

void KEasyCDApp::querySave()
{
KMsgBox box;
if(box.yesNo(this,"Save Project", "Do you like to save your project?")==1)
slotFileSaveAs();

}

void KEasyCDApp::slotViewToolBar_0()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar_0=!bViewToolbar_0;
  menu_bar->setItemChecked(ID_VIEW_TOOLBAR_0, bViewToolbar_0);
  enableToolBar(KToolBar::Toggle,0);

}

void KEasyCDApp::slotViewStatusBar()
{

  ///////////////////////////////////////////////////////////////////
  //turns Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menu_bar->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
}


void KEasyCDApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  status_bar->clear();
  status_bar->changeItem(text, ID_STATUS_MSG );
}


void KEasyCDApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  status_bar->message(text, 2000);
}




///////////////////////////////////////////////////////////////////
// THESE MACROS CONSTRUCT THE SWITCH FOR THE SIGNAL commandCallback(int)


BEGIN_CMD(KEasyCDApp)
  ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow(),      i18n("Opening a new Application window..."))
  ON_CMD(ID_FILE_NEW,                 slotFileNew(),            i18n("Creating new file..."))  
  ON_CMD(ID_FILE_OPEN,                slotFileOpen(),           i18n("Opening file..."))

  ON_CMD(ID_FILE_SAVE,                slotFileSave(),           i18n("Saving file..."))
  ON_CMD(ID_FILE_SAVE_AS,             slotFileSaveAs(),         i18n("Saving file under new filename..."))
  ON_CMD(ID_FILE_CLOSE,               slotFileClose(),          i18n("Closing file..."))

  ON_CMD(ID_FILE_PRINT,               slotFilePrint(),          i18n("Printing your file..."))

  ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow(),    i18n(""))
  ON_CMD(ID_APP_EXIT,                 slotAppExit(),            i18n(""))


  ON_CMD(ID_EDIT_CUT,                 view->slotEditCut(),      i18n("Cutting selection..."))
  ON_CMD(ID_EDIT_COPY,                view->slotEditCopy(),     i18n("Copying selection to Clipboard..."))
  ON_CMD(ID_EDIT_PASTE,               view->slotEditPaste(),    i18n("Inserting Clipboard contents..."))
  

  ON_CMD(ID_VIEW_TOOLBAR_0,           slotViewToolBar_0(),      i18n(""))
  ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar(),      i18n(""))
END_CMD()


///////////////////////////////////////////////////////////////////
// THESE MACROS CONSTRUCT THE SWITCH FOR THE SIGNAL statusCallback(int)


BEGIN_STATUS_MSG(KEasyCDApp)
  ON_STATUS_MSG(ID_FILE_NEW_WINDOW,  i18n("Opens a new application window"))

  ON_STATUS_MSG(ID_FILE_NEW,         i18n("Creates a new document"))
  ON_STATUS_MSG(ID_FILE_OPEN,        i18n("Opens an existing document"))
  ON_STATUS_MSG(ID_FILE_RECENT,      i18n("Opens a recent document"))

  ON_STATUS_MSG(ID_FILE_SAVE,        i18n("Save the actual document"))
  ON_STATUS_MSG(ID_FILE_SAVE_AS,     i18n("Save the document as..."))
  ON_STATUS_MSG(ID_FILE_CLOSE,       i18n("Closes the actual file"))

  ON_STATUS_MSG(ID_FILE_PRINT,       i18n("Prints the current document"))

  ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW,i18n("Closes the current window"))

  ON_STATUS_MSG(ID_APP_EXIT,         i18n("Exits the program"))  


  ON_STATUS_MSG(ID_EDIT_CUT,         i18n("Cuts the selected section and puts it to the clipboard"))
  ON_STATUS_MSG(ID_EDIT_COPY,        i18n("Copys the selected section to the clipboard"))
  ON_STATUS_MSG(ID_EDIT_PASTE,       i18n("Pastes the clipboard contents to actual position"))
  ON_STATUS_MSG(ID_EDIT_SELECT_ALL,  i18n("Selects the whole document contents"))


  ON_STATUS_MSG(ID_VIEW_TOOLBAR_0,   i18n("Enables / disables the actual Toolbar"))
  ON_STATUS_MSG(ID_VIEW_STATUSBAR,   i18n("Enables / disables the Statusbar"))
  ON_STATUS_MSG(ID_VIEW_OPTIONS,     i18n("Set program options"))

END_STATUS_MSG()































