/*
 *kmolwidget.h
 *
 * Copyright (C) 1999 Tomislav Gountchev <tomi@socrates.berkeley.edu>
 */

#ifndef KMOLWIDGET_H 
#define KMOLWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 
  
#include <qwidget.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qlabel.h>
#include "kmolcalc.h"
#include "kmoledit.h"
#include "kmolelements.h"

/**
 * This class is the main view for KMol. It handles user input, passes it to KMOLCALC and
 * displays the result.
 *
 * @short Main view
 * @author Tomislav Gountchev <tomi@socrates.berkeley.edu>
 * @version 0.2
 */
class KMolWidget : public QWidget
{
	Q_OBJECT
public:
	KMolWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KMolWidget();

private slots:
	
/**  
 * Make a call to KMOLCALC to parse the string in FORMULA, if any, and get Mw and EA back.
 */
  void calc();

/** 
 * Clear all text entry / result fields.
 */
  void clear();

/**
 * Call the built in editor to edit the definitions file.
 */
  void callEditor();

private:

  KMolCalc* kmolcalc;
  QLineEdit* formula;
  QMultiLineEdit* anal_display;
  QLabel* result;
};

#endif // KMOLWIDGET_H 
