/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFUrl.h>

/* for the file status */
#include <sys/stat.h>

/*************************************************************************/
char *SFUrl::operator () (int num)
{

  /* verify the number is in range */
  if ((num < 0) || (num >= url.num())) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in SFUrl::MakeLocal\n";
    cerr << "\tOut of array bounds access\n";
    cerr << "\tAccessing element (" << num << ")\n";
    cerr << "\tOf Array [0.." << url.num() << ")\n";
    exit(0);
  }

  /* information about the local file */
  struct stat FileStats;

  /* determine if the file is already local */
  int Status = stat(url[0], &FileStats);

  /* if the file is not local make it so */
  if (Status == -1) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in SFUrl::MakeLocal\n";
    cerr << "\tOnly local url files supported now\n";
    exit(0);
  }

  /* return the created file */
  return(url[0]);

}
/*************************************************************************/

/*************************************************************************/
void SFUrl::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* read the strings */
  url.parse(header, InFile);
  
#ifdef DEBUG_PARSE
  cout << "\tSFUrl: (" << url[0] << ")\n";
#endif

}
/*************************************************************************/

