/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef VISIBILITYSENSOR
#define VISIBILITYSENSOR

// label
#define VisibilitySensorLabel "VisibilitySensor"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <SFBool.h>
#include <SFTime.h>

// class definition
class VisibilitySensor : public SFNode {

 public:

  // constructor
  VisibilitySensor() : SFNode(VisibilitySensorLabel) {
    center[0]     =  0.0;
    center[1]     =  0.0;
    center[2]     =  0.0;
    size[0]       = -1.0;
    size[1]       = -1.0;
    size[2]       = -1.0;
    enabled       = true;
    isActive      = false;
  }
    
  // destructor
  ~VisibilitySensor() {
  }

  // parse
  void parse   (char *, istream &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  VisibilitySensor &operator = (VisibilitySensor &V2) {
    center                   = V2.center;
    size                     = V2.size;
    enabled                  = V2.enabled;
    enterTime                = V2.enterTime;
    exitTime                 = V2.exitTime;
    isActive                 = V2.isActive;
    isValid()                = V2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec3f   center;
  SFVec3f   size;
  SFBool    enabled;

  // event data
  SFTime    enterTime;
  SFTime    exitTime;
  SFBool    isActive;

  // USE-DEF
  SFString  DEF;
  SFString  USE;

};

#endif // VisibilitySensor


