/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef TOUCHSENSOR
#define TOUCHSENSOR

// label
#define TouchSensorLabel "TouchSensor"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFTime.h>
#include <SFVec3f.h>

// class definition
class TouchSensor : public SFNode {

 public:

  // constructor
  TouchSensor() : SFNode(TouchSensorLabel) {
    enabled  = true;
    isOver   = false;
    isActive = false;
  }
    
  // destructor
  ~TouchSensor() {
  }

  // parse
  void parse   (char *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  TouchSensor &operator = (TouchSensor &T2) {
    enabled               = T2.enabled;
    isOver                = T2.isOver;
    isActive              = T2.isActive;
    hitPoint_changed      = T2.hitPoint_changed;
    hitNormal_changed     = T2.hitNormal_changed;
    hitTexCoord_changed   = T2.hitTexCoord_changed;
    hitTexCoord_changed   = T2.hitTexCoord_changed;
    touchTime             = T2.touchTime;
    isValid()             = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }


 protected:

 private:

  // data
  SFBool    enabled;

  // event data
  SFBool    isOver;
  SFBool    isActive;
  SFVec3f   hitPoint_changed;
  SFVec3f   hitNormal_changed;
  SFVec3f   hitTexCoord_changed;
  SFTime    touchTime;

  // USE-DEF
  SFString  DEF;
  SFString  USE;

};

#endif // TouchSensor
