/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFVEC2F
#define SFVEC2F

// label
#define SFVec2fLabel "SFVec2f"

// classes
#include <SFNode.h>
#include <SFFloat.h>

// class definition
class SFVec2f : public SFNode{

 public:

  // constructor
  SFVec2f() : SFNode(SFVec2fLabel) {
  }

  // destructor
  ~SFVec2f() {
  }

  // parse
  void parse (char *, istream      &);

  // operators
  SFFloat & operator [] (int i) {
    if ((i < 0) || (i >= 4)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in SFVec2f::operator[]\n";
      cerr << "\tOut of array bounds access (" << i << ") of (2)\n";
      exit(0);
    }
    return(data[i]); 
  }
  
  // normalize
  double length() {
    double a = data[0]();
    double b = data[1]();
    return(sqrt(a*a + b*b));
  }
  void normalize() {
    double l = length();
    data[0] /= l;
    data[1] /= l;
  }

 protected:

 private:

  // data
  SFFloat data[2];

};

#endif // SFVEC2F


