/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MFCOLOR
#define MFCOLOR

// label
#define MFColorLabel "MFColor"

// classes
#include <SFNode.h>
#include <SFColor.h>

// class definition
class MFColor : public SFNode {

 public:

  // constructor
  MFColor() : SFNode(MFColorLabel) {
    numElements = 0;
    data        = (SFColor *) 0;
  }
  
  // destructor
  ~MFColor() {
    if (data   != (SFColor *) 0) delete[] data;    
    data        = (SFColor *) 0;
    numElements = 0;
  }

  // parse
  void parse(char *, istream &InFile);

  // operators
  MFColor &operator = (MFColor &M2) {
    alloc(M2.numElements);
    for (int i = 0; i < M2.numElements; i++) data[i] = M2.data[i];
    isValid()       = M2.isValid();
    return(*this);
  }

  // access
  int num() {
    return(numElements);
  }
  SFColor  & operator [] (int i) {
    if ((i < 0) || (i >= numElements)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFColor::operator()\n";
      cerr << "\tOut of array bounds access (" << i << ")";
      cerr << " of (" << numElements << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // allocate
  void alloc(int n) {
    isValid() = true;
    numElements = n;
    data = new SFColor[n];
    if (data == (SFColor *) 0) { 
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFColor::alloc(" << n << ")\n";
      cerr << "\tCould not allocate memory\n";
      exit(0);
    }
  }

 protected:

 private:

  // data
  int       numElements;
  SFColor  *data;

};

#endif // MFString
