/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef FOG
#define FOG

// label
#define FogLabel       "Fog"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFString.h>
#include <SFColor.h>
#include <SFInt32.h>
#include <SFBool.h>

// class definition
class Fog : public SFNode {

public:

  // constructor
  Fog():SFNode(FogLabel) {
    fogType         = "LINEAR";
    visibilityRange = 0.0;
    color[0]        = 1.0;
    color[1]        = 1.0;
    color[2]        = 1.0;
    isBound         = false;
  }

  // destructor
  ~Fog() {
  }

  // parse
  void parse   (char         *, istream      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);
  void eventOut(SFString     &, SFNode *);
    
  // operators
  Fog &operator     = (Fog &F2) {
    fogType         = F2.fogType;
    visibilityRange = F2.visibilityRange;
    color           = F2.color;
    isBound         = F2.isBound;
    isValid()       = F2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFString   fogType;
  SFFloat    visibilityRange;
  SFColor    color;

  // event data
  SFBool     isBound;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Fog
